/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.ConfigTreeDefinition;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.util.BlockID;
import bspkrs.util.Coord;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TreeRegistry {
    private Map<String, TreeDefinition> treeDefs;
    private Map<BlockID, String> logToStringMap;
    private TreeDefinition masterDefinition;
    private Map<String, ConfigTreeDefinition> vanTrees;
    private List<BlockID> blacklist;
    private List<Coord> blocksBeingChopped;
    private static TreeRegistry instance;

    public static TreeRegistry instance() {
        if (instance == null) {
            new TreeRegistry();
        }
        return instance;
    }

    protected TreeRegistry() {
        instance = this;
        this.initMapsAndLists();
        this.initVanillaTreeDefs();
    }

    protected void initMapsAndLists() {
        this.treeDefs = new HashMap<String, TreeDefinition>();
        this.logToStringMap = new HashMap<BlockID, String>();
        this.masterDefinition = new TreeDefinition();
        this.blacklist = new ArrayList<BlockID>();
        this.blocksBeingChopped = new ArrayList<Coord>();
    }

    protected void initVanillaTreeDefs() {
        this.vanTrees = new TreeMap<String, ConfigTreeDefinition>();
        this.vanTrees.put("vanilla_oak", new ConfigTreeDefinition().addLogID(new BlockID(17, 0)).addLogID(new BlockID(17, 4)).addLogID(new BlockID(17, 8)).addLogID(new BlockID(17, 12)).addLeafID(new BlockID(18, 0)).addLeafID(new BlockID(18, 8)));
        this.vanTrees.put("vanilla_spruce", new ConfigTreeDefinition().addLogID(new BlockID(17, 1)).addLogID(new BlockID(17, 5)).addLogID(new BlockID(17, 9)).addLogID(new BlockID(17, 13)).addLeafID(new BlockID(18, 1)).addLeafID(new BlockID(18, 9)));
        this.vanTrees.put("vanilla_birch", new ConfigTreeDefinition().addLogID(new BlockID(17, 2)).addLogID(new BlockID(17, 6)).addLogID(new BlockID(17, 10)).addLogID(new BlockID(17, 14)).addLeafID(new BlockID(18, 2)).addLeafID(new BlockID(18, 10)));
        this.vanTrees.put("vanilla_jungle", new ConfigTreeDefinition().addLogID(new BlockID(17, 3)).addLogID(new BlockID(17, 7)).addLogID(new BlockID(17, 11)).addLogID(new BlockID(17, 15)).addLeafID(new BlockID(18, 3)).addLeafID(new BlockID(18, 11)).addLeafID(new BlockID(18, 0)).addLeafID(new BlockID(18, 8)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_brown_mushroom", new ConfigTreeDefinition().addLogID(new BlockID(99, 10)).addLogID(new BlockID(99, 15)).addLeafID(new BlockID(99, 1)).addLeafID(new BlockID(99, 2)).addLeafID(new BlockID(99, 3)).addLeafID(new BlockID(99, 4)).addLeafID(new BlockID(99, 5)).addLeafID(new BlockID(99, 6)).addLeafID(new BlockID(99, 7)).addLeafID(new BlockID(99, 8)).addLeafID(new BlockID(99, 9)).addLeafID(new BlockID(99, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_red_mushroom", new ConfigTreeDefinition().addLogID(new BlockID(100, 10)).addLogID(new BlockID(100, 15)).addLeafID(new BlockID(100, 1)).addLeafID(new BlockID(100, 2)).addLeafID(new BlockID(100, 3)).addLeafID(new BlockID(100, 4)).addLeafID(new BlockID(100, 5)).addLeafID(new BlockID(100, 6)).addLeafID(new BlockID(100, 7)).addLeafID(new BlockID(100, 8)).addLeafID(new BlockID(100, 9)).addLeafID(new BlockID(100, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
    }

    protected void registerVanillaTreeDefs() {
        for (Map.Entry<String, ConfigTreeDefinition> e : this.vanTrees.entrySet()) {
            this.registerTree(e.getKey(), e.getValue());
        }
    }

    public void registerTree(String newKey, TreeDefinition newTD) {
        if (newTD != null) {
            LinkedList<String> sharedLogTrees = new LinkedList<String>();
            HashMap<BlockID, String> toAdd = new HashMap<BlockID, String>();
            for (BlockID blockID : newTD.getLogList()) {
                if (!this.isRegistered(blockID)) {
                    toAdd.put(blockID, newKey);
                    continue;
                }
                if (!this.logToStringMap.containsKey(blockID) || sharedLogTrees.contains(this.logToStringMap.get(blockID))) continue;
                sharedLogTrees.add(this.logToStringMap.get(blockID));
            }
            if (!newKey.trim().isEmpty() && !this.isRegistered(newKey) && sharedLogTrees.size() == 0) {
                TCLog.debug("Tree Definition \"%s\" is new.  Proceeding to insert new key.", newKey);
                this.treeDefs.put(newKey, newTD);
                this.logToStringMap.putAll(toAdd);
            } else if (!newKey.trim().isEmpty()) {
                if (sharedLogTrees.size() > 0) {
                    for (String existingKey : sharedLogTrees) {
                        TCLog.debug("Tree Definition \"%s\" contains a log that is registered with an existing tree (%s).  The existing definition will be merged with the new tree.", newKey, existingKey);
                        newTD.appendWithSettings(this.treeDefs.remove(existingKey));
                    }
                    this.treeDefs.put(newKey, newTD);
                    for (BlockID blockID : newTD.getLogList()) {
                        this.logToStringMap.put(blockID, newKey);
                    }
                } else {
                    TCLog.debug("\"%s\" is already registered.  The new definition will be appended to the existing entry.", newKey);
                    this.treeDefs.get(newKey).appendWithSettings(newTD);
                    this.logToStringMap.putAll(toAdd);
                }
            } else if (sharedLogTrees.size() == 1) {
                String existingTree = (String)sharedLogTrees.remove(0);
                this.treeDefs.get(existingTree).appendWithSettings(newTD);
                for (BlockID log : newTD.getLogList()) {
                    if (this.logToStringMap.containsKey(log)) continue;
                    this.logToStringMap.put(log, existingTree);
                }
                this.masterDefinition.append(newTD);
            } else {
                TCLog.warning("TreeDefinition cannot be registered with an empty Key.", new Object[0]);
                return;
            }
            if (!newKey.trim().isEmpty()) {
                this.masterDefinition.append(this.treeDefs.get(newKey));
            }
        } else {
            TCLog.warning("TreeDefinition cannot be null when registering a tree!", new Object[0]);
        }
    }

    public boolean trackTreeChopEventAt(Coord c) {
        if (!this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.add(c);
            return true;
        }
        return false;
    }

    public void endTreeChopEventAt(Coord c) {
        if (this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.remove(c);
        }
    }

    public String getMultiMineExclusionString() {
        String r = "";
        ArrayList<Integer> processed = new ArrayList<Integer>();
        for (BlockID log : this.masterDefinition.logBlocks) {
            if (processed.contains(log.id)) continue;
            processed.add(log.id);
            r = r + "," + log.id;
        }
        return r.replaceFirst(",", "");
    }

    public TreeDefinition masterDefinition() {
        return this.masterDefinition;
    }

    public boolean isRegistered(String key) {
        return this.treeDefs.containsKey(key);
    }

    public boolean isRegistered(BlockID log) {
        if (!this.blacklist.contains(log)) {
            return this.masterDefinition.isLogBlock(log);
        }
        return false;
    }

    public TreeDefinition get(String key) {
        if (this.isRegistered(key)) {
            return this.treeDefs.get(key);
        }
        return null;
    }

    public TreeDefinition get(BlockID blockID) {
        if (this.isRegistered(blockID)) {
            if (TCSettings.useStrictBlockPairing) {
                String treeKey = this.logToStringMap.get(blockID);
                TreeDefinition treeDef = this.get(this.logToStringMap.get(blockID));
                if (treeDef != null) {
                    return treeDef;
                }
                if (blockID.metadata > -1) {
                    treeKey = this.logToStringMap.get(new BlockID(blockID.id));
                    return this.get(treeKey);
                }
            }
            return this.masterDefinition;
        }
        return null;
    }

    public List<BlockID> masterLogList() {
        return this.masterDefinition.getLogList();
    }

    public List<BlockID> masterLeafList() {
        return this.masterDefinition.getLeafList();
    }

    public Map<String, ConfigTreeDefinition> vanillaTrees() {
        return new TreeMap<String, ConfigTreeDefinition>(this.vanTrees);
    }

    public List<BlockID> blacklist() {
        return new ArrayList<BlockID>(this.blacklist);
    }

    public void readBlacklistFromDelimitedString(String dList) {
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList((String)dList, (String)";");
    }

    protected void readFromNBT(bx ntc) {
        int i;
        this.treeDefs = new HashMap<String, TreeDefinition>();
        cf l = ntc.m("treeDefs");
        for (i = 0; i < l.c(); ++i) {
            bx treeNBT = (bx)l.b(i);
            this.treeDefs.put(treeNBT.i("treeName"), new TreeDefinition(treeNBT));
        }
        this.logToStringMap = new HashMap<BlockID, String>();
        l = ntc.m("logToStringMap");
        for (i = 0; i < l.c(); ++i) {
            cj s = (cj)l.b(i);
            String[] t = s.a.split("=");
            this.logToStringMap.put(new BlockID(t[0], ","), t[1]);
        }
        this.masterDefinition = new TreeDefinition(ntc.l("masterDefinition"));
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList((String)ntc.i("blacklist"), (String)";");
    }

    public void writeToNBT(bx ntc) {
        cf trees = new cf();
        trees.p("treeDefs");
        for (Map.Entry<String, TreeDefinition> e : this.treeDefs.entrySet()) {
            bx tree = new bx();
            e.getValue().writeToNBT(tree);
            tree.a("treeName", e.getKey());
            trees.a((ck)tree);
        }
        ntc.a("treeDefs", (ck)trees);
        cf entries = new cf();
        entries.p("logToStringMap");
        for (Map.Entry<BlockID, String> e : this.logToStringMap.entrySet()) {
            cj s = new cj("", e.getKey() + "=" + e.getValue());
            entries.a((ck)s);
        }
        ntc.a("logToStringMap", (ck)entries);
        bx md = new bx();
        this.masterDefinition.writeToNBT(md);
        ntc.a("masterDefinition", (ck)md);
        ntc.a("blacklist", ListUtils.getListAsDelimitedString(this.blacklist, (String)";"));
    }
}

