/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;

public class TFGenWoodRoots
extends TFGenerator {
    private int rootBlock;
    private int rootMeta;
    private int oreBlock;
    private int oreMeta;

    public TFGenWoodRoots() {
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
        this.oreBlock = TFBlocks.root.cF;
        this.oreMeta = 1;
    }

    @Override
    public boolean a(abv world, Random rand, int x, int y, int z2) {
        if (world.a(x, y, z2) != aqw.y.cF) {
            return false;
        }
        float length = rand.nextFloat() * 6.0f + rand.nextFloat() * 6.0f + 4.0f;
        if (length > (float)y) {
            length = y;
        }
        float tilt = 0.6f + rand.nextFloat() * 0.3f;
        return this.drawRoot(world, rand, x, y, z2, length, rand.nextFloat(), tilt);
    }

    private boolean drawRoot(abv world, Random rand, int x, int y, int z2, float length, float angle, float tilt) {
        return this.drawRoot(world, rand, x, y, z2, x, y, z2, length, angle, tilt);
    }

    private boolean drawRoot(abv world, Random rand, int ox, int oy, int oz, int x, int y, int z2, float length, float angle, float tilt) {
        int limit = 7;
        int[] dest = TFGenWoodRoots.translate(x, y, z2, length, angle, tilt);
        if (ox + limit < dest[0]) {
            dest[0] = ox + limit;
        }
        if (ox - limit > dest[0]) {
            dest[0] = ox - limit;
        }
        if (oz + limit < dest[2]) {
            dest[2] = oz + limit;
        }
        if (oz - limit > dest[2]) {
            dest[2] = oz - limit;
        }
        if (world.a(dest[0], dest[1], dest[2]) != aqw.y.cF) {
            return false;
        }
        int[] lineArray = TFGenWoodRoots.getBresehnamArray(x, y, z2, dest[0], dest[1], dest[2]);
        for (int i = 0; i < lineArray.length; i += 3) {
            this.placeRootBlock(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
        }
        if (length > 8.0f && rand.nextInt(3) > 0) {
            int[] nextSrc = TFGenWoodRoots.translate(x, y, z2, length / 2.0f, angle, tilt);
            float nextAngle = (angle + 0.25f + rand.nextFloat() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.nextFloat() * 0.3f;
            this.drawRoot(world, rand, ox, oy, oz, nextSrc[0], nextSrc[1], nextSrc[2], length / 2.0f, nextAngle, nextTilt);
        }
        if (length > 6.0f && rand.nextInt(4) == 0) {
            int[] ballSrc = TFGenWoodRoots.translate(x, y, z2, length / 2.0f, angle, tilt);
            int[] ballDest = TFGenWoodRoots.translate(ballSrc[0], ballSrc[1], ballSrc[2], 1.5, (angle + 0.5f) % 1.0f, 0.75);
            this.placeRootBlock(world, ballSrc[0], ballSrc[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballSrc[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballSrc[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballSrc[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballDest[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballDest[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballDest[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballDest[1], ballDest[2], this.oreBlock, this.oreMeta);
        }
        return true;
    }

    protected void placeRootBlock(abv world, int x, int y, int z2, int block, int meta) {
        if (TFTreeGenerator.canRootGrowIn(world, x, y, z2)) {
            this.a(world, x, y, z2, block, meta);
        }
    }
}

