/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenMinersTree
extends TFGenerator {
    protected int treeBlock;
    protected int treeMeta;
    protected int branchMeta;
    protected int leafBlock;
    protected int leafMeta;
    protected int rootBlock;
    protected int rootMeta;

    public TFGenMinersTree() {
        this(false);
    }

    public TFGenMinersTree(boolean notify) {
        super(notify);
        this.treeBlock = TFBlocks.magicLog.cF;
        this.treeMeta = 2;
        this.branchMeta = this.treeMeta | 0xC;
        this.leafBlock = TFBlocks.magicLeaves.cF;
        this.leafMeta = 2;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abv world, Random rand, int x, int y, int z2) {
        ajz materialUnder = world.g(x, y - 1, z2);
        if (materialUnder != ajz.b && materialUnder != ajz.c || y >= TFWorld.MAXHEIGHT - 12) {
            return false;
        }
        for (int dy = 0; dy < 10; ++dy) {
            this.putBlockAndMetadata(world, x, y + dy, z2, this.treeBlock, this.branchMeta, true);
        }
        this.putBranchWithLeaves(world, x, y + 9, z2 + 1, true);
        this.putBranchWithLeaves(world, x, y + 9, z2 + 2, false);
        this.putBranchWithLeaves(world, x, y + 8, z2 + 3, false);
        this.putBranchWithLeaves(world, x, y + 7, z2 + 4, false);
        this.putBranchWithLeaves(world, x, y + 6, z2 + 5, false);
        this.putBranchWithLeaves(world, x, y + 9, z2 - 1, true);
        this.putBranchWithLeaves(world, x, y + 9, z2 - 2, false);
        this.putBranchWithLeaves(world, x, y + 8, z2 - 3, false);
        this.putBranchWithLeaves(world, x, y + 7, z2 - 4, false);
        this.putBranchWithLeaves(world, x, y + 6, z2 - 5, false);
        this.putBlockAndMetadata(world, x, y + 1, z2, TFBlocks.magicLogSpecial.cF, 2, true);
        world.a(x, y + 1, z2, TFBlocks.magicLogSpecial.cF, TFBlocks.magicLogSpecial.a(world));
        if (this.hasAirAround((ace)world, x, y - 1, z2)) {
            this.a(world, x, y - 1, z2, this.treeBlock, this.treeMeta);
        } else {
            this.a(world, x, y - 1, z2, this.rootBlock, this.rootMeta);
        }
        int numRoots = 3 + rand.nextInt(2);
        double offset = rand.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, offset, b, x, y, z2);
        }
        return true;
    }

    protected void putBranchWithLeaves(abv world, int bx2, int by, int bz, boolean bushy) {
        this.putBlockAndMetadata(world, bx2, by, bz, this.treeBlock, this.branchMeta, true);
        for (int lx = -1; lx <= 1; ++lx) {
            for (int ly = -1; ly <= 1; ++ly) {
                for (int lz = -1; lz <= 1; ++lz) {
                    if (!bushy && Math.abs(ly) > 0 && Math.abs(lx) > 0) continue;
                    this.putBlockAndMetadata(world, bx2 + lx, by + ly, bz + lz, this.leafBlock, this.leafMeta, false);
                }
            }
        }
    }

    private void buildRoot(abv world, double offset, int b, int bx2, int by, int bz) {
        int[] dest = TFGenMinersTree.translate(bx2, by - b - 2, bz, 6.0, 0.3 * (double)b + offset, 0.8);
        this.drawRoot(world, bx2, by - b - 2, bz, dest[0], dest[1], dest[2]);
    }

    protected void drawRoot(abv world, int sx, int sy, int sz, int dx, int dy, int dz2) {
        if (world.g(dx, dy, dz2).a()) {
            this.drawBresehnam(world, sx, sy, sz, dx, dy, dz2, this.rootBlock, this.rootMeta, true);
        } else {
            int[] lineArray = TFGenMinersTree.getBresehnamArray(sx, sy, sz, dx, dy, dz2);
            for (int i = 0; i < lineArray.length; i += 3) {
                if (world.a(lineArray[i + 0], lineArray[i + 1], lineArray[i + 2]) <= 0 && !TFGenMinersTree.isNearSolid((ace)world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2])) continue;
                this.a(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
            }
        }
    }
}

