/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.List;
import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFMazeCorridor;
import twilightforest.structures.ComponentTFMazeCorridorIronFence;
import twilightforest.structures.ComponentTFMazeCorridorRoots;
import twilightforest.structures.ComponentTFMazeCorridorShrooms;
import twilightforest.structures.ComponentTFMazeDeadEnd;
import twilightforest.structures.ComponentTFMazeDeadEndChest;
import twilightforest.structures.ComponentTFMazeDeadEndFountain;
import twilightforest.structures.ComponentTFMazeDeadEndFountainLava;
import twilightforest.structures.ComponentTFMazeDeadEndPainting;
import twilightforest.structures.ComponentTFMazeDeadEndRoots;
import twilightforest.structures.ComponentTFMazeDeadEndShrooms;
import twilightforest.structures.ComponentTFMazeDeadEndTorches;
import twilightforest.structures.ComponentTFMazeDeadEndTrappedChest;
import twilightforest.structures.ComponentTFMazeMushRoom;
import twilightforest.structures.ComponentTFMazeRoom;
import twilightforest.structures.ComponentTFMazeRoomBoss;
import twilightforest.structures.ComponentTFMazeRoomCollapse;
import twilightforest.structures.ComponentTFMazeRoomExit;
import twilightforest.structures.ComponentTFMazeRoomFountain;
import twilightforest.structures.ComponentTFMazeRoomSpawnerChests;
import twilightforest.structures.ComponentTFMazeRoomVault;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.TFMaze;

public class ComponentTFMinotaurMaze
extends StructureTFComponent {
    private static final int FLOOR_LEVEL = 1;
    TFMaze maze;
    int[] rcoords;
    private int level;

    public ComponentTFMinotaurMaze(int index, int x, int y, int z2, int entranceX, int entranceZ, int level) {
        super(index);
        this.setCoordBaseMode(0);
        this.level = level;
        this.f = StructureTFComponent.getComponentToAddBoundingBox(x, y, z2, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2, 5, this.getRadius() * 2, 0);
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.maze.setSeed(this.f.a * 90342903 + this.f.b * 90342903 ^ this.f.c);
        int nrooms = 7;
        this.rcoords = new int[nrooms * 2];
        this.rcoords[0] = entranceX;
        this.rcoords[1] = entranceZ;
        this.maze.carveRoom1(entranceX, entranceZ);
        for (int i = 1; i < nrooms; ++i) {
            int rz;
            int rx2;
            while (this.isNearRoom(rx2 = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, rz = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, this.rcoords, i == 1 ? 7 : 4)) {
            }
            this.maze.carveRoom1(rx2, rz);
            this.rcoords[i * 2] = rx2;
            this.rcoords[i * 2 + 1] = rz;
        }
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    public ComponentTFMinotaurMaze(int index, int x, int y, int z2, int level) {
        this(index, x, y, z2, 11, 11, level);
    }

    protected ComponentTFMazeRoom makeRoom(Random random, int i, int dx, int dz2) {
        ComponentTFMazeRoom room = null;
        int worldX = this.f.a + dx * 5 - 4;
        int worldY = this.f.b;
        int worldZ = this.f.c + dz2 * 5 - 4;
        room = i == 0 ? new ComponentTFMazeRoom(3 + i, random, worldX, worldY, worldZ) : (i == 1 ? (this.level == 1 ? new ComponentTFMazeRoomExit(3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeRoomBoss(3 + i, random, worldX, worldY, worldZ)) : (i == 2 || i == 3 ? (this.level == 1 ? new ComponentTFMazeRoomCollapse(3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeMushRoom(3 + i, random, worldX, worldY, worldZ)) : (i == 4 ? (this.level == 1 ? new ComponentTFMazeRoomFountain(3 + i, random, worldX, worldY, worldZ) : new ComponentTFMazeRoomVault(3 + i, random, worldX, worldY, worldZ)) : new ComponentTFMazeRoomSpawnerChests(3 + i, random, worldX, worldY, worldZ))));
        return room;
    }

    protected void decorateDeadEndsCorridors(Random random, List list) {
        for (int x = 0; x < this.maze.width; ++x) {
            for (int z2 = 0; z2 < this.maze.depth; ++z2) {
                StructureTFComponent component = null;
                if (!this.maze.isWall(x, z2, x - 1, z2) && this.maze.isWall(x, z2, x + 1, z2) && this.maze.isWall(x, z2, x, z2 - 1) && this.maze.isWall(x, z2, x, z2 + 1)) {
                    component = this.makeDeadEnd(random, x, z2, 3);
                }
                if (this.maze.isWall(x, z2, x - 1, z2) && !this.maze.isWall(x, z2, x + 1, z2) && this.maze.isWall(x, z2, x, z2 - 1) && this.maze.isWall(x, z2, x, z2 + 1)) {
                    component = this.makeDeadEnd(random, x, z2, 1);
                }
                if (this.maze.isWall(x, z2, x - 1, z2) && this.maze.isWall(x, z2, x + 1, z2) && !this.maze.isWall(x, z2, x, z2 - 1) && this.maze.isWall(x, z2, x, z2 + 1)) {
                    component = this.makeDeadEnd(random, x, z2, 0);
                }
                if (this.maze.isWall(x, z2, x - 1, z2) && this.maze.isWall(x, z2, x + 1, z2) && this.maze.isWall(x, z2, x, z2 - 1) && !this.maze.isWall(x, z2, x, z2 + 1)) {
                    component = this.makeDeadEnd(random, x, z2, 2);
                }
                if (!this.maze.isWall(x, z2, x - 1, z2) && !this.maze.isWall(x, z2, x + 1, z2) && this.maze.isWall(x, z2, x, z2 - 1) && this.maze.isWall(x, z2, x, z2 + 1) && this.maze.isWall(x - 1, z2, x - 1, z2 - 1) && this.maze.isWall(x - 1, z2, x - 1, z2 + 1) && this.maze.isWall(x + 1, z2, x + 1, z2 - 1) && this.maze.isWall(x + 1, z2, x + 1, z2 + 1)) {
                    component = this.makeCorridor(random, x, z2, 1);
                }
                if (!this.maze.isWall(x, z2, x, z2 - 1) && !this.maze.isWall(x, z2, x, z2 + 1) && this.maze.isWall(x, z2, x - 1, z2) && this.maze.isWall(x, z2, x + 1, z2) && this.maze.isWall(x, z2 - 1, x - 1, z2 - 1) && this.maze.isWall(x, z2 - 1, x + 1, z2 - 1) && this.maze.isWall(x, z2 + 1, x - 1, z2 + 1) && this.maze.isWall(x, z2 + 1, x + 1, z2 + 1)) {
                    component = this.makeCorridor(random, x, z2, 0);
                }
                if (component == null) continue;
                list.add(component);
                component.a(this, list, random);
            }
        }
    }

    protected ComponentTFMazeDeadEnd makeDeadEnd(Random random, int dx, int dz2, int rotation) {
        int worldX = this.f.a + dx * 5 + 1;
        int worldY = this.f.b;
        int worldZ = this.f.c + dz2 * 5 + 1;
        int decorationType = random.nextInt(8);
        switch (decorationType) {
            default: {
                return new ComponentTFMazeDeadEnd(4, worldX, worldY, worldZ, rotation);
            }
            case 1: {
                return new ComponentTFMazeDeadEndChest(4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return new ComponentTFMazeDeadEndTrappedChest(4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return new ComponentTFMazeDeadEndTorches(4, worldX, worldY, worldZ, rotation);
            }
            case 4: {
                return new ComponentTFMazeDeadEndFountain(4, worldX, worldY, worldZ, rotation);
            }
            case 5: {
                return new ComponentTFMazeDeadEndFountainLava(4, worldX, worldY, worldZ, rotation);
            }
            case 6: {
                return new ComponentTFMazeDeadEndPainting(4, worldX, worldY, worldZ, rotation);
            }
            case 7: 
        }
        return this.level == 1 ? new ComponentTFMazeDeadEndRoots(4, worldX, worldY, worldZ, rotation) : new ComponentTFMazeDeadEndShrooms(4, worldX, worldY, worldZ, rotation);
    }

    protected ComponentTFMazeCorridor makeCorridor(Random random, int dx, int dz2, int rotation) {
        int worldX = this.f.a + dx * 5 + 1;
        int worldY = this.f.b;
        int worldZ = this.f.c + dz2 * 5 + 1;
        int decorationType = random.nextInt(5);
        switch (decorationType) {
            default: {
                return null;
            }
            case 1: {
                return new ComponentTFMazeCorridor(4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return new ComponentTFMazeCorridorIronFence(4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return null;
            }
            case 4: 
        }
        return this.level == 1 ? new ComponentTFMazeCorridorRoots(4, worldX, worldY, worldZ, rotation) : new ComponentTFMazeCorridorShrooms(4, worldX, worldY, worldZ, rotation);
    }

    public void a(aiq structurecomponent, List list, Random random) {
        super.a(structurecomponent, list, random);
        if (this.level == 1) {
            int centerX = this.f.a + (this.f.d - this.f.a) / 2;
            int centerZ = this.f.c + (this.f.f - this.f.c) / 2;
            ComponentTFMinotaurMaze maze = new ComponentTFMinotaurMaze(1, centerX, this.f.b - 10, centerZ, this.rcoords[2], this.rcoords[3], 2);
            list.add(maze);
            maze.a(this, list, random);
        }
        for (int i = 0; i < this.rcoords.length / 2; ++i) {
            int dx = this.rcoords[i * 2];
            int dz2 = this.rcoords[i * 2 + 1];
            ComponentTFMazeRoom room = this.makeRoom(random, i, dx, dz2);
            list.add(room);
            room.a(this, list, random);
        }
        this.decorateDeadEndsCorridors(random, list);
    }

    public boolean a(abv world, Random rand, age sbb) {
        if (this.level == 2) {
            this.a(world, sbb, 0, -1, 0, this.getDiameter() + 2, 6, this.getDiameter() + 2, aqw.E.cF, 0, false);
        }
        this.a(world, sbb, 1, 1, 1, this.getDiameter(), 4, this.getDiameter());
        this.a(world, sbb, 1, 5, 1, this.getDiameter(), 5, this.getDiameter(), TFBlocks.mazestone.cF, 0, aqw.y.cF, 0, this.level == 1);
        this.a(world, sbb, 1, 0, 1, this.getDiameter(), 0, this.getDiameter(), TFBlocks.mazestone.cF, 6, aqw.y.cF, 0, false);
        this.maze.headBlockID = TFBlocks.mazestone.cF;
        this.maze.headBlockMeta = 3;
        this.maze.wallBlockID = TFBlocks.mazestone.cF;
        this.maze.wallBlockMeta = 1;
        this.maze.rootBlockID = TFBlocks.mazestone.cF;
        this.maze.rootBlockMeta = 3;
        this.maze.pillarBlockID = TFBlocks.mazestone.cF;
        this.maze.pillarBlockMeta = 2;
        this.maze.wallVar0ID = TFBlocks.mazestone.cF;
        this.maze.wallVar0Meta = 4;
        this.maze.wallVarRarity = 0.2f;
        this.maze.torchRarity = 0.05f;
        this.maze.tall = 2;
        this.maze.head = 1;
        this.maze.roots = 1;
        this.maze.oddBias = 4;
        this.maze.copyToStructure(world, 1, 2, 1, this, sbb);
        return true;
    }

    public int getMazeSize() {
        return 22;
    }

    public int getRadius() {
        return (int)((double)this.getMazeSize() * 2.5);
    }

    public int getDiameter() {
        return this.getMazeSize() * 5;
    }

    protected boolean isNearRoom(int dx, int dz2, int[] rcoords, int range) {
        if (dx == 1 && dz2 == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx2 = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx2 == 0 && rz == 0 || Math.abs(dx - rx2) >= range || Math.abs(dz2 - rz) >= range) continue;
            return true;
        }
        return false;
    }
}

