/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.TFMaze;

public class ComponentTFHillMaze
extends StructureTFComponent {
    private static final int FLOOR_LEVEL = 1;
    private int hillSize;

    public ComponentTFHillMaze(int i, int x, int y, int z2, int hsize) {
        super(i);
        this.hillSize = hsize;
        this.setCoordBaseMode(0);
        this.f = StructureTFComponent.getComponentToAddBoundingBox(x, y, z2, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2, 5, this.getRadius() * 2, 0);
    }

    public boolean a(abv world, Random rand, age sbb) {
        this.a(world, sbb, 0, 1, 0, this.getDiameter(), 3, this.getDiameter(), 0, 0, false);
        this.a(world, sbb, 0, 0, 0, this.getDiameter(), 0, this.getDiameter(), TFBlocks.mazestone.cF, 0, false);
        this.a(world, sbb, 0, 4, 0, this.getDiameter(), 4, this.getDiameter(), TFBlocks.mazestone.cF, 0, true);
        TFMaze maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        maze.wallBlockID = TFBlocks.mazestone.cF;
        maze.wallBlockMeta = 3;
        maze.torchRarity = 0.05f;
        maze.setSeed(world.H() + (long)(this.f.a * this.f.c));
        int nrooms = this.getMazeSize() / 3;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz;
            int rx2;
            while (this.isNearRoom(rx2 = maze.rand.nextInt(this.getMazeSize() - 2) + 1, rz = maze.rand.nextInt(this.getMazeSize() - 2) + 1, rcoords)) {
            }
            maze.carveRoom1(rx2, rz);
            rcoords[i * 2] = rx2;
            rcoords[i * 2 + 1] = rz;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, 0, 1, 0, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
        return true;
    }

    public int getMazeSize() {
        return this.hillSize == 1 ? 11 : (this.hillSize == 2 ? 19 : 27);
    }

    public int getRadius() {
        return this.getMazeSize() * 2;
    }

    public int getDiameter() {
        return this.getMazeSize() * 4;
    }

    protected boolean isNearRoom(int dx, int dz2, int[] rcoords) {
        if (dx == 1 && dz2 == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx2 = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx2 == 0 && rz == 0 || Math.abs(dx - rx2) >= 3 || Math.abs(dz2 - rz) >= 3) continue;
            return true;
        }
        return false;
    }

    void decorate3x3Rooms(abv world, int[] rcoords, age sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz2 = rcoords[i * 2 + 1];
            dx = dx * 4 + 2;
            dz2 = dz2 * 4 + 2;
            this.decorate3x3Room(world, dx, dz2, sbb);
        }
    }

    void decorate3x3Room(abv world, int x, int z2, age sbb) {
        Random roomRNG = new Random(world.H() ^ (long)(x + z2));
        this.roomSpawner(world, roomRNG, x, z2, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z2, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z2, 8, sbb);
        }
    }

    private void roomSpawner(abv world, Random rand, int x, int z2, int diameter, age sbb) {
        String mobID;
        int rx2 = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z2 + rand.nextInt(diameter) - diameter / 2;
        switch (rand.nextInt(3)) {
            case 1: {
                mobID = "Skeleton";
                break;
            }
            case 2: {
                mobID = "Zombie";
                break;
            }
            default: {
                mobID = "Spider";
            }
        }
        this.placeSpawnerAtCurrentPosition(world, rand, rx2, 1, rz, mobID, sbb);
    }

    private void roomTreasure(abv world, Random rand, int x, int z2, int diameter, age sbb) {
        int rx2 = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z2 + rand.nextInt(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rand, rx2, 1, rz, TFTreasure.labyrinth_room, sbb);
    }
}

