/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class FurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static TreeSet<Integer> efuels;

    static {
        FurnaceRecipeHandler.removeFuels();
    }

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    @Override
    public Class<? extends awv> getGuiClass() {
        return axp.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.furnace", new Object[0]);
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            FurnaceRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") && this.getClass() == FurnaceRecipeHandler.class) {
            yd item;
            HashMap recipes = (HashMap)aaa.a().b();
            HashMap metarecipes = (HashMap)aaa.a().getMetaSmeltingList();
            for (Map.Entry recipe : recipes.entrySet()) {
                item = (yd)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new yd(((Integer)recipe.getKey()).intValue(), 1, -1), item));
            }
            if (metarecipes == null) {
                return;
            }
            for (Map.Entry recipe : metarecipes.entrySet()) {
                item = (yd)recipe.getValue();
                this.arecipes.add(new SmeltingPair(new yd(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(yd result) {
        yd item;
        HashMap recipes = (HashMap)aaa.a().b();
        HashMap metarecipes = (HashMap)aaa.a().getMetaSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (yd)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType(item, result)) continue;
            this.arecipes.add(new SmeltingPair(new yd(((Integer)recipe.getKey()).intValue(), 1, -1), item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (yd)recipe.getValue();
            if (!NEIServerUtils.areStacksSameType(item, result)) continue;
            this.arecipes.add(new SmeltingPair(new yd(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item));
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && this.getClass() == FurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    @Override
    public void loadUsageRecipes(yd ingredient) {
        yd item;
        HashMap recipes = (HashMap)aaa.a().b();
        HashMap metarecipes = (HashMap)aaa.a().getMetaSmeltingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (yd)recipe.getValue();
            if (ingredient.d != (Integer)recipe.getKey()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (yd)recipe.getValue();
            if (ingredient.d != (Integer)((List)recipe.getKey()).get(0) || ingredient.k() != ((Integer)((List)recipe.getKey()).get(1)).intValue()) continue;
            this.arecipes.add(new SmeltingPair(ingredient, item));
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void removeFuels() {
        efuels = new TreeSet();
        efuels.add(aqw.bs.cF);
        efuels.add(aqw.bt.cF);
        efuels.add(aqw.aI.cF);
        efuels.add(aqw.aN.cF);
        efuels.add(aqw.aJ.cF);
        efuels.add(aqw.bo.cF);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (yd item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.d) || (burnTime = asd.a((yd)item)) <= 0) continue;
            afuels.add(new FuelPair(item.m(), burnTime));
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "smelting";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(yd ingred, int burnTime) {
            this.stack = new PositionedStack(ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(yd ingred, yd result) {
            super(FurnaceRecipeHandler.this);
            ingred.b = 1;
            this.ingred = new PositionedStack(ingred, 51, 6);
            this.result = new PositionedStack(result, 111, 24);
        }

        @Override
        public PositionedStack getIngredient() {
            int cycle = FurnaceRecipeHandler.this.cycleticks / 48;
            if (this.ingred.item.k() == -1) {
                PositionedStack stack = this.ingred.copy();
                int maxDamage = 0;
                do {
                    stack.item.b(++maxDamage);
                } while (NEIClientUtils.isValidItem(stack.item));
                stack.item.b(cycle % maxDamage);
                return stack;
            }
            return this.ingred;
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public PositionedStack getOtherStack() {
            return FurnaceRecipeHandler.afuels.get((int)(FurnaceRecipeHandler.this.cycleticks / 48 % FurnaceRecipeHandler.afuels.size())).stack;
        }
    }
}

