/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import java.util.ArrayList;
import java.util.List;

public class PositionedStack {
    public int relx;
    public int rely;
    public yd[] items;
    public yd item;
    private boolean permutated = false;

    public PositionedStack(Object object, int x, int y, boolean genPerms) {
        this.items = NEIServerUtils.extractRecipeItems(object);
        this.relx = x;
        this.rely = y;
        if (genPerms) {
            this.generatePermutations();
        } else {
            this.setPermutationToRender(0);
        }
    }

    public PositionedStack(Object object, int x, int y) {
        this(object, x, y, true);
    }

    public void generatePermutations() {
        if (this.permutated) {
            return;
        }
        ArrayList<yd> stacks = new ArrayList<yd>();
        yd[] ydArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            yd item = ydArray[n2];
            if (item != null && item.b() != null) {
                if (item.k() == Short.MAX_VALUE) {
                    List<yd> permutations = NEIClientUtils.getValidItems(item.d);
                    if (!permutations.isEmpty()) {
                        for (yd stack : permutations) {
                            stacks.add(stack.m());
                        }
                    } else {
                        yd base = new yd(item.d, item.b, 0);
                        base.e = item.e;
                        stacks.add(base);
                    }
                } else {
                    stacks.add(item.m());
                }
            }
            ++n2;
        }
        this.items = stacks.toArray(new yd[0]);
        if (this.items.length == 0) {
            this.items = new yd[]{new yd((aqw)aqw.aw)};
        }
        this.permutated = true;
        this.setPermutationToRender(0);
    }

    public void setMaxSize(int i) {
        yd[] ydArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            yd item = ydArray[n2];
            if (item.b > i) {
                item.b = i;
            }
            ++n2;
        }
    }

    public PositionedStack copy() {
        return new PositionedStack(this.items, this.relx, this.rely);
    }

    public void setPermutationToRender(int index) {
        this.item = this.items[index].m();
        if (this.item.k() == -1) {
            this.item.b(0);
        }
    }

    public boolean contains(yd ingredient) {
        yd[] ydArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            yd item = ydArray[n2];
            if (NEIServerUtils.areStacksSameTypeCrafting(item, ingredient)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean contains(int ingredID) {
        yd[] ydArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            yd item = ydArray[n2];
            if (item.d == ingredID) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

