/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIServerUtils;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IDConflictReporter {
    private static HashMultimap<Integer, aqw> blockConflicts = HashMultimap.create();
    private static HashMap<Object, ModContainer> containers = new HashMap();

    public static void blockConstructed(aqw block, int id) {
        if (aqw.s[id] != null) {
            blockConflicts.put((Object)id, (Object)block);
        }
        IDConflictReporter.bindModContainer(block);
    }

    private static void bindModContainer(aqw block) {
        containers.put(block, Loader.instance().activeModContainer());
    }

    private static boolean hasConflicts() {
        return !blockConflicts.isEmpty();
    }

    public static void postInit() {
        if (!IDConflictReporter.hasConflicts()) {
            return;
        }
        try {
            File outputFile = new File("IDConflicts.txt");
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            PrintWriter writer = new PrintWriter(new FileWriter(outputFile));
            IDConflictReporter.printConflicts(writer, blockConflicts, "Blocks", aqw.s);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NEIServerUtils.throwCME("A list of ID conflicts has been written to\nthe file 'IDConflicts.txt' in your minecraft directory");
    }

    private static void printConflicts(PrintWriter writer, HashMultimap<Integer, ?> conflictMap, String header, Object[] array) {
        if (!conflictMap.isEmpty()) {
            writer.println("#" + header);
            int conflictCount = 0;
            ArrayList<IDConflict> conflicts = new ArrayList<IDConflict>(conflictMap.size());
            Iterator iterator = conflictMap.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                Set values = conflictMap.get((Object)id);
                conflicts.add(new IDConflict(id, values, array));
                conflictCount += values.size();
            }
            Collections.sort(conflicts);
            for (IDConflict c : conflicts) {
                writer.println(c.msg);
            }
            IDConflictReporter.printSuggestions(writer, conflictCount, array);
        }
    }

    private static void printSuggestions(PrintWriter writer, int conflictCount, Object[] array) {
        ArrayList<int[]> freeRanges = new ArrayList<int[]>();
        int start = -1;
        int i = 0;
        while (i < array.length) {
            boolean isFree;
            boolean bl = isFree = array[i] == null;
            if (isFree) {
                if (start == -1) {
                    start = i;
                }
            } else if (start >= 0) {
                freeRanges.add(new int[]{start, i - 1});
                start = -1;
            }
            ++i;
        }
        if (start >= 0) {
            freeRanges.add(new int[]{start, array.length - 1});
        }
        Collections.sort(freeRanges, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int a2 = o1[1] - o1[0];
                int b = o2[1] - o2[0];
                return a2 == b ? 0 : (a2 > b ? -1 : 1);
            }
        });
        ArrayList<int[]> topFree = new ArrayList<int[]>();
        int nfree = 0;
        int i2 = 0;
        while (i2 < freeRanges.size() && (nfree < conflictCount || topFree.size() < 3)) {
            int[] range = (int[])freeRanges.get(i2);
            topFree.add(range);
            nfree += range[1] - range[0];
            ++i2;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (int[] range : topFree) {
            sb.append(prefix);
            if (range[0] == range[1]) {
                sb.append(range[0]);
            } else {
                sb.append(String.valueOf(range[0]) + "-" + range[1] + " (" + (range[1] - range[0] + 1) + " IDs)");
            }
            prefix = ", ";
        }
        writer.println("Suggested Ranges: " + sb.toString());
        if (nfree < conflictCount) {
            writer.println("You don't have enough blockIDs for all these mods, try uninstalling " + IDConflictReporter.modWithMostIDs(array));
        }
    }

    private static String modWithMostIDs(Object[] array) {
        HashMap<ModContainer, Integer> idCount = new HashMap<ModContainer, Integer>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ModContainer mc;
            Object o = objectArray[n2];
            if (o != null && (mc = containers.get(o)) != null) {
                Integer v = (Integer)idCount.get(mc);
                idCount.put(mc, v == null ? 1 : v + 1);
            }
            ++n2;
        }
        int largestCount = 0;
        ModContainer largestMod = null;
        for (Map.Entry entry : idCount.entrySet()) {
            if ((Integer)entry.getValue() <= largestCount) continue;
            largestCount = (Integer)entry.getValue();
            largestMod = (ModContainer)entry.getKey();
        }
        return largestMod.getModId();
    }

    private static class IDConflict
    implements Comparable<IDConflict> {
        public int id;
        public String msg;

        public IDConflict(int id, Collection<?> values, Object[] base) {
            this.id = id;
            this.msg = String.valueOf(id) + ": " + IDConflict.identify(base[id]);
            for (Object o : values) {
                this.msg = String.valueOf(this.msg) + " - " + IDConflict.identify(o);
            }
        }

        @Override
        public int compareTo(IDConflict o) {
            return o.id == this.id ? 0 : (this.id > o.id ? 1 : -1);
        }

        public static String identify(Object o) {
            return String.valueOf(IDConflict.name(o)) + " from " + IDConflict.getContainerID(o);
        }

        public static String getContainerID(Object o) {
            ModContainer mc = (ModContainer)containers.get(o);
            if (mc != null) {
                return mc.getModId();
            }
            return "Unknown";
        }

        public static String name(Object o) {
            if (o instanceof aqw) {
                return IDConflict.blockName((aqw)o);
            }
            return o.toString();
        }

        public static String blockName(aqw block) {
            String name = block.a();
            if (name != null && name.startsWith("tile.")) {
                name = name.substring(5);
            }
            if (name == null || name.length() == 0) {
                name = block.getClass().getName();
            }
            return name;
        }
    }
}

