/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.init.InternalName;
import ic2.core.item.IUpgradeItem;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemUpgradeModule
extends ItemIC2
implements IUpgradeItem {
    private static DecimalFormat decimalformat = new DecimalFormat("0.##");
    private final int upgradeCount;

    public ItemUpgradeModule(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77627_a(true);
        Ic2Items.overclockerUpgrade = new ItemStack((Item)this, 1, 0);
        Ic2Items.transformerUpgrade = new ItemStack((Item)this, 1, 1);
        Ic2Items.energyStorageUpgrade = new ItemStack((Item)this, 1, 2);
        Ic2Items.ejectorUpgrade = new ItemStack((Item)this, 1, 3);
        this.upgradeCount = 4;
    }

    @Override
    public String getTextureFolder() {
        return "upgrade";
    }

    @Override
    public String getTextureName(int index) {
        String ret = super.getTextureName(index);
        if (ret != null) {
            return ret;
        }
        if (index - this.upgradeCount < 6) {
            return InternalName.ejectorUpgrade.name() + "." + (index - this.upgradeCount);
        }
        return null;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        byte dir;
        if (stack.func_77960_j() == 3 && (dir = StackUtil.getOrCreateNbtData(stack).func_74771_c("dir")) >= 1 && dir <= 6) {
            return super.func_77617_a(this.upgradeCount + dir - 1);
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        InternalName ret;
        switch (itemStack.func_77960_j()) {
            case 0: {
                ret = InternalName.overclockerUpgrade;
                break;
            }
            case 1: {
                ret = InternalName.transformerUpgrade;
                break;
            }
            case 2: {
                ret = InternalName.energyStorageUpgrade;
                break;
            }
            case 3: {
                ret = InternalName.ejectorUpgrade;
                break;
            }
            default: {
                return null;
            }
        }
        return ret.name();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        switch (stack.func_77960_j()) {
            case 0: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.time", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(0.7, stack.field_77994_a))}));
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.power", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(1.6, stack.field_77994_a))}));
                break;
            }
            case 1: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.transformer", (Object[])new Object[]{stack.field_77994_a}));
                break;
            }
            case 2: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.storage", (Object[])new Object[]{10000 * stack.field_77994_a}));
                break;
            }
            case 3: {
                String side;
                switch (StackUtil.getOrCreateNbtData(stack).func_74771_c("dir") - 1) {
                    case 0: {
                        side = "ic2.dir.west";
                        break;
                    }
                    case 1: {
                        side = "ic2.dir.east";
                        break;
                    }
                    case 2: {
                        side = "ic2.dir.bottom";
                        break;
                    }
                    case 3: {
                        side = "ic2.dir.top";
                        break;
                    }
                    case 4: {
                        side = "ic2.dir.north";
                        break;
                    }
                    case 5: {
                        side = "ic2.dir.south";
                        break;
                    }
                    default: {
                        side = "ic2.tooltip.upgrade.ejector.anyside";
                    }
                }
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.ejector", (Object[])new Object[]{StatCollector.func_74838_a((String)side)}));
                break;
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (stack.func_77960_j() == 3) {
            int dir = 1 + (side + 2) % 6;
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
            if (nbtData.func_74771_c("dir") != dir) {
                nbtData.func_74774_a("dir", (byte)dir);
                return true;
            }
        }
        return false;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        ItemStack stack;
        for (int meta = 0; meta <= Short.MAX_VALUE && this.func_77667_c(stack = new ItemStack((Item)this, 1, meta)) != null; ++meta) {
            itemList.add(stack);
        }
    }

    @Override
    public int getExtraProcessTime(ItemStack stack, TileEntityStandardMachine parent) {
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack stack, TileEntityStandardMachine parent) {
        if (stack.func_77960_j() == 0) {
            return 0.7;
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack stack, TileEntityStandardMachine parent) {
        return 0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack stack, TileEntityStandardMachine parent) {
        if (stack.func_77960_j() == 0) {
            return 1.6;
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack stack, TileEntityStandardMachine parent) {
        if (stack.func_77960_j() == 2) {
            return 10000;
        }
        return 0;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack stack, TileEntityStandardMachine parent) {
        return 1.0;
    }

    @Override
    public int getExtraTier(ItemStack stack, TileEntityStandardMachine parent) {
        if (stack.func_77960_j() == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean onTick(ItemStack stack, TileEntityStandardMachine parent) {
        ItemStack output;
        if (stack.func_77960_j() == 3 && (output = parent.outputSlot.get()) != null && parent.energy >= 20) {
            int amount = Math.min(output.field_77994_a, parent.energy / 20);
            byte dir = StackUtil.getOrCreateNbtData(stack).func_74771_c("dir");
            if (dir < 1 || dir > 6) {
                amount = StackUtil.distribute(parent, StackUtil.copyWithSize(output, amount), false);
            } else {
                TileEntity te = Direction.values()[dir - 1].applyToTileEntity(parent);
                if (te instanceof IInventory) {
                    amount = StackUtil.putInInventory((IInventory)te, StackUtil.copyWithSize(output, amount), false);
                } else {
                    return false;
                }
            }
            output.field_77994_a -= amount;
            if (output.field_77994_a <= 0) {
                parent.outputSlot.clear();
            }
            parent.energy -= 20 * amount;
            return true;
        }
        return false;
    }

    @Override
    public void onProcessEnd(ItemStack stack, TileEntityStandardMachine parent, ItemStack output) {
    }
}

