/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerStandardMachine;
import ic2.core.block.machine.gui.GuiCompressor;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCompressor
extends TileEntityStandardMachine {
    public TileEntityPump validPump;
    public static List<Map.Entry<ItemStack, ItemStack>> recipes = new Vector<Map.Entry<ItemStack, ItemStack>>();

    public TileEntityCompressor() {
        super(2, 400);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.compressor);
    }

    public static void init() {
        Recipes.compressor = new BasicMachineRecipeManager<ItemStack>();
        Recipes.compressor.addRecipe(Ic2Items.plantBall, Ic2Items.compressedPlantBall);
        Recipes.compressor.addRecipe(Ic2Items.hydratedCoalDust, Ic2Items.hydratedCoalClump);
        Recipes.compressor.addRecipe(new ItemStack(Block.field_72012_bb, 3), new ItemStack(Block.field_72033_bA));
        Recipes.compressor.addRecipe(new ItemStack(Block.field_71939_E), new ItemStack(Block.field_71957_Q));
        Recipes.compressor.addRecipe(new ItemStack(Item.field_77768_aD), new ItemStack(Block.field_72036_aT));
        Recipes.compressor.addRecipe(Ic2Items.waterCell, new ItemStack(Item.field_77768_aD));
        Recipes.compressor.addRecipe(Ic2Items.mixedMetalIngot, Ic2Items.advancedAlloy);
        Recipes.compressor.addRecipe(Ic2Items.carbonMesh, Ic2Items.carbonPlate);
        Recipes.compressor.addRecipe(Ic2Items.coalBall, Ic2Items.compressedCoalBall);
        Recipes.compressor.addRecipe(Ic2Items.coalChunk, new ItemStack(Item.field_77702_n));
        Recipes.compressor.addRecipe(Ic2Items.constructionFoam, Ic2Items.constructionFoamPellet);
        Recipes.compressor.addRecipe(Ic2Items.cell, Ic2Items.airCell);
    }

    @Override
    public ItemStack getResultFor(ItemStack itemStack, boolean adjustInput) {
        return Recipes.compressor.getOutputFor(itemStack, adjustInput);
    }

    @Override
    public boolean canOperate() {
        return super.canOperate() || this.getValidPump() != null && this.outputSlot.canAdd(new ItemStack(Item.field_77768_aD));
    }

    @Override
    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        if (this.inputSlot.isEmpty() || this.getResultFor(this.inputSlot.get(), false) == null) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.pumpCharge = 0;
            pump.clearLastBlock();
            this.outputSlot.add(new ItemStack(Item.field_77768_aD));
        } else {
            super.operate();
        }
    }

    public TileEntityPump getValidPump() {
        FluidStack liquid;
        if (this.validPump != null && !this.validPump.func_70320_p() && (liquid = this.validPump.pump(this.validPump.field_70329_l, this.validPump.field_70330_m, this.validPump.field_70327_n)) != null && liquid.getFluid() == FluidRegistry.WATER) {
            return this.validPump;
        }
        this.validPump = null;
        for (Direction dir : Direction.values()) {
            FluidStack liquid2;
            TileEntity te = dir.applyToTileEntity(this);
            if (!(te instanceof TileEntityPump) || (liquid2 = ((TileEntityPump)te).pump(this.validPump.field_70329_l, this.validPump.field_70330_m, this.validPump.field_70327_n)) == null || liquid2.getFluid() != FluidRegistry.WATER) continue;
            this.validPump = (TileEntityPump)te;
            return this.validPump;
        }
        return null;
    }

    @Override
    public String func_70303_b() {
        return "Compressor";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCompressor(new ContainerStandardMachine(entityPlayer, this));
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/CompressorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }
}

