/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import need4speed402.mods.barrels.BarrelRender;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.EntityItemFrame;
import need4speed402.mods.barrels.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;

public class TileEntityBarrel
extends TileEntity
implements ISidedInventory {
    private ItemStack item;
    private String overlay = "";
    private byte doubleClickTimer = (byte)-1;
    private byte selectedSlot;
    private final ItemStack[] lastStack = new ItemStack[this.func_70302_i_()];
    private final ItemStack[] currentStack = new ItemStack[this.func_70302_i_()];
    private byte side = 0;
    protected final boolean[] render = new boolean[4];
    protected final EntityItemFrame[] frames = new EntityItemFrame[4];
    private boolean update = false;
    private boolean requiresCheck = false;

    public byte getSide() {
        return this.side;
    }

    public void setSide(byte side) {
        this.side = side;
    }

    public ItemStack getItem() {
        ItemStack item;
        ItemStack itemStack = item = this.item == null ? null : this.item.func_77946_l();
        if (this.requiresCheck) {
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                if (this.currentStack[slot] == null || this.currentStack[slot].field_77994_a == this.lastStack[slot].field_77994_a) continue;
                if (item == null) {
                    item = this.currentStack[slot];
                }
                item.field_77994_a += this.currentStack[slot].field_77994_a - this.lastStack[slot].field_77994_a;
            }
        }
        return item;
    }

    public void setItem(ItemStack item) {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            this.lastStack[slot] = null;
            this.currentStack[slot] = null;
        }
        this.item = item;
        this.update = true;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            try {
                PacketHandler.instance.sendServerRequestForItem(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    public int getInventorySize() {
        return this.getStackLimit() * this.item.func_77976_d();
    }

    public int getStackLimit() {
        switch (this.func_70322_n()) {
            case 0: {
                return Barrels.instance.T1BarrelMaxStorage;
            }
            case 1: {
                return Barrels.instance.T2BarrelMaxStorage;
            }
            case 2: {
                return Barrels.instance.T3BarrelMaxStorage;
            }
        }
        return 0;
    }

    public int func_70302_i_() {
        return 3;
    }

    public void func_70316_g() {
        if (this.isTimerActive()) {
            this.doubleClickTimer = (byte)(this.doubleClickTimer - 1);
        }
        if (this.requiresCheck) {
            this.flush();
        }
        if (this.field_70331_k.field_72995_K) {
            for (int side = 0; side < 4; ++side) {
                this.render[side] = BarrelRender.instance.isSideValidForRender(this, Direction.field_71580_e[side]);
            }
        } else {
            for (int i = 0; i < this.frames.length; ++i) {
                int x = this.field_70329_l + Direction.field_71583_a[Direction.field_71580_e[i]];
                int y = this.field_70330_m;
                int z = this.field_70327_n + Direction.field_71581_b[Direction.field_71580_e[i]];
                List list = this.field_70331_k.func_72872_a(net.minecraft.entity.item.EntityItemFrame.class, AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
                if (list == null || list.size() <= 0) continue;
                for (int size = 0; size < list.size(); ++size) {
                    net.minecraft.entity.item.EntityItemFrame frame = (net.minecraft.entity.item.EntityItemFrame)list.get(size);
                    if (frame.field_82332_a != Direction.field_71580_e[i]) continue;
                    if (this.frames[i] != null) {
                        Barrels.instance.barrel.spawnItem(this.field_70331_k, x, y, z, new ItemStack(Item.field_82802_bI, 2, 0), null);
                        this.frames[i] = null;
                    } else {
                        this.frames[i] = new EntityItemFrame(frame);
                        ItemStack item = null;
                        if (this.item != null) {
                            item = this.item.func_77946_l();
                            item.field_77994_a = 1;
                        }
                        this.frames[i].func_82334_a(item);
                    }
                    frame.func_70106_y();
                    if (this.update) {
                        this.update(true);
                        continue;
                    }
                    try {
                        PacketHandler.instance.sendClientsFrameChange(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.field_73011_w.field_76574_g, this.frames);
                        continue;
                    }
                    catch (Exception io) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.update) {
            this.update(false);
        }
    }

    private void update(boolean sendFrames) {
        if (this.field_70331_k.field_72995_K) {
            if (this.item == null) {
                this.overlay = "";
            } else {
                StringBuilder overlay = new StringBuilder();
                int maxSize = this.item.func_77976_d();
                int stackCount = this.item.field_77994_a / maxSize;
                if (maxSize == 1) {
                    overlay.append(stackCount);
                } else {
                    int excess = this.item.field_77994_a % maxSize;
                    if (stackCount > 0) {
                        if (stackCount > 1) {
                            overlay.append(stackCount).append(" x ");
                        }
                        overlay.append(maxSize);
                        if (excess > 0) {
                            overlay.append(" + ");
                        }
                    }
                    if (excess > 0) {
                        overlay.append(excess);
                    }
                }
                this.overlay = overlay.toString();
            }
            for (int i = 0; i < this.frames.length; ++i) {
                if (this.frames[i] == null) continue;
                ItemStack item = null;
                if (this.item != null) {
                    item = this.item.func_77946_l();
                    item.field_77994_a = 1;
                }
                this.frames[i].func_82334_a(item);
            }
        } else {
            try {
                PacketHandler.instance.updateClients(this.item, this.getSide(), sendFrames ? this.frames : null, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.field_73011_w.field_76574_g);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        this.update = false;
    }

    public void func_70310_b(NBTTagCompound NBT) {
        ItemStack item = this.getItem();
        if (item != null) {
            NBT.func_74768_a("item", item.field_77993_c);
            NBT.func_74768_a("size", item.field_77994_a);
            NBT.func_74768_a("metadata", item.func_77960_j());
            if (item.func_77978_p() != null) {
                NBT.func_74766_a("tag", item.func_77978_p());
            }
        }
        byte packed = 0;
        for (int i = 0; i < this.frames.length; ++i) {
            if (this.frames[i] == null) continue;
            packed = (byte)(packed | 1 << i);
        }
        if (packed != 0) {
            NBT.func_74774_a("frame", packed);
        }
        NBT.func_74774_a("side", this.getSide());
        super.func_70310_b(NBT);
    }

    public void func_70307_a(NBTTagCompound NBT) {
        super.func_70307_a(NBT);
        if (NBT.func_74764_b("item")) {
            int itemID = NBT.func_74762_e("item");
            this.item = itemID == -1 || Item.field_77698_e[itemID] == null ? null : new ItemStack(itemID, NBT.func_74762_e("size"), NBT.func_74762_e("metadata"));
            if (NBT.func_74764_b("tag")) {
                this.item.func_77982_d(NBT.func_74775_l("tag"));
            }
        } else {
            this.item = null;
        }
        if (NBT.func_74764_b("frame")) {
            byte packed = NBT.func_74771_c("frame");
            for (int i = 0; i < this.frames.length; ++i) {
                if ((packed & 1 << i) == 0) continue;
                this.frames[i] = new EntityItemFrame(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, Direction.field_71580_e[i]);
            }
        }
        this.setSide(NBT.func_74771_c("side"));
    }

    public void setClick(byte selectedSlot) {
        this.selectedSlot = selectedSlot;
        this.doubleClickTimer = (byte)10;
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void resetTimer() {
        this.doubleClickTimer = (byte)-1;
    }

    public boolean isTimerActive() {
        return this.doubleClickTimer > -1;
    }

    public String getOverlay() {
        return this.overlay;
    }

    private void flush() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.currentStack[slot] != null && this.currentStack[slot].field_77994_a != this.lastStack[slot].field_77994_a) {
                if (this.item == null) {
                    this.item = this.currentStack[slot];
                }
                if (this.lastStack[slot].field_77994_a - this.currentStack[slot].field_77994_a >= this.item.field_77994_a) {
                    this.item = null;
                } else {
                    this.item.field_77994_a += this.currentStack[slot].field_77994_a - this.lastStack[slot].field_77994_a;
                }
                this.update = true;
            }
            this.currentStack[slot] = null;
            this.lastStack[slot] = null;
        }
        this.requiresCheck = false;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.item != null) {
            this.requiresCheck = true;
            if (this.currentStack[slot] != null) {
                if (this.currentStack[slot].field_77994_a != this.lastStack[slot].field_77994_a) {
                    this.item.field_77994_a += this.currentStack[slot].field_77994_a - this.lastStack[slot].field_77994_a;
                    this.update = true;
                    this.currentStack[slot].field_77994_a = this.lastStack[slot].field_77994_a = this.getStackSizeInSlot(slot);
                }
                return this.currentStack[slot];
            }
            ItemStack item = this.item.func_77946_l();
            item.field_77994_a = this.getStackSizeInSlot(slot);
            this.currentStack[slot] = item;
            this.lastStack[slot] = item.func_77946_l();
            return item;
        }
        return null;
    }

    private int getStackSizeInSlot(int slot) {
        if (this.item != null) {
            switch ((slot + 1) % 3) {
                case 1: {
                    return Math.min(this.item.func_77976_d(), this.item.field_77994_a);
                }
                case 2: {
                    return this.item.field_77994_a - this.getStackSizeInSlot(0);
                }
                case 0: {
                    return Math.max(this.item.func_77976_d() + (this.item.field_77994_a - this.getInventorySize()), 0);
                }
            }
        }
        return 0;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.item == null) {
            if (stack != null && stack != this.currentStack[slot]) {
                this.item = stack.func_77946_l();
                this.currentStack[slot] = stack;
                this.lastStack[slot] = stack.func_77946_l();
                this.update = true;
            }
        } else {
            int fakeStack;
            if (this.currentStack[slot] != null) {
                if (this.currentStack[slot].field_77994_a != this.lastStack[slot].field_77994_a && this.currentStack[slot] != stack) {
                    this.currentStack[slot].field_77994_a = this.lastStack[slot].field_77994_a;
                }
                fakeStack = this.lastStack[slot].field_77994_a;
            } else {
                fakeStack = this.getStackSizeInSlot(slot);
            }
            if (fakeStack - (stack == null ? 0 : stack.field_77994_a) != 0) {
                if (stack == null) {
                    if (this.getItem().field_77994_a > fakeStack) {
                        this.item.field_77994_a -= fakeStack;
                    } else {
                        this.item = null;
                    }
                    this.lastStack[slot] = null;
                    this.currentStack[slot] = null;
                } else {
                    this.item.field_77994_a += stack.field_77994_a - fakeStack;
                    this.currentStack[slot] = stack;
                    this.lastStack[slot] = stack.func_77946_l();
                }
                this.update = true;
            }
        }
        if (stack != null) {
            this.requiresCheck = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack addItem(ItemStack item) {
        int inventorySize;
        if (item == null) return null;
        if (item.field_77994_a == 0) return null;
        this.update = true;
        int n = inventorySize = this.item == null ? this.getStackLimit() * item.func_77976_d() : this.getInventorySize();
        if (this.getItem() == null) {
            if (item.field_77994_a > inventorySize) {
                ItemStack item1 = this.getItem();
                item1.field_77994_a = inventorySize;
                this.item = item1;
                item.field_77994_a -= inventorySize;
                return item;
            }
            this.item = item.func_77946_l();
            return null;
        }
        if (!this.equals(item)) return item;
        if (this.item.field_77994_a + item.field_77994_a > inventorySize) {
            item.field_77994_a -= inventorySize - this.item.field_77994_a;
            ItemStack item1 = this.getItem();
            item1.field_77994_a = inventorySize;
            this.setItem(item1);
            return item;
        }
        ItemStack item1 = this.getItem();
        item1.field_77994_a += item.field_77994_a;
        this.setItem(item1);
        return null;
    }

    public ItemStack func_70298_a(int slot, int value) {
        if (slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.item != null && value != 0) {
            this.update = true;
            if (value > this.item.field_77994_a) {
                value = this.item.field_77994_a;
            }
            ItemStack excess = this.item.func_77946_l();
            this.func_70301_a((int)slot).field_77994_a -= value;
            excess.field_77994_a = value;
            return excess;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public String func_70303_b() {
        return "container.barrel";
    }

    public byte getModeForSide(int side) {
        if (side == 1) {
            return this.getMode(0);
        }
        if (side == 0) {
            return this.getMode(1);
        }
        if (side == 2) {
            if (this.getSide() == 0) {
                return this.getMode(4);
            }
            if (this.getSide() == 1) {
                return this.getMode(3);
            }
            if (this.getSide() == 2) {
                return this.getMode(5);
            }
            return this.getMode(2);
        }
        if (side == 3) {
            if (this.getSide() == 0) {
                return this.getMode(5);
            }
            if (this.getSide() == 1) {
                return this.getMode(2);
            }
            if (this.getSide() == 2) {
                return this.getMode(4);
            }
            return this.getMode(3);
        }
        if (side == 4) {
            if (this.getSide() == 0) {
                return this.getMode(3);
            }
            if (this.getSide() == 1) {
                return this.getMode(5);
            }
            if (this.getSide() == 2) {
                return this.getMode(2);
            }
            return this.getMode(4);
        }
        if (side == 5) {
            if (this.getSide() == 0) {
                return this.getMode(4);
            }
            if (this.getSide() == 1) {
                return this.getMode(3);
            }
            if (this.getSide() == 2) {
                return this.getMode(5);
            }
            return this.getMode(2);
        }
        return 0;
    }

    private byte getMode(int index) {
        return Barrels.instance.interaction[index];
    }

    public boolean equals(ItemStack item) {
        return (item == this.item || item != null && this.item != null && item.func_77969_a(this.item)) && (item.func_77978_p() == this.item.func_77978_p() || item.func_77978_p() != null && this.item.func_77978_p() != null && Arrays.equals(item.func_77978_p().func_74758_c().toArray(), this.item.func_77978_p().func_74758_c().toArray()));
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return this.item == null || this.equals(item);
    }

    public boolean func_94042_c() {
        return true;
    }

    public int[] func_94128_d(int side) {
        switch (this.getModeForSide(side)) {
            case 1: {
                return new int[]{0, 1};
            }
            case 2: {
                return new int[]{2};
            }
            case 3: {
                return new int[]{0, 1, 2};
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return (slot + 1) % 3 == 0 && this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return (slot + 1) % 3 != 0 && this.func_94041_b(slot, item);
    }
}

