/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.TileEntityBarrel;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureCompass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BarrelRender
extends TileEntitySpecialRenderer {
    public static final BarrelRender instance = new BarrelRender();
    private final TextureManager manager;
    private final ResourceLocation itemGlint;
    private final ResourceLocation mapBackround;
    private final DynamicTexture mapTextureManager;
    private final ResourceLocation mapTexture;
    private final RenderBlocks blockRender;
    private final Tessellator tessellator;

    public BarrelRender() {
        this.manager = Minecraft.func_71410_x().field_71446_o;
        this.itemGlint = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        this.mapBackround = new ResourceLocation("textures/map/map_background.png");
        this.mapTextureManager = new DynamicTexture(128, 128);
        this.mapTexture = this.manager.func_110578_a("map", this.mapTextureManager);
        this.blockRender = new RenderBlocks();
        this.tessellator = Tessellator.field_78398_a;
    }

    private void renderText(String text, int side, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + (double)0.91f), (double)(z + 0.5));
        GL11.glRotatef((float)(-90 * side), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.505f);
        GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-0.01f);
        this.func_76895_b().func_78276_b(text, -this.func_76895_b().func_78256_a(text) / 2, 2, -1);
        GL11.glPopMatrix();
    }

    public void renderItem(TileEntityBarrel tile, ItemStack stack, int side, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.75), (double)(z + 0.5));
        GL11.glRotatef((float)(-90 * side), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.32f, (float)0.0f, (float)-0.505f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && RenderBlocks.func_78597_b((int)Block.field_71973_m[item.field_77779_bT].func_71857_b()) || customRenderer != null) {
            GL11.glScalef((float)0.04f, (float)0.04f, (float)(Barrels.instance.renderIn3D ? 0.04f : 0.001f));
            this.manager.func_110577_a(TextureMap.field_110575_b);
            boolean usesHelper = customRenderer == null ? true : customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, stack, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK);
            int color = item.func_82790_a(stack, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            if (usesHelper) {
                GL11.glScalef((float)10.0f, (float)10.0f, (float)(Barrels.instance.renderIn3D ? 10.0f : 1.0f));
                GL11.glTranslatef((float)0.8f, (float)0.8f, (float)1.0f);
                if (Barrels.instance.renderIn3D) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.8f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.0f);
            }
            if (usesHelper) {
                this.blockRender.field_78668_c = true;
            }
            if (customRenderer != null) {
                customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, stack, new Object[]{this.blockRender});
            } else {
                this.blockRender.func_78600_a(Block.field_71973_m[stack.field_77993_c], stack.func_77960_j(), 1.0f);
            }
        } else {
            GL11.glScalef((float)0.04f, (float)0.04f, (float)(Minecraft.func_71410_x().field_71474_y.field_74347_j ? 0.04f : 0.001f));
            GL11.glEnable((int)32826);
            boolean reloadTexture = true;
            for (int pass = 0; pass < (item.func_77623_v() ? item.getRenderPasses(stack.func_77960_j()) : 1); ++pass) {
                if (reloadTexture) {
                    this.manager.func_110577_a(this.manager.func_130087_a(stack.func_94608_d()));
                }
                int color = item.func_82790_a(stack, pass);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                Icon icon = null;
                if (item.func_77623_v()) {
                    icon = item.getIcon(stack, pass);
                } else if (icon == null) {
                    icon = stack.func_77954_c();
                }
                if (stack.func_77973_b() == Item.field_77744_bd && Barrels.instance.renderMapInfo) {
                    this.manager.func_110577_a(this.mapBackround);
                    this.renderItem(0.0f, 1.0f, 0.0f, 1.0f, 128, 128);
                    GL11.glTranslatef((float)1.0f, (float)0.85f, (float)-0.505f);
                    GL11.glScalef((float)0.88f, (float)0.88f, (float)0.88f);
                    MapData data = Item.field_77744_bd.func_77873_a(stack, tile.field_70331_k);
                    if (data != null) {
                        for (int i = 0; i < this.mapTextureManager.func_110565_c().length; ++i) {
                            byte color2 = data.field_76198_e[i];
                            if (color2 / 4 == 0) {
                                this.mapTextureManager.func_110565_c()[i] = (i * 2 / 128 & 1) * 8 + 16 << 24;
                                continue;
                            }
                            int miltiplyer = 0;
                            switch (color2 & 3) {
                                case 0: {
                                    miltiplyer = 180;
                                    break;
                                }
                                case 2: {
                                    miltiplyer = 255;
                                    break;
                                }
                                default: {
                                    miltiplyer = 220;
                                }
                            }
                            int mapColor = MapColor.field_76281_a[color2 / 4].field_76291_p;
                            int r2 = (mapColor >> 16 & 0xFF) * miltiplyer / 255;
                            int g2 = (mapColor >> 8 & 0xFF) * miltiplyer / 255;
                            int b2 = (mapColor & 0xFF) * miltiplyer / 255;
                            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                                r2 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                                g2 = (r2 * 30 + g2 * 70) / 100;
                                b2 = (r2 * 30 + b2 * 70) / 100;
                            }
                            this.mapTextureManager.func_110565_c()[i] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                        }
                        this.mapTextureManager.func_110564_a();
                        this.manager.func_110577_a(this.mapTexture);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)1, (int)771);
                        GL11.glDisable((int)3008);
                        this.tessellator.func_78382_b();
                        this.tessellator.func_78374_a(0.0, 16.0, 0.0, 0.0, 1.0);
                        this.tessellator.func_78374_a(16.0, 16.0, 0.0, 1.0, 1.0);
                        this.tessellator.func_78374_a(16.0, 0.0, 0.0, 1.0, 0.0);
                        this.tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                        this.tessellator.func_78381_a();
                        GL11.glEnable((int)3008);
                        GL11.glDisable((int)3042);
                    }
                } else if (stack.func_77973_b() == Item.field_77750_aQ) {
                    TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
                    texturemanager.func_110577_a(TextureMap.field_110576_c);
                    TextureAtlasSprite textureatlassprite = ((TextureMap)texturemanager.func_110581_b(TextureMap.field_110576_c)).func_110572_b(Item.field_77750_aQ.func_77650_f(stack).func_94215_i());
                    if (textureatlassprite instanceof TextureCompass) {
                        TextureCompass texturecompass = (TextureCompass)textureatlassprite;
                        double angle = texturecompass.field_94244_i;
                        double delta = texturecompass.field_94242_j;
                        texturecompass.field_94244_i = 0.0;
                        texturecompass.field_94242_j = 0.0;
                        texturecompass.func_94241_a(tile.field_70331_k, (double)tile.field_70329_l, (double)tile.field_70329_l, 300.0, false, true);
                        texturecompass.field_94244_i = angle;
                        texturecompass.field_94242_j = delta;
                    }
                    this.renderItem(icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
                    TextureAtlasSprite textureatlassprite1 = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110576_c)).func_110572_b(Item.field_77750_aQ.func_77650_f(stack).func_94215_i());
                    if (textureatlassprite1.func_110970_k() > 0) {
                        textureatlassprite1.func_94219_l();
                    }
                } else {
                    this.renderItem(icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
                }
                reloadTexture = stack.hasEffect(pass);
                if (!reloadTexture) continue;
                GL11.glPushMatrix();
                this.manager.func_110577_a(this.itemGlint);
                GL11.glDepthFunc((int)514);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)774, (int)774);
                GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)768, (int)1);
                for (int dir = 0; dir < 2; ++dir) {
                    float minV;
                    float maxV;
                    float maxU;
                    float minU;
                    float uoffset;
                    GL11.glPushMatrix();
                    float phrase = (float)(System.currentTimeMillis() / 2L % (long)(3000 + dir * 1873)) / (float)(3000 + dir * 1873) * 256.0f;
                    float f = uoffset = dir == 1 ? -1.0f : 4.0f;
                    if (dir == 0) {
                        minU = (phrase + 20.0f * uoffset) * 0.00390625f;
                        maxU = (phrase + 20.0f + 20.0f * uoffset) * 0.00390625f;
                        maxV = (phrase + 20.0f) * 0.00390625f;
                        minV = phrase * 0.00390625f;
                    } else {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        maxV = (phrase + 20.0f * uoffset) * 0.00390625f;
                        minV = (phrase + 20.0f + 20.0f * uoffset) * 0.00390625f;
                        minU = (phrase + 20.0f) * 0.00390625f;
                        maxU = phrase * 0.00390625f;
                    }
                    this.renderItem(minU, maxU, minV, maxV, 256, 256);
                    GL11.glPopMatrix();
                }
                GL11.glDepthMask((boolean)true);
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glDepthFunc((int)515);
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)32826);
            if (stack.func_77951_h()) {
                GL11.glPushMatrix();
                GL11.glDisable((int)3553);
                int damage = (int)Math.round(13.0 - (double)stack.func_77952_i() * 13.0 / (double)stack.func_77958_k());
                int colour = (int)Math.round(255.0 - (double)stack.func_77952_i() * 255.0 / (double)stack.func_77958_k());
                this.tessellator.func_78382_b();
                if (damage > 0) {
                    this.renderQuad(2, 13, damage, 1, -0.01f, 255 - colour << 16 | colour << 8);
                }
                if (damage != 13) {
                    this.renderQuad(damage + 2, 13, 12 - damage, 1, -0.01f, (255 - colour) / 4 << 16 | 0x3F00);
                    this.renderQuad(14, 13, 1, 1, -0.01f, 0);
                }
                this.renderQuad(2, 14, 13, 1, -0.01f, 0);
                this.tessellator.func_78381_a();
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    private void renderItem(float minU, float maxU, float minV, float maxV, int originX, int originY) {
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            int i;
            this.tessellator.func_78382_b();
            float offset = 0.5f;
            this.tessellator.func_78374_a(0.0, 16.0, (double)(-offset), (double)minU, (double)maxV);
            this.tessellator.func_78374_a(16.0, 16.0, (double)(-offset), (double)maxU, (double)maxV);
            this.tessellator.func_78374_a(16.0, 0.0, (double)(-offset), (double)maxU, (double)minV);
            this.tessellator.func_78374_a(0.0, 0.0, (double)(-offset), (double)minU, (double)minV);
            float width = (maxU - minU) / (float)originX;
            float height = (maxV - minV) / (float)originY;
            for (i = 0; i < originX; ++i) {
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 16.0, 0.0, (double)(minU + width * (float)i), (double)maxV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 16.0, (double)(-offset), (double)(minU + width * (float)(i + 1)), (double)maxV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 0.0, (double)(-offset), (double)(minU + width * (float)(i + 1)), (double)minV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 0.0, 0.0, (double)(minU + width * (float)i), (double)minV);
            }
            for (i = 1; i <= originX; ++i) {
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 16.0, (double)(-offset), (double)(minU + width * (float)(i - 1)), (double)maxV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 16.0, 0.0, (double)(minU + width * (float)i), (double)maxV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 0.0, 0.0, (double)(minU + width * (float)i), (double)minV);
                this.tessellator.func_78374_a((double)((float)i / ((float)originX / 16.0f)), 0.0, (double)(-offset), (double)(minU + width * (float)(i - 1)), (double)minV);
            }
            for (i = 0; i < originY; ++i) {
                this.tessellator.func_78374_a(0.0, (double)((float)i / ((float)originY / 16.0f)), (double)(-offset), (double)minU, (double)(minV + height * (float)(i + 1)));
                this.tessellator.func_78374_a(16.0, (double)((float)i / ((float)originY / 16.0f)), (double)(-offset), (double)maxU, (double)(minV + height * (float)(i + 1)));
                this.tessellator.func_78374_a(16.0, (double)((float)i / ((float)originY / 16.0f)), 0.0, (double)maxU, (double)(minV + height * (float)i));
                this.tessellator.func_78374_a(0.0, (double)((float)i / ((float)originY / 16.0f)), 0.0, (double)minU, (double)(minV + height * (float)i));
            }
            for (i = 1; i <= originY; ++i) {
                this.tessellator.func_78374_a(0.0, (double)((float)i / ((float)originY / 16.0f)), 0.0, (double)minU, (double)(minV + height * (float)i));
                this.tessellator.func_78374_a(16.0, (double)((float)i / ((float)originY / 16.0f)), 0.0, (double)maxU, (double)(minV + height * (float)i));
                this.tessellator.func_78374_a(16.0, (double)((float)i / ((float)originY / 16.0f)), (double)(-offset), (double)maxU, (double)(minV + height * (float)(i - 1)));
                this.tessellator.func_78374_a(0.0, (double)((float)i / ((float)originY / 16.0f)), (double)(-offset), (double)minU, (double)(minV + height * (float)(i - 1)));
            }
            this.tessellator.func_78381_a();
        } else {
            this.tessellator.func_78382_b();
            this.tessellator.func_78374_a(0.0, 16.0, 0.0, (double)minU, (double)maxV);
            this.tessellator.func_78374_a(16.0, 16.0, 0.0, (double)maxU, (double)maxV);
            this.tessellator.func_78374_a(16.0, 0.0, 0.0, (double)maxU, (double)minV);
            this.tessellator.func_78374_a(0.0, 0.0, 0.0, (double)minU, (double)minV);
            this.tessellator.func_78381_a();
        }
    }

    public void func_76896_a(World world) {
        this.blockRender.field_78669_a = world;
    }

    private void renderQuad(int x, int y, int width, int height, float off, int color) {
        this.tessellator.func_78378_d(color);
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)off);
            this.tessellator.func_78377_a((double)x, (double)y, (double)off);
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-0.5f + off));
            this.tessellator.func_78377_a((double)x, (double)y, (double)off);
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-0.5f + off));
        } else {
            this.tessellator.func_78377_a((double)x, (double)y, (double)off);
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)off);
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)off);
        }
    }

    public void func_76894_a(TileEntity entity, double x, double y, double z, float counter) {
        TileEntityBarrel tile = (TileEntityBarrel)entity;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        if (Barrels.instance.onlyRenderOneSide) {
            byte side = tile.getSide();
            if (tile.render[side]) {
                this.renderEntityOnSide(tile, side, x, y, z);
            }
            for (side = 0; side < 4; side = (byte)(side + 1)) {
                if (side == tile.getSide() || !tile.render[side] || tile.frames[side] == null) continue;
                this.renderEntityOnSide(tile, side, x, y, z);
            }
        } else {
            for (int side = 0; side < 4; side = (int)((byte)(side + 1))) {
                if (!tile.render[side]) continue;
                this.renderEntityOnSide(tile, side, x, y, z);
            }
        }
        GL11.glDisable((int)2884);
        GL11.glEnable((int)2896);
    }

    private void renderEntityOnSide(TileEntityBarrel tile, int side, double x, double y, double z) {
        boolean render;
        this.setLight(tile, Direction.field_71580_e[side]);
        ItemStack item = tile.getItem();
        boolean bl = render = item != null && item.field_77994_a > 0;
        if (tile.frames[side] != null) {
            if (render) {
                this.renderText(tile.getOverlay(), side, x, y, z);
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.4375), (double)(z + 0.5));
            GL11.glRotatef((float)(-90 * (side + 1)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5625f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(90 * (side + 1)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)2896);
            ((Render)RenderManager.field_78727_a.field_78729_o.get(EntityItemFrame.class)).func_76986_a((Entity)tile.frames[side], 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        } else if (render) {
            this.renderText(tile.getOverlay(), side, x, y, z);
            this.renderItem(tile, item, side, x, y, z);
        }
    }

    private void setLight(TileEntity tile, int side) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(tile.field_70331_k.func_72972_b(EnumSkyBlock.Block, tile.field_70329_l + Direction.field_71583_a[side], tile.field_70330_m, tile.field_70327_n + Direction.field_71581_b[side]) * 16), (float)(tile.field_70331_k.func_72972_b(EnumSkyBlock.Sky, tile.field_70329_l + Direction.field_71583_a[side], tile.field_70330_m, tile.field_70327_n + Direction.field_71581_b[side]) * 16));
    }

    public boolean isSideValidForRender(TileEntity entity, int side) {
        int blockID = entity.field_70331_k.func_72798_a(entity.field_70329_l + Direction.field_71583_a[side], entity.field_70330_m, entity.field_70327_n + Direction.field_71581_b[side]);
        if (blockID == Block.field_94340_cs.field_71990_ca) {
            return false;
        }
        return blockID == 0 || !Block.field_71973_m[blockID].func_71926_d();
    }
}

