/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.Profiler;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import java.util.ArrayList;

public class GuiUsageRecipe
extends GuiRecipe {
    public ArrayList<IUsageHandler> currenthandlers;
    public static ArrayList<IUsageHandler> usagehandlers = new ArrayList();

    private GuiUsageRecipe(awv prevgui, ArrayList<IUsageHandler> handlers) {
        super(prevgui);
        this.currenthandlers = handlers;
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        for (IUsageHandler handler1 : usagehandlers) {
            if (handler1.getClass() != handler.getClass()) continue;
            return;
        }
        usagehandlers.add(handler);
    }

    public static boolean openRecipeGui(String inputId, Object ... ingredients) {
        ats mc = NEIClientUtils.mc();
        if (!(mc.n instanceof awv)) {
            return false;
        }
        awv prevscreen = (awv)mc.n;
        Profiler profiler = ProfilerRecipeHandler.getProfiler();
        ArrayList<IUsageHandler> handlers = new ArrayList<IUsageHandler>();
        for (IUsageHandler usagehandler : usagehandlers) {
            profiler.start(usagehandler.getRecipeName());
            IUsageHandler handler = usagehandler.getUsageHandler(inputId, ingredients);
            if (handler.numRecipes() <= 0) continue;
            handlers.add(handler);
        }
        profiler.end();
        if (handlers.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen(new GuiUsageRecipe(prevscreen, handlers));
        return true;
    }

    @Override
    public ArrayList<? extends IRecipeHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

