/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(awv gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List<PositionedStack> ingredients = recipe.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private void moveIngredients(awv gui, List<IngredientDistribution> assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            yd pstack = distrib.permutation;
            int transferCap = quantity * pstack.b;
            int transferred = 0;
            int destSlotIndex = 0;
            wd dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.e();
            for (wd slot : gui.e.c) {
                yd stack;
                if (!slot.e() || !(slot.f instanceof uc) || !InventoryUtils.canStack((yd)(stack = slot.d()), (yd)pstack)) continue;
                FastTransferManager.clickSlot(gui, slot.g);
                int amount = Math.min(transferCap - transferred, stack.b);
                int c = 0;
                while (c < amount) {
                    FastTransferManager.clickSlot(gui, dest.g, 1);
                    ++transferred;
                    if (++slotTransferred >= slotTransferCap) {
                        if (++destSlotIndex == distrib.slots.length) {
                            dest = null;
                            break;
                        }
                        dest = distrib.slots[destSlotIndex];
                        slotTransferred = 0;
                    }
                    ++c;
                }
                FastTransferManager.clickSlot(gui, slot.g);
                if (transferred >= transferCap || dest == null) continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.e()) {
                allSlots = istack.numSlots * istack.stack.e();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private wd[][] assignIngredSlots(awv gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        wd[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<wd, Integer> distribution = new HashMap<wd, Integer>();
        int i = 0;
        while (i < recipeSlots.length) {
            wd[] wdArray = recipeSlots[i];
            int n = wdArray.length;
            int n2 = 0;
            while (n2 < n) {
                wd slot = wdArray[n2];
                if (!distribution.containsKey(slot)) {
                    distribution.put(slot, -1);
                }
                ++n2;
            }
            ++i;
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        int i2 = 0;
        while (i2 < ingredients.size()) {
            remainingIngreds.add(i2);
            assignedSlots.add(new LinkedList());
            ++i2;
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i3 = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i3).distrib;
                wd[] wdArray = recipeSlots[i3];
                int n = wdArray.length;
                int n3 = 0;
                while (n3 < n) {
                    wd slot = wdArray[n3];
                    if (avaliableSlots.contains(slot)) {
                        avaliableSlots.remove(slot);
                        if (!slot.e()) {
                            ++istack.numSlots;
                            ((LinkedList)assignedSlots.get(i3)).add(slot);
                            assigned = true;
                            break;
                        }
                    }
                    ++n3;
                }
                if (assigned && istack.numSlots * istack.stack.e() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        i = 0;
        while (i < ingredients.size()) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new wd[0]);
            ++i;
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            yd permutation = null;
            int biggestSize = 0;
            yd[] ydArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                yd pstack = ydArray[n2];
                int j = 0;
                while (j < ingredStacks.size()) {
                    int relsize;
                    DistributedIngred istack = ingredStacks.get(j);
                    if (InventoryUtils.canStack((yd)pstack, (yd)istack.stack) && istack.invAmount - istack.distributed >= pstack.b && (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.b) > biggestSize) {
                        biggestSize = relsize;
                        biggestIngred = istack;
                        permutation = pstack;
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.b;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(awv gui, List<DistributedIngred> ingredStacks) {
        for (wd slot : gui.e.c) {
            yd pstack;
            DistributedIngred istack;
            if (!slot.e() || !(slot.f instanceof uc) || (istack = this.findIngred(ingredStacks, pstack = slot.d())) == null) continue;
            istack.invAmount += pstack.b;
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            yd[] ydArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                yd pstack = ydArray[n2];
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.b;
                ++n2;
            }
        }
        return ingredStacks;
    }

    public wd[][] mapIngredSlots(awv gui, List<PositionedStack> ingredients) {
        wd[][] recipeSlotList = new wd[ingredients.size()][];
        int i = 0;
        while (i < ingredients.size()) {
            LinkedList<wd> recipeSlots = new LinkedList<wd>();
            PositionedStack pstack = ingredients.get(i);
            for (wd slot : gui.e.c) {
                if (slot.h != pstack.relx + this.offsetx || slot.i != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new wd[0]);
            ++i;
        }
        return recipeSlotList;
    }

    public void clickSlot(awv window, int slotIndex, int button, int modifier) {
        ux container = window.e;
        wd slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.sendMouseClick(slot, slotIndex, button, modifier);
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, yd pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack((yd)pstack, (yd)istack.stack)) continue;
            return istack;
        }
        return null;
    }

    public static class DistributedIngred {
        public yd stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(yd item) {
            this.stack = InventoryUtils.copyStack((yd)item, (int)1);
        }
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public yd permutation;
        public wd[] slots;

        public IngredientDistribution(DistributedIngred distrib, yd permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }
}

