/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ServerUtils;
import codechicken.nei.NEISPH;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class PlayerSave {
    public String username;
    private File saveFile;
    private bx nbt;
    public yd[] creativeInv;
    private boolean creativeInvDirty;
    private boolean isDirty;
    private boolean wasOp;

    public PlayerSave(String playername, File saveLocation) {
        this.username = playername;
        this.wasOp = ServerUtils.isPlayerOP((String)playername);
        this.saveFile = new File(saveLocation, String.valueOf(this.username) + ".dat");
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        this.load();
    }

    private void load() {
        this.nbt = new bx();
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.saveFile.length() > 0L) {
                DataInputStream din = new DataInputStream(new FileInputStream(this.saveFile));
                this.nbt = (bx)ck.a((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadCreativeInv();
    }

    private void loadCreativeInv() {
        this.creativeInv = new yd[54];
        cf itemList = this.nbt.m("creativeitems");
        if (itemList != null) {
            int tagPos = 0;
            while (tagPos < itemList.c()) {
                bx stacksave = (bx)itemList.b(tagPos);
                this.creativeInv[stacksave.c((String)"Slot") & 0xFF] = yd.a((bx)stacksave);
                ++tagPos;
            }
        }
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        if (this.creativeInvDirty) {
            this.saveCreativeInv();
        }
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(this.saveFile));
            ck.a((ck)this.nbt, (DataOutput)dout);
            dout.close();
            this.isDirty = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveCreativeInv() {
        cf invsave = new cf();
        int i = 0;
        while (i < this.creativeInv.length) {
            if (this.creativeInv[i] != null) {
                bx stacksave = new bx();
                stacksave.a("Slot", (byte)i);
                this.creativeInv[i].b(stacksave);
                invsave.a((ck)stacksave);
            }
            ++i;
        }
        this.nbt.a("creativeitems", (ck)invsave);
        this.creativeInvDirty = false;
    }

    public void setCreativeDirty() {
        this.isDirty = true;
        this.creativeInvDirty = true;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void updateOpChange(ju player) {
        boolean isOp = ServerUtils.isPlayerOP((String)this.username);
        if (isOp != this.wasOp) {
            NEISPH.sendHasServerSideTo(player);
            this.wasOp = isOp;
        }
    }

    public boolean isActionEnabled(String name) {
        return this.getEnabledActions().n(name);
    }

    private bx getEnabledActions() {
        bx tag = this.nbt.l("enabledActions");
        if (!this.nbt.b("enabledActions")) {
            this.nbt.a("enabledActions", tag);
        }
        return tag;
    }

    public void enableAction(String name, boolean enabled) {
        this.getEnabledActions().a(name, enabled);
        NEISPH.sendActionEnabled(ServerUtils.getPlayer((String)this.username), name, enabled);
        this.setDirty();
    }
}

