/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class AabbUtil {
    public static Direction getIntersection(Vec3 origin, Vec3 direction, AxisAlignedBB bbox, Vec3 intersection) {
        double length = direction.func_72433_c();
        Vec3 normalizedDirection = Vec3.func_72443_a((double)(direction.field_72450_a / length), (double)(direction.field_72448_b / length), (double)(direction.field_72449_c / length));
        Direction intersectingDirection = AabbUtil.intersects(origin, normalizedDirection, bbox);
        if (intersectingDirection == null) {
            return null;
        }
        Vec3 planeOrigin = normalizedDirection.field_72450_a < 0.0 && normalizedDirection.field_72448_b < 0.0 && normalizedDirection.field_72449_c < 0.0 ? Vec3.func_72443_a((double)bbox.field_72336_d, (double)bbox.field_72337_e, (double)bbox.field_72334_f) : (normalizedDirection.field_72450_a < 0.0 && normalizedDirection.field_72448_b < 0.0 && normalizedDirection.field_72449_c >= 0.0 ? Vec3.func_72443_a((double)bbox.field_72336_d, (double)bbox.field_72337_e, (double)bbox.field_72339_c) : (normalizedDirection.field_72450_a < 0.0 && normalizedDirection.field_72448_b >= 0.0 && normalizedDirection.field_72449_c < 0.0 ? Vec3.func_72443_a((double)bbox.field_72336_d, (double)bbox.field_72338_b, (double)bbox.field_72334_f) : (normalizedDirection.field_72450_a < 0.0 && normalizedDirection.field_72448_b >= 0.0 && normalizedDirection.field_72449_c >= 0.0 ? Vec3.func_72443_a((double)bbox.field_72336_d, (double)bbox.field_72338_b, (double)bbox.field_72339_c) : (normalizedDirection.field_72450_a >= 0.0 && normalizedDirection.field_72448_b < 0.0 && normalizedDirection.field_72449_c < 0.0 ? Vec3.func_72443_a((double)bbox.field_72340_a, (double)bbox.field_72337_e, (double)bbox.field_72334_f) : (normalizedDirection.field_72450_a >= 0.0 && normalizedDirection.field_72448_b < 0.0 && normalizedDirection.field_72449_c >= 0.0 ? Vec3.func_72443_a((double)bbox.field_72340_a, (double)bbox.field_72337_e, (double)bbox.field_72339_c) : (normalizedDirection.field_72450_a >= 0.0 && normalizedDirection.field_72448_b >= 0.0 && normalizedDirection.field_72449_c < 0.0 ? Vec3.func_72443_a((double)bbox.field_72340_a, (double)bbox.field_72338_b, (double)bbox.field_72334_f) : Vec3.func_72443_a((double)bbox.field_72340_a, (double)bbox.field_72338_b, (double)bbox.field_72339_c)))))));
        Vec3 planeNormalVector = null;
        switch (intersectingDirection) {
            case XN: 
            case XP: {
                planeNormalVector = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case YN: 
            case YP: {
                planeNormalVector = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case ZN: 
            case ZP: {
                planeNormalVector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
            }
        }
        Vec3 newIntersection = AabbUtil.getIntersectionWithPlane(origin, normalizedDirection, planeOrigin, planeNormalVector);
        intersection.field_72450_a = newIntersection.field_72450_a;
        intersection.field_72448_b = newIntersection.field_72448_b;
        intersection.field_72449_c = newIntersection.field_72449_c;
        return intersectingDirection;
    }

    public static Direction intersects(Vec3 origin, Vec3 direction, AxisAlignedBB bbox) {
        double[] ray = AabbUtil.getRay(origin, direction);
        if (direction.field_72450_a < 0.0 && direction.field_72448_b < 0.0 && direction.field_72449_c < 0.0) {
            if (origin.field_72450_a < bbox.field_72340_a) {
                return null;
            }
            if (origin.field_72448_b < bbox.field_72338_b) {
                return null;
            }
            if (origin.field_72449_c < bbox.field_72339_c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.XP;
        }
        if (direction.field_72450_a < 0.0 && direction.field_72448_b < 0.0 && direction.field_72449_c >= 0.0) {
            if (origin.field_72450_a < bbox.field_72340_a) {
                return null;
            }
            if (origin.field_72448_b < bbox.field_72338_b) {
                return null;
            }
            if (origin.field_72449_c > bbox.field_72334_f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return Direction.XP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.ZN;
        }
        if (direction.field_72450_a < 0.0 && direction.field_72448_b >= 0.0 && direction.field_72449_c < 0.0) {
            if (origin.field_72450_a < bbox.field_72340_a) {
                return null;
            }
            if (origin.field_72448_b > bbox.field_72337_e) {
                return null;
            }
            if (origin.field_72449_c < bbox.field_72339_c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return Direction.XP;
            }
            return Direction.YN;
        }
        if (direction.field_72450_a < 0.0 && direction.field_72448_b >= 0.0 && direction.field_72449_c >= 0.0) {
            if (origin.field_72450_a < bbox.field_72340_a) {
                return null;
            }
            if (origin.field_72448_b > bbox.field_72337_e) {
                return null;
            }
            if (origin.field_72449_c > bbox.field_72334_f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return Direction.YN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return Direction.ZN;
            }
            return Direction.XP;
        }
        if (direction.field_72450_a >= 0.0 && direction.field_72448_b < 0.0 && direction.field_72449_c < 0.0) {
            if (origin.field_72450_a > bbox.field_72336_d) {
                return null;
            }
            if (origin.field_72448_b < bbox.field_72338_b) {
                return null;
            }
            if (origin.field_72449_c < bbox.field_72339_c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            return Direction.YP;
        }
        if (direction.field_72450_a >= 0.0 && direction.field_72448_b < 0.0 && direction.field_72449_c >= 0.0) {
            if (origin.field_72450_a > bbox.field_72336_d) {
                return null;
            }
            if (origin.field_72448_b < bbox.field_72338_b) {
                return null;
            }
            if (origin.field_72449_c > bbox.field_72334_f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return Direction.ZN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            return Direction.YP;
        }
        if (direction.field_72450_a >= 0.0 && direction.field_72448_b >= 0.0 && direction.field_72449_c < 0.0) {
            if (origin.field_72450_a > bbox.field_72336_d) {
                return null;
            }
            if (origin.field_72448_b > bbox.field_72337_e) {
                return null;
            }
            if (origin.field_72449_c < bbox.field_72339_c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return Direction.YN;
            }
            return Direction.ZP;
        }
        if (origin.field_72450_a > bbox.field_72336_d) {
            return null;
        }
        if (origin.field_72448_b > bbox.field_72337_e) {
            return null;
        }
        if (origin.field_72449_c > bbox.field_72334_f) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
            return Direction.XN;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
            return Direction.ZN;
        }
        return Direction.YN;
    }

    private static double[] getRay(Vec3 origin, Vec3 direction) {
        double[] ret = new double[]{origin.field_72450_a * direction.field_72448_b - direction.field_72450_a * origin.field_72448_b, origin.field_72450_a * direction.field_72449_c - direction.field_72450_a * origin.field_72449_c, -direction.field_72450_a, origin.field_72448_b * direction.field_72449_c - direction.field_72448_b * origin.field_72449_c, -direction.field_72449_c, direction.field_72448_b};
        return ret;
    }

    private static double[] getEdgeRay(Edge edge, AxisAlignedBB bbox) {
        switch (edge) {
            case AD: {
                return new double[]{-bbox.field_72338_b, -bbox.field_72339_c, -1.0, 0.0, 0.0, 0.0};
            }
            case AB: {
                return new double[]{bbox.field_72340_a, 0.0, 0.0, -bbox.field_72339_c, 0.0, 1.0};
            }
            case AE: {
                return new double[]{0.0, bbox.field_72340_a, 0.0, bbox.field_72338_b, -1.0, 0.0};
            }
            case DC: {
                return new double[]{bbox.field_72336_d, 0.0, 0.0, -bbox.field_72339_c, 0.0, 1.0};
            }
            case DH: {
                return new double[]{0.0, bbox.field_72336_d, 0.0, bbox.field_72338_b, -1.0, 0.0};
            }
            case BC: {
                return new double[]{-bbox.field_72337_e, -bbox.field_72339_c, -1.0, 0.0, 0.0, 0.0};
            }
            case BF: {
                return new double[]{0.0, bbox.field_72340_a, 0.0, bbox.field_72337_e, -1.0, 0.0};
            }
            case EH: {
                return new double[]{-bbox.field_72338_b, -bbox.field_72334_f, -1.0, 0.0, 0.0, 0.0};
            }
            case EF: {
                return new double[]{bbox.field_72340_a, 0.0, 0.0, -bbox.field_72334_f, 0.0, 1.0};
            }
            case CG: {
                return new double[]{0.0, bbox.field_72336_d, 0.0, bbox.field_72337_e, -1.0, 0.0};
            }
            case FG: {
                return new double[]{-bbox.field_72337_e, -bbox.field_72334_f, -1.0, 0.0, 0.0, 0.0};
            }
            case HG: {
                return new double[]{bbox.field_72336_d, 0.0, 0.0, -bbox.field_72334_f, 0.0, 1.0};
            }
        }
        return new double[0];
    }

    private static double side(double[] ray1, double[] ray2) {
        return ray1[2] * ray2[3] + ray1[5] * ray2[1] + ray1[4] * ray2[0] + ray1[1] * ray2[5] + ray1[0] * ray2[4] + ray1[3] * ray2[2];
    }

    private static Vec3 getIntersectionWithPlane(Vec3 origin, Vec3 direction, Vec3 planeOrigin, Vec3 planeNormalVector) {
        double distance = AabbUtil.getDistanceToPlane(origin, direction, planeOrigin, planeNormalVector);
        return Vec3.func_72443_a((double)(origin.field_72450_a + direction.field_72450_a * distance), (double)(origin.field_72448_b + direction.field_72448_b * distance), (double)(origin.field_72449_c + direction.field_72449_c * distance));
    }

    private static double getDistanceToPlane(Vec3 origin, Vec3 direction, Vec3 planeOrigin, Vec3 planeNormalVector) {
        Vec3 base = Vec3.func_72443_a((double)(planeOrigin.field_72450_a - origin.field_72450_a), (double)(planeOrigin.field_72448_b - origin.field_72448_b), (double)(planeOrigin.field_72449_c - origin.field_72449_c));
        return AabbUtil.dotProduct(base, planeNormalVector) / AabbUtil.dotProduct(direction, planeNormalVector);
    }

    private static double dotProduct(Vec3 a, Vec3 b) {
        return a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
    }

    static enum Edge {
        AD,
        AB,
        AE,
        DC,
        DH,
        BC,
        BF,
        EH,
        EF,
        CG,
        FG,
        HG;

    }
}

