/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    @Override
    @Deprecated
    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(1);
            os.writeInt(itemStack.field_77993_c);
            os.writeInt(itemStack.func_77960_j());
            os.writeInt(event);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(2);
            os.writeInt(keyState);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(3);
            os.writeInt(te.field_70331_k.field_73011_w.field_76574_g);
            os.writeInt(te.field_70329_l);
            os.writeInt(te.field_70330_m);
            os.writeInt(te.field_70327_n);
            os.writeInt(event);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendLoginData() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(4);
            GZIPOutputStream gzip = new GZIPOutputStream(buffer);
            DataOutputStream os = new DataOutputStream(gzip);
            os.writeInt(1);
            os.writeByte(IC2.enableQuantumSpeedOnSprint ? 1 : 0);
            ByteArrayOutputStream buffer2 = new ByteArrayOutputStream();
            IC2.runtimeIdProperties.store(buffer2, "");
            os.writeInt(buffer2.size());
            buffer2.writeTo(os);
            os.close();
            gzip.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player iplayer) {
        block40: {
            if (packet.field_73629_c.length == 0) {
                return;
            }
            if (packet.field_73629_c[0] >= 10) {
                super.onPacketData(network, packet, iplayer);
            }
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packet.field_73629_c, 1, packet.field_73629_c.length - 1);
            try {
                block4 : switch (packet.field_73629_c[0]) {
                    case 0: {
                        GZIPInputStream gzip = new GZIPInputStream((InputStream)isRaw, packet.field_73629_c.length - 1);
                        DataInputStream is = new DataInputStream(gzip);
                        int dimensionId = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        while (true) {
                            int x;
                            try {
                                x = is.readInt();
                            }
                            catch (EOFException e) {
                                break;
                            }
                            int y = is.readInt();
                            int z = is.readInt();
                            TileEntity te = world.func_72796_p(x, y, z);
                            int fieldNameLength = is.readShort();
                            char[] fieldNameRaw = new char[fieldNameLength];
                            for (int i = 0; i < fieldNameLength; ++i) {
                                fieldNameRaw[i] = is.readChar();
                            }
                            String fieldName = new String(fieldNameRaw);
                            Field field = null;
                            try {
                                if (te != null) {
                                    Class<?> fieldDeclaringClass = te.getClass();
                                    do {
                                        try {
                                            field = fieldDeclaringClass.getDeclaredField(fieldName);
                                        }
                                        catch (NoSuchFieldException e) {
                                            fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                                        }
                                    } while (field == null && fieldDeclaringClass != null);
                                    if (field == null) {
                                        IC2.log.warning("Can't find field " + fieldName + " in te " + te + " at " + x + "/" + y + "/" + z);
                                    } else {
                                        field.setAccessible(true);
                                    }
                                }
                                Object value = DataEncoder.decode(is);
                                if (field != null && te != null) {
                                    field.set(te, value);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (!(te instanceof INetworkUpdateListener)) continue;
                            ((INetworkUpdateListener)te).onNetworkUpdate(fieldName);
                        }
                        is.close();
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        TileEntity te = world.func_72796_p(x, y, z);
                        if (!(te instanceof INetworkTileEntityEventListener)) break;
                        ((INetworkTileEntityEventListener)te).onNetworkEvent(event);
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int length = is.readByte();
                        char[] usernameRaw = new char[length];
                        for (int i = 0; i < length; ++i) {
                            usernameRaw[i] = is.readChar();
                        }
                        String username = new String(usernameRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        for (Object obj : world.field_73010_i) {
                            EntityPlayer entityPlayer = (EntityPlayer)obj;
                            if (!entityPlayer.field_71092_bJ.equals(username)) continue;
                            Item item = Item.field_77698_e[itemId];
                            if (item instanceof INetworkItemEventListener) {
                                ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, entityPlayer, event);
                                break block4;
                            }
                            break block40;
                        }
                        break;
                    }
                    case 3: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        short id = is.readShort();
                        byte meta = is.readByte();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        world.func_72832_d(x, y, z, (int)id, (int)meta, 3);
                        break;
                    }
                    case 4: {
                        DataInputStream is = new DataInputStream(isRaw);
                        EntityPlayer entityPlayer = IC2.platform.getPlayerInstance();
                        boolean isAdmin = is.readByte() != 0;
                        switch (is.readByte()) {
                            case 0: {
                                int dimensionId = is.readInt();
                                int x = is.readInt();
                                int y = is.readInt();
                                int z = is.readInt();
                                int windowId = is.readInt();
                                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                                if (world.field_73011_w.field_76574_g != dimensionId) {
                                    return;
                                }
                                TileEntity te = world.func_72796_p(x, y, z);
                                if (te instanceof IHasGui) {
                                    IC2.platform.launchGuiClient(entityPlayer, (IHasGui)te, isAdmin);
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                                break block4;
                            }
                            case 1: {
                                int currentItemPosition = is.readInt();
                                int windowId = is.readInt();
                                if (currentItemPosition != entityPlayer.field_71071_by.field_70461_c) {
                                    return;
                                }
                                ItemStack currentItem = entityPlayer.field_71071_by.func_70448_g();
                                if (currentItem != null && currentItem.func_77973_b() instanceof IHandHeldInventory) {
                                    IC2.platform.launchGuiClient(entityPlayer, ((IHandHeldInventory)currentItem.func_77973_b()).getInventory(entityPlayer, currentItem), isAdmin);
                                }
                                entityPlayer.field_71070_bA.field_75152_c = windowId;
                                break block4;
                            }
                        }
                        break;
                    }
                    case 5: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        double x = is.readDouble();
                        double y = is.readDouble();
                        double z = is.readDouble();
                        WorldClient world = Minecraft.func_71410_x().field_71441_e;
                        if (world.field_73011_w.field_76574_g != dimensionId) {
                            return;
                        }
                        world.func_72908_a(x, y, z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        world.func_72869_a("hugeexplosion", x, y, z, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void announceBlockUpdate(World world, int x, int y, int z) {
        if (IC2.platform.isSimulating()) {
            super.announceBlockUpdate(world, x, y, z);
        }
    }
}

