/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.invslot.InvSlotConsumableLiquidContainer;
import ic2.core.block.machine.ContainerPump;
import ic2.core.block.machine.gui.GuiPump;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityPump
extends TileEntityElectricMachine
implements IHasGui {
    public short pumpCharge = 0;
    private AudioSource audioSource;
    private int lastX;
    private int lastY;
    private int lastZ;
    private TileEntityMiner miner = null;
    public InvSlotConsumableLiquidContainer containerSlot = new InvSlotConsumableLiquidContainer(this, "container", 0, 1);

    public TileEntityPump() {
        super(200, 2, 1);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        this.miner = null;
        super.onUnloaded();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.isPumpReady()) {
            if (this.energy > 0) {
                int extraCharge = Math.min(this.energy, 128);
                this.energy -= extraCharge;
                this.pumpCharge = (short)(this.pumpCharge + extraCharge);
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else if (this.operate()) {
            this.pumpCharge = (short)(this.pumpCharge - 200);
            this.func_70296_d();
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    @Override
    public String func_70303_b() {
        return "Pump";
    }

    public boolean operate() {
        if (!this.canHarvest()) {
            return false;
        }
        if (this.miner == null || this.miner.func_70320_p()) {
            this.miner = null;
            for (Direction dir : Direction.values()) {
                TileEntity te;
                if (dir == Direction.YP || !((te = dir.applyToTileEntity(this)) instanceof TileEntityMiner)) continue;
                this.miner = (TileEntityMiner)te;
                break;
            }
        }
        FluidStack liquid = null;
        if (this.miner != null) {
            if (this.miner.canProvideLiquid) {
                liquid = this.pump(this.miner.liquidX, this.miner.liquidY, this.miner.liquidZ);
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                liquid = this.pump(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
                if (liquid != null) break;
            }
        }
        if (liquid != null) {
            ItemStack filled = this.containerSlot.fill(liquid, false);
            if (filled != null) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(filled);
                StackUtil.distributeDrop(this, drops);
            } else if (!this.putInChestBucket(liquid)) {
                return false;
            }
            this.clearLastBlock();
            return true;
        }
        return false;
    }

    public void clearLastBlock() {
        this.field_70331_k.func_94571_i(this.lastX, this.lastY, this.lastZ);
    }

    public FluidStack pump(int x, int y, int z) {
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        if (blockId == 0) {
            return null;
        }
        FluidStack ret = null;
        if (Block.field_71973_m[blockId] instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)Block.field_71973_m[blockId];
            ret = liquid.drain(this.field_70331_k, x, y, z, true);
        } else if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.WATER, 1000);
        } else if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return ret;
    }

    public boolean putInChestBucket(FluidStack liquid) {
        return this.putInChestBucket(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, liquid);
    }

    public boolean putInChestBucket(int x, int y, int z, FluidStack liquid) {
        if (!(this.field_70331_k.func_72796_p(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_70331_k.func_72796_p(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack filled;
            ItemStack container = chest.func_70301_a(i);
            if (container == null || (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)container)) == null) continue;
            --container.field_77994_a;
            if (container.field_77994_a <= 0) {
                chest.func_70299_a(i, filled);
            } else {
                for (int j = 0; j < chest.func_70302_i_(); ++j) {
                    ItemStack itemStack = chest.func_70301_a(j);
                    if (itemStack == null) {
                        chest.func_70299_a(j, filled);
                        return true;
                    }
                    if (!StackUtil.isStackEqual(itemStack, filled) || itemStack.field_77994_a >= itemStack.func_77976_d()) continue;
                    ++itemStack.field_77994_a;
                    return true;
                }
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(filled);
                StackUtil.distributeDrop(this, drops);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.pumpCharge = nbttagcompound.func_74765_d("pumpCharge");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("pumpCharge", this.pumpCharge);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        if (!this.isPumpReady()) {
            return false;
        }
        return !this.containerSlot.isEmpty() || this.isBucketInChestAvaible();
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.field_70331_k.func_72796_p(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_70331_k.func_72796_p(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null || chest.func_70301_a((int)i).field_77993_c != Item.field_77788_aw.field_77779_bT) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPump(new ContainerPump(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

