/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.AdvShapelessRecipe;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class AdvRecipe
implements IRecipe {
    public ItemStack output;
    public Object[] input;
    public int inputWidth;
    public boolean hidden;

    public static void addAndRegister(ItemStack result, Object ... args) {
        CraftingManager.func_77594_a().func_77592_b().add(new AdvRecipe(result, args));
    }

    public AdvRecipe(ItemStack result, Object ... args) {
        if (result == null) {
            AdvRecipe.displayError("null result", null, null, false);
        }
        HashMap<Character, Object> charMapping = new HashMap<Character, Object>();
        Vector<String> inputArrangement = new Vector<String>();
        Character lastChar = null;
        for (Object o : args) {
            if (o instanceof String) {
                if (lastChar == null) {
                    if (!charMapping.isEmpty()) {
                        AdvRecipe.displayError("oredict name without preceding char", "N: " + o, result, false);
                    }
                    inputArrangement.add((String)o);
                    continue;
                }
                charMapping.put(lastChar, o);
                lastChar = null;
                continue;
            }
            if (o instanceof Character) {
                if (lastChar != null) {
                    AdvRecipe.displayError("two consecutive char definitions", "O: " + o + "\nC: " + lastChar, result, false);
                }
                lastChar = (Character)o;
                continue;
            }
            if (o instanceof ItemStack || o instanceof Block || o instanceof Item) {
                if (lastChar == null) {
                    AdvRecipe.displayError("item without preceding char", "O: " + o + "\nT: " + (o == null ? "null" : o.getClass().getName()) + "\nC: " + lastChar, result, false);
                }
                if (o instanceof Block) {
                    o = new ItemStack((Block)o, 1, Short.MAX_VALUE);
                } else if (o instanceof Item) {
                    o = new ItemStack((Item)o, 1, Short.MAX_VALUE);
                }
                charMapping.put(lastChar, o);
                lastChar = null;
                continue;
            }
            if (o instanceof Boolean) {
                this.hidden = (Boolean)o;
                continue;
            }
            AdvRecipe.displayError("unknown type", "O: " + o + "\nT: " + (o == null ? "null" : o.getClass().getName()), result, false);
        }
        if (lastChar != null) {
            AdvRecipe.displayError("one or more unused mapping chars", "L: " + lastChar, result, false);
        }
        if (inputArrangement.size() == 0 || inputArrangement.size() > 3) {
            AdvRecipe.displayError("none or too many crafting rows", "S: " + inputArrangement.size(), result, false);
        }
        if (charMapping.size() == 0) {
            AdvRecipe.displayError("no mapping chars", null, result, false);
        }
        this.inputWidth = ((String)inputArrangement.get(0)).length();
        this.input = new Object[this.inputWidth * inputArrangement.size()];
        int inputIndex = 0;
        for (String str : inputArrangement) {
            if (str.length() != this.inputWidth) {
                AdvRecipe.displayError("no fixed width", "W: " + this.inputWidth + "\nL: " + str.length(), result, false);
            }
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == ' ') {
                    this.input[inputIndex++] = null;
                    continue;
                }
                if (!charMapping.containsKey(Character.valueOf(c))) {
                    AdvRecipe.displayError("missing char mapping", "C: " + c, result, false);
                }
                this.input[inputIndex++] = charMapping.get(Character.valueOf(c));
            }
        }
        this.output = result;
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        return this.func_77572_b(inventorycrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        int offerSize;
        int inputHeight = this.input.length / this.inputWidth;
        int n = offerSize = inventorycrafting.func_70302_i_() == 9 ? 3 : 2;
        if (offerSize < this.inputWidth || offerSize < inputHeight) {
            return null;
        }
        for (int xOffset = 0; xOffset <= offerSize - this.inputWidth; ++xOffset) {
            block1: for (int yOffset = 0; yOffset <= offerSize - inputHeight; ++yOffset) {
                int x;
                int y;
                int y2;
                int x2;
                int outputCharge = 0;
                for (x2 = 0; x2 < this.inputWidth; ++x2) {
                    for (y2 = 0; y2 < inputHeight; ++y2) {
                        ItemStack offer = inventorycrafting.func_70463_b(x2 + xOffset, y2 + yOffset);
                        Object request = this.input[x2 + y2 * this.inputWidth];
                        if (offer == null && request != null) continue block1;
                        if (offer == null) continue;
                        if (request == null) {
                            return null;
                        }
                        List<ItemStack> requestedItemStacks = AdvRecipe.resolveOreDict(request);
                        boolean found = false;
                        for (ItemStack requestedItemStack : requestedItemStacks) {
                            if (offer.func_77973_b() instanceof IElectricItem) {
                                if (offer.field_77993_c != requestedItemStack.field_77993_c) continue;
                                outputCharge += ElectricItem.manager.getCharge(offer);
                                found = true;
                                break;
                            }
                            if (!offer.func_77969_a(requestedItemStack) && (requestedItemStack.func_77960_j() != Short.MAX_VALUE || offer.field_77993_c != requestedItemStack.field_77993_c)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return null;
                    }
                }
                for (x2 = 0; x2 < xOffset; ++x2) {
                    for (y2 = 0; y2 < offerSize; ++y2) {
                        if (inventorycrafting.func_70463_b(x2, y2) == null) continue;
                        return null;
                    }
                }
                for (y = 0; y < yOffset; ++y) {
                    for (x = 0; x < offerSize; ++x) {
                        if (inventorycrafting.func_70463_b(x, y) == null) continue;
                        return null;
                    }
                }
                for (x2 = xOffset + this.inputWidth; x2 < offerSize; ++x2) {
                    for (y2 = 0; y2 < offerSize; ++y2) {
                        if (inventorycrafting.func_70463_b(x2, y2) == null) continue;
                        return null;
                    }
                }
                for (y = yOffset + inputHeight; y < offerSize; ++y) {
                    for (x = 0; x < offerSize; ++x) {
                        if (inventorycrafting.func_70463_b(x, y) == null) continue;
                        return null;
                    }
                }
                ItemStack ret = this.output.func_77946_l();
                if (ret.func_77973_b() instanceof IElectricItem) {
                    ElectricItem.manager.charge(ret, outputCharge, Integer.MAX_VALUE, true, false);
                }
                return ret;
            }
        }
        return null;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public static boolean recipeContains(Object[] inputs, ItemStack item) {
        for (Object input : inputs) {
            if (input == null) continue;
            List<ItemStack> realInputs = AdvRecipe.resolveOreDict(input);
            for (ItemStack realInput : realInputs) {
                if (!item.func_77969_a(realInput)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canShow(Object[] input, ItemStack output, boolean hidden) {
        return !(IC2.enableSecretRecipeHiding && hidden || AdvRecipe.recipeContains(input, Ic2Items.reBattery) || AdvRecipe.recipeContains(input, Ic2Items.industrialDiamond) && output.field_77993_c == Item.field_77702_n.field_77779_bT);
    }

    public static boolean canShow(AdvRecipe recipe) {
        return AdvRecipe.canShow(recipe.input, recipe.output, recipe.hidden);
    }

    public static boolean canShow(AdvShapelessRecipe recipe) {
        return AdvRecipe.canShow(recipe.input, recipe.output, recipe.hidden);
    }

    public static List<ItemStack> resolveOreDict(Object o) {
        AbstractList ret;
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("liquid$")) {
                String name = s.substring(7);
                ret = new Vector();
                for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!data.fluid.getFluid().getName().equals(name)) continue;
                    ret.add(data.filledContainer);
                }
            } else {
                ret = OreDictionary.getOres((String)((String)o));
            }
        } else if (o instanceof ItemStack) {
            ret = new Vector<ItemStack>(1);
            ret.add((ItemStack)o);
        } else {
            AdvRecipe.displayError("unknown type", "O: " + o + "\nT: " + (o == null ? "null" : o.getClass().getName()), null, false);
            return null;
        }
        return ret;
    }

    public static void displayError(String cause, String tech, ItemStack result, boolean shapeless) {
        IC2.platform.displayError("An invalid crafting recipe was attempted to be added. This could\nhappen due to a bug in IndustrialCraft 2 or an addon.\n\n(Technical information: Adv" + (shapeless ? "Shapeless" : "") + "Recipe, " + cause + ")\n" + (result != null ? "R: " + result + "\n" : "") + (tech != null ? tech : ""));
    }
}

