/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.block.RenderBlock;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderObscurator
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        Icon overlayIcon = this.getOverlayIcon(itemStack);
        int overlayColor = this.getOverlayColor(itemStack);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderIcon(itemStack.func_77954_c(), 0.0f, 0.0f, 16.0f, 16.0f, 0.0f);
            if (overlayIcon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glColor3f((float)((float)(overlayColor >> 16 & 0xFF) / 255.0f), (float)((float)(overlayColor >> 8 & 0xFF) / 255.0f), (float)((float)(overlayColor & 0xFF) / 255.0f));
                this.renderIcon(overlayIcon, 2.0f, 2.0f, 10.0f, 10.0f, 0.0f);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            Icon baseIcon = itemStack.func_77954_c();
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)baseIcon.func_94212_f(), (float)baseIcon.func_94206_g(), (float)baseIcon.func_94209_e(), (float)baseIcon.func_94210_h(), (int)baseIcon.func_94211_a(), (int)baseIcon.func_94216_b(), (float)0.0625f);
            if (overlayIcon != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glColor3f((float)((float)(overlayColor >> 16 & 0xFF) / 255.0f), (float)((float)(overlayColor >> 8 & 0xFF) / 255.0f), (float)((float)(overlayColor & 0xFF) / 255.0f));
                this.renderIconWithNormal(overlayIcon, 0.875f, 0.875f, 0.375f, 0.375f, 0.001f, 0.0f, 0.0f, 1.0f);
                this.renderIconWithNormal(overlayIcon, 0.875f, 0.875f, 0.375f, 0.375f, -0.0635f, 0.0f, 0.0f, -1.0f);
            }
        }
    }

    private Icon getOverlayIcon(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int referencedBlockId = nbtData.func_74762_e("referencedBlockId");
        if (referencedBlockId != 0 && Block.field_71973_m[referencedBlockId] != null) {
            try {
                return Block.field_71973_m[referencedBlockId].func_71858_a(nbtData.func_74762_e("referencedSide"), nbtData.func_74762_e("referencedMeta"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private int getOverlayColor(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int referencedBlockId = nbtData.func_74762_e("referencedBlockId");
        if (referencedBlockId != 0 && Block.field_71973_m[referencedBlockId] != null) {
            try {
                return Block.field_71973_m[referencedBlockId].func_71933_m();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0xFFFFFF;
    }

    private void renderIcon(Icon icon, float xStart, float yStart, float xEnd, float yEnd, float z) {
        if (icon == null) {
            icon = RenderBlock.getMissingIcon(TextureMap.field_110576_c);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xStart, (double)yEnd, (double)z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)xEnd, (double)yEnd, (double)z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)xEnd, (double)yStart, (double)z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)xStart, (double)yStart, (double)z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    private void renderIconWithNormal(Icon icon, float xStart, float yStart, float xEnd, float yEnd, float z, float nx, float ny, float nz) {
        if (icon == null) {
            icon = RenderBlock.getMissingIcon(TextureMap.field_110576_c);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(nx, ny, nz);
        tessellator.func_78374_a((double)xStart, (double)yEnd, (double)z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)xEnd, (double)yEnd, (double)z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)xEnd, (double)yStart, (double)z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)xStart, (double)yStart, (double)z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }
}

