/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.generator.tileentity.TileEntityGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityWindGenerator;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockGenerator
extends BlockMultiID {
    public static Class<? extends TileEntityNuclearReactor> tileEntityNuclearReactorClass = TileEntityNuclearReactorElectric.class;

    public BlockGenerator(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76243_f, ItemGenerator.class);
        this.func_71848_c(3.0f);
        this.func_71884_a(field_71977_i);
        Ic2Items.generator = new ItemStack((Block)this, 1, 0);
        Ic2Items.geothermalGenerator = new ItemStack((Block)this, 1, 1);
        Ic2Items.waterMill = new ItemStack((Block)this, 1, 2);
        Ic2Items.solarPanel = new ItemStack((Block)this, 1, 3);
        Ic2Items.windMill = new ItemStack((Block)this, 1, 4);
        Ic2Items.nuclearReactor = new ItemStack((Block)this, 1, 5);
    }

    @Override
    public String getTextureFolder() {
        return "generator";
    }

    public int func_71885_a(int meta, Random random, int j) {
        switch (meta) {
            default: 
        }
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        switch (meta) {
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    @Override
    public TileEntityBlock createTileEntity(World world, int meta) {
        try {
            switch (meta) {
                case 0: {
                    return new TileEntityGenerator();
                }
                case 1: {
                    return new TileEntityGeoGenerator();
                }
                case 2: {
                    return new TileEntityWaterGenerator();
                }
                case 3: {
                    return new TileEntitySolarGenerator();
                }
                case 4: {
                    return new TileEntityWindGenerator();
                }
                case 5: {
                    return tileEntityNuclearReactorClass.newInstance();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        if (!IC2.platform.isRendering()) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (meta == 0 && BlockGenerator.isActive((IBlockAccess)world, i, j, k)) {
            TileEntityBlock te = (TileEntityBlock)world.func_72796_p(i, j, k);
            short l = te.getFacing();
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (l) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        } else if (meta == 5) {
            int n;
            int puffs = ((TileEntityNuclearReactor)world.func_72796_p((int)i, (int)j, (int)k)).heat / 1000;
            if (puffs <= 0) {
                return;
            }
            puffs = world.field_73012_v.nextInt(puffs);
            for (n = 0; n < puffs; ++n) {
                world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            }
            puffs -= world.field_73012_v.nextInt(4) + 3;
            for (n = 0; n < puffs; ++n) {
                world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77969_a(Ic2Items.reactorChamber)) {
            return false;
        }
        return super.func_71903_a(world, i, j, k, entityplayer, side, a, b, c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 5 ? EnumRarity.uncommon : EnumRarity.common;
    }
}

