/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCustomSwamp
extends WorldGenerator {
    public WorldGenCustomSwamp() {
    }

    public WorldGenCustomSwamp(boolean notify) {
        super(notify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int x1;
        int canopyRadius;
        int posTrunk;
        int y1;
        while (world.func_72803_f(x, y - 1, z) == Material.field_76244_g) {
            --y;
        }
        int height = rand.nextInt(4) + 10;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y12 = y; y12 <= y + 1 + height; ++y12) {
            if (y12 < 0 && y12 >= 256) {
                return false;
            }
            int clearanceNeededAroundTrunk = 1;
            if (y12 == y) {
                clearanceNeededAroundTrunk = 0;
            }
            if (y12 >= y + 1 + height - 2) {
                clearanceNeededAroundTrunk = 3;
            }
            for (int x12 = x - clearanceNeededAroundTrunk; x12 <= x + clearanceNeededAroundTrunk; ++x12) {
                for (int x2 = z - clearanceNeededAroundTrunk; x2 <= z + clearanceNeededAroundTrunk; ++x2) {
                    int id = world.func_72798_a(x12, y12, x2);
                    if (Block.field_71973_m[id] == null || Block.field_71973_m[id].isLeaves(world, x12, y12, x2)) continue;
                    if (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) {
                        if (y12 <= y) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        int id = world.func_72798_a(x, y - 1, z);
        if (id != Block.field_71980_u.field_71990_ca && id != Block.field_71979_v.field_71990_ca || y >= 256 - height - 1) {
            return false;
        }
        world.func_94575_c(x, y - 1, z, Block.field_71979_v.field_71990_ca);
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            posTrunk = y1 - (y + height);
            canopyRadius = 2 - posTrunk / 2;
            for (x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                int xOnRadius = x1 - x;
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    int zOnRadius = z1 - z;
                    Block block = Block.field_71973_m[world.func_72798_a(x1, y1, z1)];
                    if (Math.abs(xOnRadius) == canopyRadius && Math.abs(zOnRadius) == canopyRadius && (rand.nextInt(2) == 0 || posTrunk == 0) || block != null && !block.canBeReplacedByLeaves(world, x1, y1, z1)) continue;
                    world.func_94575_c(x1, y1, z1, Block.field_71952_K.field_71990_ca);
                }
            }
        }
        for (y1 = 0; y1 < height; ++y1) {
            int id2 = world.func_72798_a(x, y + y1, z);
            if (id2 != 0 && !Block.field_71973_m[id2].isLeaves(world, x, y + y1, z) && id2 != Block.field_71942_A.field_71990_ca && id2 != Block.field_71943_B.field_71990_ca) continue;
            world.func_94575_c(x, y + y1, z, Block.field_71951_J.field_71990_ca);
        }
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            posTrunk = y1 - (y + height);
            canopyRadius = 2 - posTrunk / 2;
            for (x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    int id2 = world.func_72798_a(x1, y1, z1);
                    if (id2 == 0 || !Block.field_71973_m[id2].isLeaves(world, x1, y1, z1)) continue;
                    if (rand.nextInt(4) == 0 && world.func_72798_a(x1 - 1, y1, z1) == 0) {
                        this.generateVines(world, x1 - 1, y1, z1, 8);
                    }
                    if (rand.nextInt(4) == 0 && world.func_72798_a(x1 + 1, y1, z1) == 0) {
                        this.generateVines(world, x1 + 1, y1, z1, 2);
                    }
                    if (rand.nextInt(4) == 0 && world.func_72798_a(x1, y1, z1 - 1) == 0) {
                        this.generateVines(world, x1, y1, z1 - 1, 1);
                    }
                    if (rand.nextInt(4) != 0 || world.func_72798_a(x1, y1, z1 + 1) != 0) continue;
                    this.generateVines(world, x1, y1, z1 + 1, 4);
                }
            }
        }
        return true;
    }

    private void generateVines(World world, int x, int y, int z, int metadata) {
        world.func_72832_d(x, y, z, Block.field_71998_bu.field_71990_ca, metadata, 3);
        for (int i = 4; world.func_72798_a(x, --y, z) == 0 && i > 0; --i) {
            world.func_72832_d(x, y, z, Block.field_71998_bu.field_71990_ca, metadata, 3);
        }
    }
}

