/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.fabrica.block.BlockCustomStairs;
import extrabiomes.module.fabrica.block.BlockCustomWall;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.module.fabrica.block.BlockCustomWoodSlab;
import extrabiomes.module.fabrica.block.BlockRedRockSlab;
import extrabiomes.module.fabrica.block.BlockWoodStairs;
import extrabiomes.module.fabrica.block.FuelHandlerWoodSlabs;
import extrabiomes.module.fabrica.block.ItemRedRockSlab;
import extrabiomes.module.fabrica.block.ItemWoodSlab;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.MultiItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.item.ItemStack;

public enum BlockManager {
    PLANKS{

        @Override
        protected void create() {
            Stuff.planks = Optional.of((Object)((Object)new BlockCustomWood(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.PLANKS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.planks.get();
            thisBlock.func_71864_b("extrabiomes.planks");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            for (BlockCustomWood.BlockType type : BlockCustomWood.BlockType.values()) {
                FacadeHelper.addBuildcraftFacade(thisBlock.field_71990_ca, type.metadata());
            }
            proxy.registerOreInAllSubblocks("plankWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.PlankActiveEvent(thisBlock));
        }
    }
    ,
    WOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWood = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabWood.get();
            thisBlock.func_71864_b("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock.field_71990_ca));
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEWOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWoodDouble = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabWoodDouble.get();
            thisBlock.func_71864_b("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemWoodSlab.setSlabs((BlockHalfSlab)Stuff.slabWood.get(), (BlockHalfSlab)Stuff.slabWoodDouble.get());
            proxy.registerBlock((Block)Stuff.slabWood.get(), ItemWoodSlab.class);
            proxy.registerBlock(thisBlock, ItemWoodSlab.class);
            proxy.registerOreInAllSubblocks("slabWood", (Block)Stuff.slabWood.get());
            new ItemStack((Block)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.FIR.metadata());
            new ItemStack((Block)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.REDWOOD.metadata());
            new ItemStack((Block)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.ACACIA.metadata());
        }
    }
    ,
    REDWOODSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedwood = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (Block)Stuff.planks.get(), BlockCustomWood.BlockType.REDWOOD.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedwood.get();
            thisBlock.func_71864_b("extrabiomes.stairs.redwood");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedwoodStairsActiveEvent(thisBlock));
        }
    }
    ,
    FIRSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsFir = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (Block)Stuff.planks.get(), BlockCustomWood.BlockType.FIR.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsFir.get();
            thisBlock.func_71864_b("extrabiomes.stairs.fir");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.FirStairsActiveEvent(thisBlock));
        }
    }
    ,
    ACACIASTAIRS{

        @Override
        protected void create() {
            Stuff.stairsAcacia = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (Block)Stuff.planks.get(), BlockCustomWood.BlockType.ACACIA.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIASTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsAcacia.get();
            thisBlock.func_71864_b("extrabiomes.stairs.acacia");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AcaciaStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRock = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabRedRock.get();
            thisBlock.func_71864_b("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEREDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRockDouble = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEREDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.slabRedRockDouble.get();
            thisBlock.func_71864_b("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            ItemRedRockSlab.setSlabs((BlockHalfSlab)Stuff.slabRedRock.get(), (BlockHalfSlab)Stuff.slabRedRockDouble.get());
            proxy.registerBlock((Block)Stuff.slabRedRock.get(), ItemRedRockSlab.class);
            proxy.registerBlock(thisBlock, ItemRedRockSlab.class);
        }
    }
    ,
    REDCOBBLESTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedCobble = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), Block.field_71973_m[Element.RED_COBBLE.get().field_77993_c], Element.RED_COBBLE.get().func_77960_j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDCOBBLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedCobble.get();
            thisBlock.func_71864_b("extrabiomes.stairs.redcobble");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedCobbleStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKBRICKSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedRockBrick = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), Block.field_71973_m[Element.RED_ROCK_BRICK.get().field_77993_c], Element.RED_ROCK_BRICK.get().func_77960_j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKBRICKSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.stairsRedRockBrick.get();
            thisBlock.func_71864_b("extrabiomes.stairs.redrockbrick");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockBrickStairsActiveEvent(thisBlock));
        }
    }
    ,
    WALL{

        @Override
        protected void create() {
            Stuff.wall = Optional.of((Object)((Object)new BlockCustomWall(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            Block thisBlock = (Block)Stuff.wall.get();
            thisBlock.func_71864_b("extrabiomes.wall");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            Extrabiomes.postInitEvent(new BlockActiveEvent.WallActiveEvent(thisBlock));
        }
    };

    private boolean blockCreated = false;

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (block.getSettings().getID() <= 0) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();
}

