/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import extrabiomes.Extrabiomes;
import extrabiomes.blocks.BlockAutumnLeaves;
import extrabiomes.blocks.BlockCatTail;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.blocks.BlockCustomLog;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockCustomTallGrass;
import extrabiomes.blocks.BlockGreenLeaves;
import extrabiomes.blocks.BlockLeafPile;
import extrabiomes.blocks.BlockQuarterLog;
import extrabiomes.blocks.BlockRedRock;
import extrabiomes.blocks.GenericTerrainBlock;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.handlers.SaplingBonemealEventHandler;
import extrabiomes.handlers.SaplingFuelHandler;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.items.ItemCatTail;
import extrabiomes.items.ItemCustomGreenLeaves;
import extrabiomes.items.ItemCustomLeaves;
import extrabiomes.items.ItemFlower;
import extrabiomes.items.ItemGrass;
import extrabiomes.items.ItemRedRock;
import extrabiomes.items.ItemSapling;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.summa.worldgen.CatTailGenerator;
import extrabiomes.module.summa.worldgen.FlowerGenerator;
import extrabiomes.module.summa.worldgen.LeafPileGenerator;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.renderers.RenderQuarterLog;
import extrabiomes.utility.MultiItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class BlockHandler {
    private static void createAutumnLeaves() {
        int blockID = BlockSettings.AUTUMNLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockAutumnLeaves block = new BlockAutumnLeaves(blockID, 3, Material.field_76257_i, false);
        block.func_71864_b("extrabiomes.autumnleaves").func_71907_b(true).func_71848_c(0.2f).func_71868_h(1).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomLeaves.class);
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        proxy.setBurnProperties(block.field_71990_ca, 30, 60);
        Element.LEAVES_AUTUMN_BROWN.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.BROWN.metadata()));
        Element.LEAVES_AUTUMN_ORANGE.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.ORANGE.metadata()));
        Element.LEAVES_AUTUMN_PURPLE.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.PURPLE.metadata()));
        Element.LEAVES_AUTUMN_YELLOW.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.YELLOW.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    public static void createBlocks() {
        BlockHandler.createAutumnLeaves();
        BlockHandler.createCattail();
        BlockHandler.createCrackedSand();
        BlockHandler.createFlower();
        BlockHandler.createGrass();
        BlockHandler.createGreenLeaves();
        BlockHandler.createLeafPile();
        BlockHandler.createRedRock();
        BlockHandler.createSapling();
        BlockHandler.createLogs();
    }

    private static void createCattail() {
        int blockID = BlockSettings.CATTAIL.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCatTail block = new BlockCatTail(blockID, 79, Material.field_76254_j);
        block.func_71864_b("extrabiomes.cattail").func_71848_c(0.0f).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCatTail.class);
        proxy.registerOre("reedTypha", (Block)block);
        Element.CATTAIL.set(new ItemStack((Block)block));
        proxy.registerWorldGenerator(new CatTailGenerator(block.field_71990_ca));
    }

    private static void createCrackedSand() {
        int blockID = BlockSettings.CRACKEDSAND.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        GenericTerrainBlock block = new GenericTerrainBlock(blockID, 0, Material.field_76246_e);
        block.func_71864_b("extrabiomes.crackedsand").func_71848_c(1.2f).func_71884_a(Block.field_71976_h).func_71849_a(Extrabiomes.tabsEBXL);
        block.texturePath = "crackedsand";
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block);
        proxy.registerOre("sandCracked", (Block)block);
        ItemStack stack = new ItemStack((Block)block);
        Element.CRACKEDSAND.set(stack);
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.WASTELAND, block.field_71990_ca, block.field_71990_ca);
        ForestryModHelper.addToDiggerBackpack(stack);
        FacadeHelper.addBuildcraftFacade(block.field_71990_ca);
    }

    private static void createFlower() {
        int blockID = BlockSettings.FLOWER.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomFlower block = new BlockCustomFlower(blockID, 32, Material.field_76254_j);
        block.func_71864_b("extrabiomes.flower").func_71907_b(true).func_71848_c(0.0f).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block, ItemFlower.class);
        Element.AUTUMN_SHRUB.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.AUTUMN_SHRUB.metadata()));
        Element.HYDRANGEA.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.HYDRANGEA.metadata()));
        Element.FLOWER_ORANGE.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.ORANGE.metadata()));
        Element.FLOWER_PURPLE.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.PURPLE.metadata()));
        Element.FLOWER_WHITE.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.WHITE.metadata()));
        Element.ROOT.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.ROOT.metadata()));
        Element.TINY_CACTUS.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.TINY_CACTUS.metadata()));
        Element.TOADSTOOL.set(new ItemStack((Block)block, 1, BlockCustomFlower.BlockType.TOADSTOOL.metadata()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        ForestryModHelper.registerBasicFlower(Element.HYDRANGEA.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_ORANGE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_PURPLE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_WHITE.get());
        proxy.registerWorldGenerator(new FlowerGenerator(block.field_71990_ca));
    }

    private static void createGrass() {
        int blockID = BlockSettings.GRASS.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomTallGrass block = new BlockCustomTallGrass(blockID, 48, Material.field_76255_k);
        block.func_71864_b("extrabiomes.tallgrass").func_71848_c(0.0f).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemGrass.class);
        proxy.setBurnProperties(block.field_71990_ca, 60, 100);
        Element.GRASS_BROWN.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.BROWN.metadata()));
        Element.GRASS_DEAD.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD.metadata()));
        Element.GRASS_BROWN_SHORT.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.SHORT_BROWN.metadata()));
        Element.GRASS_DEAD_TALL.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD_TALL.metadata()));
        Element.GRASS_DEAD_YELLOW.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD_YELLOW.metadata()));
        ItemStack grassStack = Element.GRASS_BROWN.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (WorldGenerator)new WorldGenTallGrass(grassStack.field_77993_c, grassStack.func_77960_j()), 100);
        grassStack = Element.GRASS_BROWN_SHORT.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (WorldGenerator)new WorldGenTallGrass(grassStack.field_77993_c, grassStack.func_77960_j()), 100);
        grassStack = Element.GRASS_DEAD.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(grassStack.field_77993_c, grassStack.func_77960_j()), 90);
        grassStack = Element.GRASS_DEAD_YELLOW.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(grassStack.field_77993_c, grassStack.func_77960_j()), 90);
        grassStack = Element.GRASS_DEAD_TALL.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(grassStack.field_77993_c, grassStack.func_77960_j()), 35);
    }

    private static void createGreenLeaves() {
        int blockID = BlockSettings.GREENLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockGreenLeaves block = new BlockGreenLeaves(blockID, Material.field_76257_i, false);
        block.func_71864_b("extrabiomes.greenleaves").func_71907_b(true).func_71848_c(0.2f).func_71868_h(1).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomGreenLeaves.class);
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        proxy.setBurnProperties(block.field_71990_ca, 30, 60);
        Element.LEAVES_ACACIA.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.ACACIA.metadata()));
        Element.LEAVES_FIR.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.FIR.metadata()));
        Element.LEAVES_REDWOOD.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.REDWOOD.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createLeafPile() {
        int blockID = BlockSettings.LEAFPILE.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockLeafPile block = new BlockLeafPile(blockID, 64, Material.field_76255_k);
        block.func_71864_b("extrabiomes.leafpile").func_71848_c(0.0f).func_71907_b(true).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block);
        proxy.setBurnProperties(block.field_71990_ca, 30, 60);
        Element.LEAFPILE.set(new ItemStack((Block)block));
        proxy.registerWorldGenerator(new LeafPileGenerator(block.field_71990_ca));
    }

    private static void createLogs() {
        BlockHandler.createWood();
        BlockHandler.createQuarterLogs();
    }

    private static void createQuarterLogs() {
        int blockIDNW = BlockSettings.QUARTERLOG0.getID();
        int blockIDNE = BlockSettings.QUARTERLOG1.getID();
        int blockIDSW = BlockSettings.QUARTERLOG2.getID();
        int blockIDSE = BlockSettings.QUARTERLOG3.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockIDNE <= 0 || blockIDNW <= 0 || blockIDSE <= 0 || blockIDSW <= 0) {
            return;
        }
        BlockQuarterLog blockNW = new BlockQuarterLog(blockIDNW, 144, BlockQuarterLog.BarkOn.NW);
        BlockQuarterLog blockNE = new BlockQuarterLog(blockIDNE, 144, BlockQuarterLog.BarkOn.NE);
        BlockQuarterLog blockSW = new BlockQuarterLog(blockIDSW, 144, BlockQuarterLog.BarkOn.SW);
        BlockQuarterLog blockSE = new BlockQuarterLog(blockIDSE, 144, BlockQuarterLog.BarkOn.SE);
        for (Block block : new Block[]{blockNW, blockNE, blockSW, blockSE}) {
            block.func_71864_b("extrabiomes.log.quarter").func_71884_a(Block.field_71967_e).func_71848_c(2.0f).func_71894_b(Block.field_71951_J.func_71904_a(null) * 5.0f).func_71849_a(Extrabiomes.tabsEBXL);
            CommonProxy proxy = Extrabiomes.proxy;
            proxy.setBlockHarvestLevel(block, "axe", 0);
            proxy.registerBlock(block, MultiItemBlock.class);
            proxy.registerOreInAllSubblocks("logWood", block);
            proxy.registerEventHandler(block);
            proxy.setBurnProperties(block.field_71990_ca, 5, 5);
        }
        Element.LOG_HUGE_FIR_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_OAK_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_REDWOOD_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        BlockQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderQuarterLog()));
        for (BlockQuarterLog.BlockType blockType : BlockQuarterLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(blockSE.field_71990_ca, blockType.metadata());
        }
    }

    private static void createRedRock() {
        int blockID = BlockSettings.REDROCK.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockRedRock block = new BlockRedRock(blockID, 2, Material.field_76246_e);
        block.func_71864_b("extrabiomes.redrock").func_71848_c(1.5f).func_71894_b(2.0f).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, ItemRedRock.class);
        Element.RED_ROCK.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_ROCK.metadata()));
        Element.RED_COBBLE.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_COBBLE.metadata()));
        Element.RED_ROCK_BRICK.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_ROCK_BRICK.metadata()));
        Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockActiveEvent(block));
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.MOUNTAINRIDGE, block.field_71990_ca, block.field_71990_ca);
        ForestryModHelper.addToDiggerBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        for (BlockRedRock.BlockType type : BlockRedRock.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.field_71990_ca, type.metadata());
        }
    }

    private static void createSapling() {
        Element[] forestrySaplings;
        int blockID = BlockSettings.SAPLING.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomSapling block = new BlockCustomSapling(blockID, 16);
        block.func_71864_b("extrabiomes.sapling").func_71848_c(0.0f).func_71884_a(Block.field_71965_g).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemSapling.class);
        proxy.registerOreInAllSubblocks("treeSapling", (Block)block);
        Element.SAPLING_ACACIA.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.ACACIA.metadata()));
        Element.SAPLING_AUTUMN_BROWN.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.BROWN.metadata()));
        Element.SAPLING_AUTUMN_ORANGE.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.ORANGE.metadata()));
        Element.SAPLING_AUTUMN_PURPLE.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.PURPLE.metadata()));
        Element.SAPLING_AUTUMN_YELLOW.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.YELLOW.metadata()));
        Element.SAPLING_FIR.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.FIR.metadata()));
        Element.SAPLING_REDWOOD.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.REDWOOD.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerSapling(Element.SAPLING_ACACIA.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_BROWN.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_ORANGE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_PURPLE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_YELLOW.get());
        ForestryModHelper.registerSapling(Element.SAPLING_FIR.get());
        ForestryModHelper.registerSapling(Element.SAPLING_REDWOOD.get());
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_ACACIA, Element.SAPLING_AUTUMN_BROWN, Element.SAPLING_AUTUMN_ORANGE, Element.SAPLING_AUTUMN_PURPLE, Element.SAPLING_AUTUMN_YELLOW, Element.SAPLING_FIR}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler(block.field_71990_ca));
    }

    private static void createWood() {
        int blockID = BlockSettings.CUSTOMLOG.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomLog block = new BlockCustomLog(blockID);
        block.func_71864_b("extrabiomes.log").func_71884_a(Block.field_71967_e).func_71848_c(2.0f).func_71894_b(Block.field_71951_J.func_71904_a(null) * 5.0f).func_71849_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((Block)block, "axe", 0);
        proxy.registerBlock((Block)block, MultiItemBlock.class);
        proxy.registerOreInAllSubblocks("logWood", (Block)block);
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.field_71990_ca, 5, 5);
        Element.LOG_ACACIA.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.ACACIA.metadata()));
        Element.LOG_FIR.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.FIR.metadata()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        for (BlockCustomLog.BlockType type : BlockCustomLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.field_71990_ca, type.metadata());
        }
    }
}

