/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockAutumnLeaves
extends BlockLeavesBase
implements IShearable {
    private Icon[] textures = new Icon[]{null, null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbrownfancy");
        this.textures[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbrownfast");
        this.textures[2] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesorangefancy");
        this.textures[3] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesorangefast");
        this.textures[4] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesredfancy");
        this.textures[5] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesredfast");
        this.textures[6] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesyellowfancy");
        this.textures[7] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesyellowfast");
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockAutumnLeaves(int id, int index, Material material, boolean useFastGraphics) {
        super(id, material, useFastGraphics);
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, BlockAutumnLeaves.setDecayOnMetadata(world.func_72805_g(x, y, z)), 3);
    }

    public void func_71852_a(World world, int x, int y, int z, int blockID, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    int id = world.func_72798_a(x + x1, y + y1, z + z1);
                    if (Block.field_71973_m[id] == null) continue;
                    Block.field_71973_m[id].beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int func_71899_b(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(World world, int x, int y, int z, int metadata, int par7) {
        int idDropped = this.func_71885_a(metadata, world.field_73012_v, par7);
        if (idDropped > 0) {
            this.func_71929_a(world, x, y, z, new ItemStack(this.func_71885_a(metadata, world.field_73012_v, par7), 1, this.func_71899_b(metadata)));
        }
    }

    public void func_71914_a(World world, int x, int y, int z, int metadata, float chance, int par7) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(20) == 0) {
            this.doSaplingDrop(world, x, y, z, metadata, par7);
        }
        if (world.field_73012_v.nextInt(200) == 0) {
            this.func_71929_a(world, x, y, z, new ItemStack(Item.field_77706_j, 1, 0));
        }
    }

    public Icon func_71858_a(int side, int metadata) {
        if ((metadata = BlockAutumnLeaves.unmarkedMetadata(metadata)) < 0 || metadata > 4) {
            metadata = 0;
        }
        return this.textures[BlockAutumnLeaves.unmarkedMetadata(metadata) * 2 + (!this.func_71926_d() ? 0 : 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public int func_71885_a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingID() : Block.field_71987_y.field_71990_ca;
    }

    public boolean isLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_71926_d() {
        return Block.field_71952_K.func_71926_d();
    }

    public boolean isShearable(ItemStack item, World world, int x, int y, int z) {
        return true;
    }

    public void func_71891_b(World world, int x, int y, int z, Entity entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockAutumnLeaves.unmarkedMetadata(world.func_72805_g(x, y, z))));
        return ret;
    }

    public int func_71925_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_94575_c(x, y, z, 0);
    }

    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.field_72131_c = !Block.field_71952_K.func_71926_d();
        return super.func_71877_c(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockAutumnLeaves.isUserPlaced(metadata) || !BlockAutumnLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 4;
        int rangeCheckChunk = 5;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.func_72904_c(x - 5, y - 5, z - 5, x + 5, y + 5, z + 5)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -4; var12 <= 4; ++var12) {
                for (var13 = -4; var13 <= 4; ++var13) {
                    for (var14 = -4; var14 <= 4; ++var14) {
                        int id = world.func_72798_a(x + var12, y + var13, z + var14);
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = Block.field_71973_m[id] != null && Block.field_71973_m[id].isWood(world, x + var12, y + var13, z + var14) ? 0 : (Block.field_71973_m[id] != null && Block.field_71973_m[id].isLeaves(world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 4; ++var12) {
                for (var13 = -4; var13 <= 4; ++var13) {
                    for (var14 = -4; var14 <= 4; ++var14) {
                        for (int var15 = -4; var15 <= 4; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.func_72921_c(x, y, z, BlockAutumnLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        BROWN(0),
        ORANGE(1),
        PURPLE(2),
        YELLOW(3);

        private final int metadata;
        private ItemStack sapling = new ItemStack(Block.field_71987_y);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockAutumnLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_AUTUMN_BROWN.isPresent()) {
                BlockType.BROWN.sapling = Element.SAPLING_AUTUMN_BROWN.get();
            }
            if (Element.SAPLING_AUTUMN_ORANGE.isPresent()) {
                BlockType.ORANGE.sapling = Element.SAPLING_AUTUMN_ORANGE.get();
            }
            if (Element.SAPLING_AUTUMN_PURPLE.isPresent()) {
                BlockType.PURPLE.sapling = Element.SAPLING_AUTUMN_PURPLE.get();
            }
            if (Element.SAPLING_AUTUMN_YELLOW.isPresent()) {
                BlockType.YELLOW.sapling = Element.SAPLING_AUTUMN_YELLOW.get();
            }
            loadedCustomBlocks = true;
        }

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        int getSaplingID() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.field_77993_c;
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77960_j();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

