/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BlockCustomSapling
extends BlockFlower {
    private Icon[] textures = new Icon[]{null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 7;
    private static final int METADATA_MARKBIT = 8;
    private static int forestrySoilID = 0;

    private static boolean isEnoughLightToGrow(World world, int x, int y, int z) {
        return world.func_72957_l(x, y, z) >= 9;
    }

    private static boolean isMarkedMetadata(int metadata) {
        return (metadata & 8) != 0;
    }

    private static int markedMetadata(int metadata) {
        return metadata | 8;
    }

    public static void setForestrySoilID(int soilID) {
        forestrySoilID = soilID;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 7;
    }

    public BlockCustomSapling(int id, int index) {
        super(id);
        float var3 = 0.4f;
        this.func_71905_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegistry) {
        this.textures[0] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingbrown");
        this.textures[1] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingorange");
        this.textures[2] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingred");
        this.textures[3] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingyellow");
        this.textures[4] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingfir");
        this.textures[5] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingredwood");
        this.textures[6] = iconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingacacia");
    }

    private void attemptGrowTree(World world, int x, int y, int z, Random rand) {
        if (BlockCustomSapling.isEnoughLightToGrow(world, x, y + 1, z) && rand.nextInt(7) == 0) {
            int metadata = world.func_72805_g(x, y, z);
            if (!BlockCustomSapling.isMarkedMetadata(metadata)) {
                world.func_72921_c(x, y, z, BlockCustomSapling.markedMetadata(metadata), 3);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    protected boolean func_72263_d_(int id) {
        return TreeSoilRegistry.isValidSoil(id);
    }

    public int func_71899_b(int metadata) {
        return BlockCustomSapling.unmarkedMetadata(metadata);
    }

    public Icon func_71858_a(int side, int metadata) {
        if ((metadata = BlockCustomSapling.unmarkedMetadata(metadata)) < 0 || metadata > 6) {
            metadata = 0;
        }
        return this.textures[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void growTree(World world, int x, int y, int z, Random rand) {
        boolean isForestryFarmed;
        int metadata = BlockCustomSapling.unmarkedMetadata(world.func_72805_g(x, y, z));
        WorldGenerator tree = null;
        int x1 = 0;
        int z1 = 0;
        boolean isHuge = false;
        boolean bl = isForestryFarmed = world.func_72798_a(x, y - 1, z) == forestrySoilID;
        if (metadata == BlockType.BROWN.metadata()) {
            tree = rand.nextInt(20) == 0 ? new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.BROWN) : new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.BROWN);
        } else if (metadata == BlockType.ORANGE.metadata()) {
            tree = rand.nextInt(20) == 0 ? new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.ORANGE) : new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.ORANGE);
        } else if (metadata == BlockType.PURPLE.metadata()) {
            tree = rand.nextInt(20) == 0 ? new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.PURPLE) : new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.PURPLE);
        } else if (metadata == BlockType.YELLOW.metadata()) {
            tree = rand.nextInt(20) == 0 ? new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.YELLOW) : new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.YELLOW);
        } else if (metadata == BlockType.ACACIA.metadata()) {
            tree = new WorldGenAcacia(true);
        } else {
            for (x1 = 0; x1 >= -1; --x1) {
                for (z1 = 0; z1 >= -1; --z1) {
                    if (!this.isSameSapling(world, x + x1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1, y, z + z1 + 1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1 + 1, metadata)) continue;
                    tree = metadata == BlockType.FIR.metadata() ? new WorldGenFirTreeHuge(true) : new WorldGenRedwood(true);
                    isHuge = true;
                    break;
                }
                if (tree != null) break;
            }
            if (tree == null && metadata == BlockType.FIR.metadata()) {
                z1 = 0;
                x1 = 0;
                tree = new WorldGenFirTree(true);
            }
        }
        if (tree != null) {
            int offset;
            if (isHuge) {
                world.func_94575_c(x + x1, y, z + z1, 0);
                world.func_94575_c(x + x1 + 1, y, z + z1, 0);
                world.func_94575_c(x + x1, y, z + z1 + 1, 0);
                world.func_94575_c(x + x1 + 1, y, z + z1 + 1, 0);
            } else {
                world.func_94575_c(x, y, z, 0);
            }
            int n = offset = isHuge ? 1 : 0;
            if (!tree.func_76484_a(world, rand, x + x1 + offset, y, z + z1 + offset)) {
                if (isHuge) {
                    world.func_72832_d(x + x1, y, z + z1, this.field_71990_ca, metadata, 3);
                    world.func_72832_d(x + x1 + 1, y, z + z1, this.field_71990_ca, metadata, 3);
                    world.func_72832_d(x + x1, y, z + z1 + 1, this.field_71990_ca, metadata, 3);
                    world.func_72832_d(x + x1 + 1, y, z + z1 + 1, this.field_71990_ca, metadata, 3);
                } else {
                    world.func_72832_d(x, y, z, this.field_71990_ca, metadata, 3);
                }
            } else if (isForestryFarmed) {
                if (isHuge) {
                    world.func_94575_c(x + x1, y - 1, z + z1, Block.field_71939_E.field_71990_ca);
                    world.func_94575_c(x + x1 + 1, y - 1, z + z1, Block.field_71939_E.field_71990_ca);
                    world.func_94575_c(x + x1, y - 1, z + z1 + 1, Block.field_71939_E.field_71990_ca);
                    world.func_94575_c(x + x1 + 1, y - 1, z + z1 + 1, Block.field_71939_E.field_71990_ca);
                } else {
                    world.func_94575_c(x, y - 1, z, Block.field_71939_E.field_71990_ca);
                }
            }
        }
    }

    public boolean isSameSapling(World world, int x, int y, int z, int metadata) {
        return world.func_72798_a(x, y, z) == this.field_71990_ca && BlockCustomSapling.unmarkedMetadata(world.func_72805_g(x, y, z)) == metadata;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_71847_b(world, x, y, z, rand);
            this.attemptGrowTree(world, x, y, z, rand);
        }
    }

    public static enum BlockType {
        BROWN(0),
        ORANGE(1),
        PURPLE(2),
        YELLOW(3),
        FIR(4),
        REDWOOD(5),
        ACACIA(6);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

