/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;

@SideOnly(value=Side.CLIENT)
public abstract class Control {
    public static final String textureLocation = "powercrystalscore:textures/gui/";
    protected GuiContainer containerScreen;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean enabled = true;
    protected boolean visible = true;

    protected Control(GuiContainer guiContainer, int n, int n2, int n3, int n4) {
        this.containerScreen = guiContainer;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void drawTooltip(int n, int n2, float f) {
    }

    public GuiContainer getContainerScreen() {
        return this.containerScreen;
    }

    public final int getPosX() {
        return this.x;
    }

    public final int getPosY() {
        return this.y;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean onMousePressed(int n, int n2, int n3) {
        return false;
    }

    public void updateTick(int n, int n2) {
    }

    public void onMouseReleased(int n, int n2) {
    }

    public boolean onMouseWheel(int n, int n2, int n3) {
        return false;
    }

    public boolean onKeyTyped(char c, int n) {
        return false;
    }

    public boolean isPointInBounds(int n, int n2) {
        return n >= this.x - 1 && n < this.x + this.width + 1 && n2 >= this.y - 1 && n2 < this.y + this.height + 1;
    }
}

