/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.stronghold.ComponentTFStrongholdEntrance;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperAscender;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperLeftTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperRightTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdUpperTIntersection;
import twilightforest.structures.stronghold.TFStrongholdPieces;

public abstract class StructureTFStrongholdComponent
extends StructureTFComponent {
    public List<t> doors;

    public StructureTFStrongholdComponent(int i, int facing, int x, int y, int z2) {
        super(i);
        this.f = this.generateBoundingBox(facing, x, y, z2);
        this.setCoordBaseMode(facing);
    }

    public abstract age generateBoundingBox(int var1, int var2, int var3, int var4);

    public static age getComponentToAddBoundingBox(int x, int y, int z2, int xOff, int yOff, int zOff, int xSize, int ySize, int zSize, int facing) {
        switch (facing) {
            case 0: {
                return new age(x + xOff, y + yOff, z2 + zOff, x + xSize - 1 + xOff, y + ySize - 1 + yOff, z2 + zSize - 1 + zOff);
            }
            case 1: {
                return new age(x - zSize + 1 + zOff, y + yOff, z2 + xOff, x + zOff, y + ySize - 1 + yOff, z2 + xSize - 1 + xOff);
            }
            case 2: {
                return new age(x - xSize + 1 - xOff, y + yOff, z2 - zSize + 1 + zOff, x - xOff, y + ySize - 1 + yOff, z2 + zOff);
            }
            case 3: {
                return new age(x + zOff, y + yOff, z2 - xSize + 1 - xOff, x + zSize - 1 + zOff, y + ySize - 1 + yOff, z2 - xOff);
            }
        }
        return new age(x + xOff, y + yOff, z2 + zOff, x + xSize - 1 + xOff, y + ySize - 1 + yOff, z2 + zSize - 1 + zOff);
    }

    public void a(aiq parent, List list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
    }

    protected void addNewComponent(aiq entrance, List list, Random random, int facing, int x, int y, int z2) {
        int index = this.h + 1;
        int nFacing = (this.g + facing) % 4;
        int nx = this.a(x, z2);
        int ny = this.a(y);
        int nz2 = this.b(x, z2);
        if (index > 50 || this.isOutOfRange(entrance, nx, ny, nz2, 112)) {
            return;
        }
        StructureTFStrongholdComponent breakIn = this.findBreakInComponent(list, nx, ny, nz2);
        if (breakIn != null && breakIn.attemptToBreakIn(nx, ny, nz2)) {
            this.addDoorwayTo(x, y, z2, facing);
            return;
        }
        TFStrongholdPieces pieceList = ((ComponentTFStrongholdEntrance)entrance).lowerPieces;
        StructureTFStrongholdComponent nextComponent = pieceList.getNextComponent(entrance, list, random, index, nFacing, nx, ny, nz2);
        if (nextComponent != null) {
            list.add(nextComponent);
            nextComponent.a(entrance, list, random);
            this.addDoorwayTo(x, y, z2, facing);
        }
    }

    protected StructureTFStrongholdComponent findBreakInComponent(List<StructureTFStrongholdComponent> list, int x, int y, int z2) {
        for (StructureTFStrongholdComponent component : list) {
            if (component.f == null || !component.f.b(x, y, z2)) continue;
            return component;
        }
        return null;
    }

    protected void addNewUpperComponent(aiq parent, List list, Random random, int facing, int x, int y, int z2) {
        StructureTFStrongholdComponent attempted = null;
        int index = this.h + 1;
        int nFacing = (this.g + facing) % 4;
        int nx = this.a(x, z2);
        int ny = this.a(y);
        int nz2 = this.b(x, z2);
        if (index > 100 || this.isOutOfRange(parent, nx, ny, nz2, 48)) {
            return;
        }
        switch (random.nextInt(5)) {
            default: {
                attempted = new ComponentTFStrongholdUpperTIntersection(index, nFacing, nx, ny, nz2);
                break;
            }
            case 1: {
                attempted = new ComponentTFStrongholdUpperLeftTurn(index, nFacing, nx, ny, nz2);
                break;
            }
            case 2: {
                attempted = new ComponentTFStrongholdUpperRightTurn(index, nFacing, nx, ny, nz2);
                break;
            }
            case 3: {
                attempted = new ComponentTFStrongholdUpperCorridor(index, nFacing, nx, ny, nz2);
                break;
            }
            case 4: {
                attempted = new ComponentTFStrongholdUpperAscender(index, nFacing, nx, ny, nz2);
            }
        }
        if (attempted != null && aiq.a((List)list, (age)attempted.b()) == null) {
            list.add(attempted);
            attempted.a(parent, list, random);
        }
    }

    private boolean isOutOfRange(aiq parent, int nx, int ny, int nz2, int range) {
        return Math.abs(nx - parent.b().a) > range || Math.abs(nz2 - parent.b().c) > range;
    }

    protected void placeDoorwayAt(abv world, Random rand, int x, int y, int z2, age sbb) {
        if (x == 0 || x == this.getXSize()) {
            this.a(world, sbb, x, y, z2 - 2, x, y + 3, z2 + 2, this.deco.fenceID, this.deco.fenceMeta, 0, 0, false);
            this.a(world, sbb, x, y, z2 - 1, x, y + 3, z2 + 1);
        } else {
            this.a(world, sbb, x - 2, y, z2, x + 2, y + 3, z2, this.deco.fenceID, this.deco.fenceMeta, 0, 0, false);
            this.a(world, sbb, x - 1, y, z2, x + 1, y + 3, z2);
        }
    }

    protected int getXSize() {
        switch (this.getCoordBaseMode()) {
            default: {
                return this.f.b() - 1;
            }
            case 1: 
            case 3: 
        }
        return this.f.d() - 1;
    }

    protected void placeSmallDoorwayAt(abv world, Random rand, int facing, int x, int y, int z2, age sbb) {
        if (facing == 0 || facing == 2) {
            this.a(world, sbb, x - 1, y, z2, x + 1, y + 1, z2, aqw.cg.cF, 0, 0, 0, true);
            this.a(world, sbb, x, y, z2, x, y + 1, z2);
        } else {
            this.a(world, sbb, x, y, z2 - 1, x, y + 1, z2 + 1, aqw.cg.cF, 0, 0, 0, true);
            this.a(world, sbb, x, y, z2, x, y + 1, z2);
        }
    }

    public void placeCornerStatue(abv world, int x, int y, int z2, int facing, age sbb) {
        int ox = 1;
        int oz = 1;
        int smx = 2;
        int smz = 3;
        switch (facing) {
            case 0: {
                break;
            }
            case 1: {
                oz = -1;
                smz = 1;
                break;
            }
            case 2: {
                ox = -1;
                smx = 0;
                break;
            }
            case 3: {
                ox = -1;
                oz = -1;
                smx = 0;
                smz = 1;
            }
        }
        for (int sy = 0; sy < 5; ++sy) {
            this.a(world, this.deco.pillarID, this.deco.pillarMeta, x, y + sy, z2, sbb);
        }
        this.a(world, aqw.be.cF, 0, x + 0, y + 4, z2 + oz, sbb);
        this.a(world, aqw.be.cF, 0, x + ox, y + 4, z2 + 0, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smz), x + 0, y + 3, z2 + oz, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smx), x + ox, y + 3, z2 + 0, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smz) + 4, x + 0, y + 2, z2 + oz, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smx) + 4, x + ox, y + 2, z2 + 0, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smx) + 4, x + ox, y + 2, z2 + oz, sbb);
        this.a(world, aqw.cg.cF, 0, x + ox, y + 0, z2 + oz, sbb);
        this.a(world, aqw.cg.cF, 0, x + ox, y + 1, z2 + oz, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smz), x + 0, y + 0, z2 + oz, sbb);
        this.a(world, this.deco.stairID, this.getStairMeta(smx), x + ox, y + 0, z2 + 0, sbb);
    }

    public void placeWallStatue(abv world, int x, int y, int z2, int facing, age sbb) {
        int ox = 1;
        int oz = 1;
        for (int sy = 0; sy < 5; ++sy) {
            this.a(world, this.deco.pillarID, this.deco.pillarMeta, x, y + sy, z2, sbb);
        }
        if (facing == 0 || facing == 2) {
            if (facing == 2) {
                ox = -ox;
                oz = -oz;
            }
            this.a(world, aqw.be.cF, 0, x - ox, y + 4, z2, sbb);
            this.a(world, aqw.be.cF, 0, x + ox, y + 4, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing), x - ox, y + 3, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing), x + ox, y + 3, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing), x - ox, y + 3, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing), x + ox, y + 3, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing) + 4, x - ox, y + 2, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing) + 4, x + ox, y + 2, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x + 0, y + 2, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x - ox, y + 2, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x + ox, y + 2, z2 - oz, sbb);
            this.a(world, aqw.cg.cF, 0, x, y + 0, z2 - oz, sbb);
            this.a(world, aqw.cg.cF, 0, x, y + 1, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing), x - ox, y + 0, z2 + 0, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing), x + ox, y + 0, z2 + 0, sbb);
        } else {
            if (facing == 3) {
                oz = -oz;
                ox = -ox;
            }
            this.a(world, aqw.be.cF, 0, x, y + 4, z2 - oz, sbb);
            this.a(world, aqw.be.cF, 0, x, y + 4, z2 + oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing), x, y + 3, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing), x, y + 3, z2 + oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing), x + ox, y + 3, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing), x + ox, y + 3, z2 + oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing) + 4, x, y + 2, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing) + 4, x, y + 2, z2 + oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x + oz, y + 2, z2 + 0, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x + ox, y + 2, z2 - oz, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(1 + facing) + 4, x + ox, y + 2, z2 + oz, sbb);
            this.a(world, aqw.cg.cF, 0, x + ox, y + 0, z2, sbb);
            this.a(world, aqw.cg.cF, 0, x + ox, y + 1, z2, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(0 + facing), x, y + 0, z2 - ox, sbb);
            this.a(world, this.deco.stairID, this.getStairMeta(2 + facing), x, y + 0, z2 + ox, sbb);
        }
    }

    public boolean attemptToBreakIn(int wx, int wy, int wz) {
        if (!this.isValidBreakInPoint(wx, wy, wz)) {
            return false;
        }
        int dx = this.getRelativeX(wx, wz);
        int dy = this.getRelativeY(wy);
        int dz2 = this.getRelativeZ(wx, wz);
        this.addDoor(dx, dy, dz2);
        return true;
    }

    public void addDoorwayTo(int dx, int dy, int dz2, int facing) {
        switch (facing) {
            case 0: {
                this.addDoor(dx, dy, dz2 - 1);
                break;
            }
            case 1: {
                this.addDoor(dx + 1, dy, dz2);
                break;
            }
            case 2: {
                this.addDoor(dx, dy, dz2 + 1);
                break;
            }
            case 3: {
                this.addDoor(dx - 1, dy, dz2);
            }
        }
    }

    public void addDoor(int dx, int dy, int dz2) {
        if (this.doors == null) {
            this.doors = new ArrayList<t>();
        }
        this.doors.add(new t(dx, dy, dz2));
    }

    protected boolean isValidBreakInPoint(int wx, int wy, int wz) {
        if (wy < this.f.b || wy > this.f.e) {
            return false;
        }
        if (wx == this.f.a || wx == this.f.d) {
            return wz > this.f.c && wz < this.f.f;
        }
        if (wz == this.f.c || wz == this.f.f) {
            return wx > this.f.a && wx < this.f.d;
        }
        return false;
    }

    protected int getRelativeX(int x, int z2) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return x - this.f.a;
            }
            case 2: {
                return this.f.d - x;
            }
            case 1: {
                return z2 - this.f.c;
            }
            case 3: {
                return this.f.f - z2;
            }
        }
        return x;
    }

    protected int getRelativeY(int par1) {
        return par1 - this.f.b;
    }

    protected int getRelativeZ(int x, int z2) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return z2 - this.f.c;
            }
            case 2: {
                return this.f.f - z2;
            }
            case 1: {
                return this.f.d - x;
            }
            case 3: {
                return x - this.f.a;
            }
        }
        return z2;
    }

    public void placeDoors(abv world, Random rand, age sbb) {
        if (this.doors != null) {
            for (t doorCoords : this.doors) {
                this.placeDoorwayAt(world, rand, doorCoords.a, doorCoords.b, doorCoords.c, sbb);
            }
        }
    }

    protected void placeStrongholdWalls(abv world, age sbb, int sx, int sy, int sz, int dx, int dy, int dz2, Random rand, air randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z2 = sz; z2 <= dz2; ++z2) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z2 == sz || z2 == dz2;
                    int blockID = this.a(world, x, y, z2, sbb);
                    if (blockID == 0) {
                        if (!wall) continue;
                        this.a(world, aqw.B.cF, 0, x, y, z2, sbb);
                        continue;
                    }
                    if (wall && blockID == aqw.A.cF) continue;
                    randomBlocks.a(rand, x, y, z2, wall);
                    this.a(world, randomBlocks.a(), randomBlocks.b(), x, y, z2, sbb);
                }
            }
        }
    }

    protected void placeUpperStrongholdWalls(abv world, age sbb, int sx, int sy, int sz, int dx, int dy, int dz2, Random rand, air randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z2 = sz; z2 <= dz2; ++z2) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z2 == sz || z2 == dz2;
                    int blockID = this.a(world, x, y, z2, sbb);
                    if ((blockID <= 0 || aqw.s[blockID].cU != ajz.e && aqw.s[blockID].cU != ajz.b && aqw.s[blockID].cU != ajz.c) && (blockID != 0 || rand.nextInt(3) != 0 || this.a(world, x, y - 1, z2, sbb) != aqw.br.cF)) continue;
                    randomBlocks.a(rand, x, y, z2, wall);
                    this.a(world, randomBlocks.a(), randomBlocks.b(), x, y, z2, sbb);
                }
            }
        }
    }
}

