/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiColor;
import powercrystals.core.gui.GuiRender;
import powercrystals.core.gui.controls.IListBoxElement;

public abstract class ListBox
extends Control {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    private int _marginTop = 2;
    private int _marginLeft = 2;
    private int _marginRight = 2;
    private int _marginBottom = 2;
    private List<IListBoxElement> _elements = new LinkedList<IListBoxElement>();
    private int _firstIndexDisplayed;
    private int _selectedIndex;

    public ListBox(GuiContainer guiContainer, int n, int n2, int n3, int n4) {
        super(guiContainer, n, n2, n3, n4);
    }

    public void add(IListBoxElement iListBoxElement) {
        this._elements.add(iListBoxElement);
    }

    public void add(Collection<? extends IListBoxElement> collection) {
        this._elements.addAll(collection);
    }

    public void remove(IListBoxElement iListBoxElement) {
        this._elements.remove(iListBoxElement);
    }

    public void removeAt(int n) {
        this._elements.remove(n);
    }

    public int getContentWidth() {
        return this.width - this._marginLeft - this._marginRight;
    }

    public int getContentHeight() {
        return this.height - this._marginTop - this._marginBottom;
    }

    protected int getContentTop() {
        return this.y + this._marginTop;
    }

    protected int getContentLeft() {
        return this.x + this._marginLeft;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        GuiRender.drawRect(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, this.borderColor);
        GuiRender.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        int n3 = 0;
        GL11.glDisable((int)2896);
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n3 + this._elements.get(i).getHeight() <= this.getContentHeight(); ++i) {
            if (i == this._selectedIndex) {
                this._elements.get(i).draw(this, this.getContentLeft(), this.getContentTop() + n3, this.selectedLineColor, this.selectedTextColor);
            } else {
                this._elements.get(i).draw(this, this.getContentLeft(), this.getContentTop() + n3, this.backgroundColor, this.textColor);
            }
            n3 += this._elements.get(i).getHeight();
        }
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n5 + (n4 = this._elements.get(i).getHeight()) <= this.getContentHeight(); ++i) {
            if (this.getContentTop() + n5 <= n2 && this.getContentTop() + n5 + n4 >= n2) {
                this.setSelectedIndex(i);
                this.onElementClicked(this._elements.get(i));
                break;
            }
            n5 += n4;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        if (n3 > 0) {
            this.scrollUp();
        } else if (n3 < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int n = 0;
        int n2 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n + this._elements.get(i).getHeight() <= this.height; ++i) {
            n += this._elements.get(i).getHeight();
            ++n2;
        }
        if (this._firstIndexDisplayed + n2 < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScroll(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScroll(this._firstIndexDisplayed);
    }

    public int getLastScrollPosition() {
        int n = this._elements.size() - 1;
        for (int i = this._elements.get(n).getHeight(); n > 0 && i < this.height; i += this._elements.get(--n).getHeight()) {
        }
        return n + 1;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object object) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this._elements.get(i).getValue().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        return this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int n) {
        if (n >= 0 && n < this._elements.size() && n != this._selectedIndex) {
            this._selectedIndex = n;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int n) {
        return this._elements.get(n);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollTo(int n) {
        if (n >= 0 && n < this._elements.size()) {
            this._firstIndexDisplayed = n;
        }
    }

    protected void onElementClicked(IListBoxElement iListBoxElement) {
    }

    protected void onScroll(int n) {
    }

    protected abstract void onSelectionChanged(int var1, IListBoxElement var2);
}

