/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluidRoot
extends Block {
    public static final Map<Integer, Boolean> displacementIds = new HashMap<Integer, Boolean>();
    public int quantaPerBlock = 8;
    public float quantaPerBlockFloat = 8.0f;
    public int density = 1;
    public int densityDir = -1;
    public int tickRate = 20;
    public int renderPass = 1;
    public int maxScaledLight = 0;

    public BlockFluidRoot(int n, Material material) {
        super(n, material);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_71907_b(true);
        this.func_71896_v();
    }

    public BlockFluidRoot setQuantaPerBlock(int n) {
        if (n > 16 || n < 1) {
            n = 8;
        }
        this.quantaPerBlock = n;
        this.quantaPerBlockFloat = n;
        return this;
    }

    public BlockFluidRoot setDensity(int n) {
        if (n == 0) {
            n = 1;
        }
        this.density = n;
        this.densityDir = n > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidRoot setTickRate(int n) {
        if (n <= 0) {
            n = 20;
        }
        this.tickRate = n;
        return this;
    }

    public BlockFluidRoot setRenderPass(int n) {
        this.renderPass = n;
        return this;
    }

    public BlockFluidRoot setMaxScaledLight(int n) {
        this.maxScaledLight = n;
        return this;
    }

    public boolean canDisplace(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72798_a(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(n4)) {
            return displacementIds.get(n4);
        }
        Material material = Block.field_71973_m[n4].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76237_B;
    }

    public boolean displaceIfPossible(World world, int n, int n2, int n3) {
        int n4 = world.func_72798_a(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == this.field_71990_ca) {
            return false;
        }
        if (displacementIds.containsKey(n4)) {
            if (displacementIds.get(n4).booleanValue()) {
                Block.field_71973_m[n4].func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
                return true;
            }
            return false;
        }
        Material material = Block.field_71973_m[n4].field_72018_cp;
        if (material.func_76230_c() || material == Material.field_76237_B) {
            return false;
        }
        Block.field_71973_m[n4].func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
        return true;
    }

    public void func_71861_g(World world, int n, int n2, int n3) {
        world.func_72836_a(n, n2, n3, this.field_71990_ca, this.tickRate);
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        world.func_72836_a(n, n2, n3, this.field_71990_ca, this.tickRate);
    }

    public boolean func_82506_l() {
        return false;
    }

    public boolean func_71913_a(int n, boolean bl) {
        return bl && n == this.quantaPerBlock - 1;
    }

    public boolean func_71918_c(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public AxisAlignedBB func_71872_e(World world, int n, int n2, int n3) {
        return null;
    }

    public int func_71885_a(int n, Random random, int n2) {
        return 0;
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public int func_71859_p_(World world) {
        return this.tickRate;
    }

    public void func_71901_a(World world, int n, int n2, int n3, Entity entity, Vec3 vec3) {
        if (this.densityDir > 0) {
            return;
        }
        Vec3 vec32 = this.getFlowVector((IBlockAccess)world, n, n2, n3);
        vec3.field_72450_a += vec32.field_72450_a * (double)(this.quantaPerBlock * 4);
        vec3.field_72448_b += vec32.field_72448_b * (double)(this.quantaPerBlock * 4);
        vec3.field_72449_c += vec32.field_72449_c * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(iBlockAccess, n, n2, n3);
        }
        int n4 = iBlockAccess.func_72805_g(n, n2, n3);
        return (int)((float)n4 / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_71870_f(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        float f;
        float f2 = iBlockAccess.func_72801_o(n, n2, n3);
        return f2 > (f = iBlockAccess.func_72801_o(n, n2 + 1, n3)) ? f2 : f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71874_e(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72802_i(n, n2, n3, 0);
        int n5 = iBlockAccess.func_72802_i(n, n2 + 1, n3, 0);
        int n6 = n4 & 0xFF;
        int n7 = n5 & 0xFF;
        int n8 = n4 >> 16 & 0xFF;
        int n9 = n5 >> 16 & 0xFF;
        return (n6 > n7 ? n6 : n7) | (n8 > n9 ? n8 : n9) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        return this.renderPass;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        if (iBlockAccess.func_72798_a(n, n2, n3) != this.field_71990_ca) {
            return !iBlockAccess.func_72804_r(n, n2, n3);
        }
        Material material = iBlockAccess.func_72803_f(n, n2, n3);
        return material == this.field_72018_cp ? false : super.func_71877_c(iBlockAccess, n, n2, n3, n4);
    }

    public static final int getDensity(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        Block block = Block.field_71973_m[iBlockAccess.func_72798_a(n, n2, n3)];
        if (!(block instanceof BlockFluidRoot)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidRoot)block).density;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getFlowDirection(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        Block block = Block.field_71973_m[iBlockAccess.func_72798_a(n, n2, n3)];
        if (!(Block.field_71973_m[iBlockAccess.func_72798_a(n, n2, n3)] instanceof BlockFluidRoot)) {
            return -1000.0;
        }
        Vec3 vec3 = ((BlockFluidRoot)block).getFlowVector(iBlockAccess, n, n2, n3);
        return vec3.field_72450_a == 0.0 && vec3.field_72449_c == 0.0 ? -1000.0 : Math.atan2(vec3.field_72449_c, vec3.field_72450_a) - 1.5707963267948966;
    }

    public final int getQuantaValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (iBlockAccess.func_72798_a(n, n2, n3) == 0) {
            return 0;
        }
        if (iBlockAccess.func_72798_a(n, n2, n3) != this.field_71990_ca) {
            return -1;
        }
        int n4 = iBlockAccess.func_72805_g(n, n2, n3) + 1;
        return n4;
    }

    public final int getQuantaValueBelow(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = this.getQuantaValue(iBlockAccess, n, n2, n3);
        if (n5 >= n4) {
            return -1;
        }
        return n5;
    }

    public final int getQuantaValueAbove(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = this.getQuantaValue(iBlockAccess, n, n2, n3);
        if (n5 <= n4) {
            return -1;
        }
        return n5;
    }

    public final float getQuantaPercentage(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = this.getQuantaValue(iBlockAccess, n, n2, n3);
        return (float)n4 / this.quantaPerBlockFloat;
    }

    public Vec3 getFlowVector(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4;
        Vec3 vec3 = iBlockAccess.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        int n5 = this.quantaPerBlock - this.getQuantaValue(iBlockAccess, n, n2, n3);
        for (n4 = 0; n4 < 4; ++n4) {
            int n6;
            int n7 = n;
            int n8 = n3;
            switch (n4) {
                case 0: {
                    --n7;
                    break;
                }
                case 1: {
                    --n8;
                    break;
                }
                case 2: {
                    ++n7;
                    break;
                }
                case 3: {
                    ++n8;
                }
            }
            int n9 = this.quantaPerBlock - this.getQuantaValue(iBlockAccess, n7, n2, n8);
            if (n9 >= this.quantaPerBlock) {
                if (iBlockAccess.func_72803_f(n7, n2, n8).func_76230_c() || (n9 = this.quantaPerBlock - this.getQuantaValue(iBlockAccess, n7, n2 - 1, n8)) < 0) continue;
                n6 = n9 - (n5 - this.quantaPerBlock);
                vec3 = vec3.func_72441_c((double)((n7 - n) * n6), (double)((n2 - n2) * n6), (double)((n8 - n3) * n6));
                continue;
            }
            if (n9 < 0) continue;
            n6 = n9 - n5;
            vec3 = vec3.func_72441_c((double)((n7 - n) * n6), (double)((n2 - n2) * n6), (double)((n8 - n3) * n6));
        }
        if (iBlockAccess.func_72798_a(n, n2 + 1, n3) == this.field_71990_ca) {
            n4 = 0;
            if (this.func_71924_d(iBlockAccess, n, n2, n3 - 1, 2)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n, n2, n3 + 1, 3)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n - 1, n2, n3, 4)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n + 1, n2, n3, 5)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n, n2 + 1, n3 - 1, 2)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n, n2 + 1, n3 + 1, 3)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n - 1, n2 + 1, n3, 4)) {
                n4 = 1;
            } else if (this.func_71924_d(iBlockAccess, n + 1, n2 + 1, n3, 5)) {
                n4 = 1;
            }
            if (n4 != 0) {
                vec3 = vec3.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.func_72432_b();
        return vec3;
    }

    static {
        displacementIds.put(Block.field_72054_aE.field_71990_ca, false);
        displacementIds.put(Block.field_72045_aL.field_71990_ca, false);
        displacementIds.put(Block.field_72053_aD.field_71990_ca, false);
        displacementIds.put(Block.field_72042_aI.field_71990_ca, false);
        displacementIds.put(Block.field_72040_aX.field_71990_ca, false);
    }
}

