#define message_id
/* message_id();
Returns the last received id.

*/
return global.___SOC_MESSAGE_ID;
#define message_player
/* message_player();
Returns the last received player.

*/
return global.___SOC_MESSAGE_PLAYER;
#define message_receive
/* message_receive();
Receives a new message, or forward them if you're hosting.
*/

var i, cur, size, player, socket;
// If we are hosting...
if(global.___SOC_PLAYER_HOST) {
  // We first check if there are new connections
  socket=soc_accept(global.___SOC_PLAYER_LISTEN);
  if(socket!=0) {
    // If there is, we find a player id for them
    player=2;
    while(ds_map_exists(global.___SOC_PLAYER_MAP, player)) {
      player+=1;
    }
    ds_map_add(global.___SOC_PLAYER_MAP, player, socket);
    // And send it to them.
    message_send(0, player, string(player));
    message_send(0, player, string(current_time));
  }

  cur=ds_map_find_first(global.___SOC_PLAYER_MAP);
  size=ds_map_size(global.___SOC_PLAYER_MAP);
  // For each connection
  for(i=0; i<size; i+=1) {
    // First we check if there is anything we can receive
    socket=ds_map_find_value(global.___SOC_PLAYER_MAP, cur);
    if(soc_peek(socket, SOC_BYTE)) {
      // If there is, we receive it.
      global.___SOC_MESSAGE_ID=soc_receive(socket, SOC_BYTE);
      global.___SOC_MESSAGE_PLAYER=soc_receive(socket, SOC_SHORT);
      size=soc_receive(socket, SOC_BYTE);
      global.___SOC_MESSAGE_VALUE=soc_receive(socket, SOC_STRING, size);
      // If it is directed to us..
      if(message_player()==1) {
        global.___SOC_MESSAGE_PLAYER=cur;
        // We have a new message.
        return true;
      }
      // If it is for all players or one other player...
      // Send it to them.
      message_send(message_id(), message_player(), message_value(), cur);
      // If its for all players..
      if(message_player()==0) {
        global.___SOC_MESSAGE_PLAYER=cur;
        // It is also for the server, so return.
        return true;
      }
    }
    cur=ds_map_find_next(global.___SOC_PLAYER_MAP, cur);
  }
} else {
  // This is the client part.
  // If there is a new message...
  if(soc_peek(global.___SOC_PLAYER_SOCKET, SOC_BYTE)) {
    // Receive it.
    global.___SOC_MESSAGE_ID=soc_receive(global.___SOC_PLAYER_SOCKET, SOC_BYTE);
    global.___SOC_MESSAGE_PLAYER=soc_receive(global.___SOC_PLAYER_SOCKET, SOC_SHORT);
    size=soc_receive(global.___SOC_PLAYER_SOCKET, SOC_BYTE);
    global.___SOC_MESSAGE_VALUE=soc_receive(global.___SOC_PLAYER_SOCKET, SOC_STRING, size);
    return true;
  }
}
// No messages arrived.
return false;

#define message_send
/* message_send( id, player, value);
Sends a message.

id      - The message id.
player  - The player.
value   - The string to send.
*/

var buf, cur, size, i;
// Create a buffer.
buf=buffer_create();
// Fills it.
buffer_add(buf, SOC_BYTE, argument0);
if(global.___SOC_PLAYER_HOST) {
  if(argument3==0) {
    buffer_add(buf, SOC_SHORT, 1);
  } else {
    buffer_add(buf, SOC_SHORT, argument3);
  }
} else {
  buffer_add(buf, SOC_SHORT, argument1);
}
buffer_add(buf, SOC_BYTE, min(255, string_length(argument2)));
buffer_add(buf, SOC_STRING, min(255, string_length(argument2)), argument2);
// If we are hosting...
if(global.___SOC_PLAYER_HOST) {
  // If the message is for all players...
  if(argument1==0) {
    size=ds_map_size(global.___SOC_PLAYER_MAP);
    cur=ds_map_find_first(global.___SOC_PLAYER_MAP);
    // Loop through all players and send the message to them.
    for(i=0; i<size; i+=1) {
      if(cur!=argument3&&ds_map_exists(global.___SOC_PLAYER_MAP, cur)) {
        soc_send(ds_map_find_value(global.___SOC_PLAYER_MAP, cur), buf);
      }
      cur=ds_map_find_next(global.___SOC_PLAYER_MAP, cur);
    }
  } else {
    // Else send the message to the player is directed to.
    if(ds_map_exists(global.___SOC_PLAYER_MAP, argument1)) {
      soc_send(ds_map_find_value(global.___SOC_PLAYER_MAP, argument1), buf);
    }
  }
} else {
  // Just send it to the server, and let it handle the message.
  soc_send(global.___SOC_PLAYER_SOCKET, buf);
}
// Destroy the buffer.
buffer_destroy(buf);
#define message_value
/* message_value();
Returns the last received value.

*/

return global.___SOC_MESSAGE_VALUE;
#define player_connect
/* player_connect(port, ip);
Connect to a direct server.

port  - The port to connect to.
ip    - The ip address to connect to.
*/

var time;
// First we connect to the server.
global.___SOC_PLAYER_SOCKET=soc_create(SOC_TCP, argument0, argument1);
if(global.___SOC_PLAYER_SOCKET==0) {
  return false;
}
// We are not hosting.
global.___SOC_PLAYER_HOST=false;

global.___SOC_PLAYER_ID=0;
time=current_time+5000;

// Player Id.
while(time>current_time) {
  if(message_receive()) {
    // Receive our own player id.
    global.___SOC_PLAYER_ID=real(message_value()); 
    break;
  }
  // Slowdown the loop.
  sleep(50);
}

// Server Time.
while(time>current_time) {
  if(message_receive()) {
    // Receive the current Server Time offset.
    global.___SOC_PLAYER_TIME=real(message_value())-current_time; 
    break;
  }
  // Slowdown the loop.
  sleep(50);
}

if(global.___SOC_PLAYER_ID==-1) {
  // Failed to connect.
  soc_destroy(global.___SOC_PLAYER_SOCKET);
  global.___SOC_PLAYER_SOCKET=0;
  return false;
}
return true;
#define player_disconnect
/* player_disconnect();
Disconnect from a direct server.

*/

// If we're hosting...
if(global.___SOC_PLAYER_HOST) {
  // Destroy the listening socket.
  soc_destroy(global.___SOC_PLAYER_LISTEN);
  // And all already connected sockets.
  while(ds_map_size(global.___SOC_PLAYER_MAP)!=0) {
    cur=ds_map_find_first(global.___SOC_PLAYER_MAP);
    soc_destroy(ds_map_find_value(global.___SOC_PLAYER_MAP, cur));
    ds_map_delete(global.___SOC_PLAYER_MAP, cur);
  }
  // And free the map.
  ds_map_destroy(global.___SOC_PLAYER_MAP);
} else {
  // If we are a client, only destroy the server connection.
  soc_destroy(global.___SOC_PLAYER_SOCKET);
}
#define player_listen
/* player_listen(port);
Set up a direct server.

port    - The port number to listen on.
*/

// Create a map to store the player ids in.
global.___SOC_PLAYER_MAP=ds_map_create();
// We are hosting.
global.___SOC_PLAYER_HOST=true;
// Create a listening socket.
global.___SOC_PLAYER_LISTEN=soc_create(SOC_TCP|SOC_LISTEN, argument0);
// The servers player id is always 1.
global.___SOC_PLAYER_ID=1;
return true;
#define player_id
/* player_id();
Returns the local player id.

*/

return global.___SOC_PLAYER_ID;
#define server_time
/* server_time();
Returns the current_time at the server.
*/

// If we're hosting...
if(global.___SOC_PLAYER_HOST) {
  return current_time;
} else {
  return global.___SOC_PLAYER_TIME+current_time;
}
