#define soc_ipaddress_internet
/* soc_ipaddress_internet();
Returns your ipaddress like it is to other computers on the web, not
the local one soc_ipaddress() returns.

*/

var connect, ip, length, str;
// Then we connect to whatismyip.org on port 80 (http).
connect=soc_create(SOC_TCP|SOC_HANG, 80, "whatismyip.org");

// If we failed to connect, return a empty string.
if(connect==0) {
  return "";
}

// First we request the index.
soc_send_token(connect, "GET / HTTP/1.0");
// Tell them which domain we want to access, in case more
// domains are hosted at the same server.
soc_send_token(connect, "Host: whatismyip.org");
// Then we send our User-Agent, which is the name of the 
// program sending the request.
soc_send_token(connect, "User-Agent: SimpleOnlineCommunication");
// We end our request with a empty token.
soc_send_token(connect, "");

// Now the server will sent back alot data, like server time, cookies, etc.
// Which we'll discard.
str=soc_receive_token(connect);
// They will also end with a empty token.
while(str!="") {
  // If the token holds info about the size of the string,
  if(string_pos("Content-Length: ", str)!=0) {
    // We store it in a variable.
    length=real(string_copy(str, string_length("Content-Length: ")+1, string_length(str)-string_length("Content-Length: ")));
  }
  // And we receive the next token.
  str=soc_receive_token(connect);
}

// When they are finished, we can receive the ipaddress.
ip=soc_receive(connect, SOC_STRING, length);

// Close the connection.
soc_destroy(connect);
// Return the ipaddress.
return ip;

