[[FX]]
sampler2D buf0 = sampler_state {
   Address = Clamp;
};
context BLUR_W {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_BLUR_W; 
}
context BLUR_H {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_BLUR_H; 
}
float4 blurParam = {.0175, 0, 0, 0};
//float4 blurParam = {.05, .05, 0, 0};

[[VS_FSQUAD]]
uniform mat4 projMat;
attribute vec3 vertPos;
varying vec2 texCoords;  
void main(void) {
   texCoords = vertPos.xy;
   gl_Position = projMat * vec4(vertPos, 1);
}

[[FS_BLUR_W]]
vec2 position[11]  = vec2[11] ( 
	vec2(-1.0, 0.0), vec2(-0.8, 0.0), vec2(-0.6, 0.0), vec2(-0.4, 0.0), vec2(-0.2, 0.0), vec2(0.0, 0.0), 
	vec2(0.2, 0.0), vec2(0.4, 0.0), vec2(0.6, 0.0), vec2(0.8, 0.0), vec2(1.0, 0.0) 
); 
float samples[11] = float[11] ( 
	0.01222447, 0.02783468, 0.06559061, 0.12097757, 0.17466632, 0.19741265,
	0.17466632, 0.12097757, 0.06559061, 0.02783468, 0.01222447 
); 
uniform sampler2D buf0; 
uniform vec4 blurParam;
varying vec2 texCoords;
void main(void) {
	gl_FragColor = vec4(0);
	for(int i = 0 ;i < 11; i++ ) { 
		gl_FragColor += texture2D(buf0, texCoords + (position[i] * blurParam.x)) * samples[i]; 
	} 
} 
[[FS_BLUR_H]]
vec2 position[11]  = vec2[11] ( 
	vec2(0.0, -1.0), vec2(0.0, -0.8), vec2(0.0, -0.6), vec2(0.0, -0.4), vec2(0.0, -0.2), vec2(0.0, 0.0), 
	vec2(0.0, 0.2), vec2(0.0, 0.4), vec2(0.0, 0.6), vec2(0.0, 0.8), vec2(0.0, 1.0) 
); 
float samples[11] = float[11] ( 
	0.01222447, 0.02783468, 0.06559061, 0.12097757, 0.17466632,0.19741265,
	0.17466632, 0.12097757, 0.06559061, 0.02783468, 0.01222447 
); 
uniform sampler2D buf0; 
uniform vec4 blurParam;
varying vec2 texCoords;
void main(void) {
	gl_FragColor = vec4(0);
	for(int i = 0 ;i < 11; i++ ) { 
		gl_FragColor += texture2D(buf0, texCoords + (position[i] * blurParam.x)) * samples[i]; 
	} 
} 