[[FX]]
context ATTRIBPASS {
	VertexShader = compile GLSL VS_GENERAL;
	PixelShader = compile GLSL FS_ATTRIBPASS;
}

context SSS_BACK {
	VertexShader = compile GLSL VS_GENERAL;
	PixelShader = compile GLSL FS_SSS_BACK;
	CullMode = Front;
	//BlendMode = Add;
}
context SSS_FRONT {
	VertexShader = compile GLSL VS_GENERAL;
	PixelShader = compile GLSL FS_SSS_FRONT;
	CullMode = Back;
	//BlendMode = Add;
}

samplerCube envMap = sampler_state {
	Address = Clamp;
	Filter = Bilinear;
	MaxAnisotropy = 1;
};

float4 baseColor = {0, 0, 0, 0};

[[VS_GENERAL]]
// =================================================================================================
uniform mat4 viewProjMat;
uniform mat4 viewMat;
uniform mat4 worldMat;
uniform	mat3 worldNormalMat;
uniform vec3 viewerPos;
attribute vec3 vertPos;
attribute vec3 normal;
varying vec4 pos, vsPos;
varying vec3 tsbNormal, camNormal;
varying float dist;

void main(void) {
	tsbNormal = normalize(worldNormalMat * normal);
	camNormal = normalize(mat3(viewProjMat) * worldNormalMat * normal);
	pos = worldMat * vec4(vertPos, 1.0);
	vsPos = pos * viewProjMat;
	dist = (distance(viewerPos, pos.xyz) / 64);
	gl_Position = viewProjMat * pos;
}

[[FS_ATTRIBPASS]]
// =================================================================================================
uniform vec3 viewerPos;
varying vec4 pos, vsPos;
varying vec3 tsbNormal, camNormal;
varying float dist;
uniform vec4 baseColor;
uniform samplerCube envMap;

void main(void) {
	vec3 refl = textureCube(envMap, reflect(pos.xyz - viewerPos, normalize(tsbNormal))).rgb;
	gl_FragData[0].rgb = pos.xyz - viewerPos;
	gl_FragData[0].a = 1 - dist;
	gl_FragData[1].rgb = normalize(tsbNormal);
	float f = (distance(normalize(camNormal), vec3(0, 0, -.5))).r;
	f = pow(f, 16);
	gl_FragData[1].a = f;
	gl_FragData[2].rgb = baseColor + baseColor * vec4(refl, 1) * .75;
	gl_FragData[2].a = 1;
}

[[FS_SSS_BACK]]
// =================================================================================================
varying float dist;
void main(void) {
	gl_FragData[0].rgb = dist;
}
[[FS_SSS_FRONT]]
// =================================================================================================
varying float dist;
void main(void) {
	gl_FragData[0].rgb = dist;
}

