[[FX]]
sampler2D buf0 = sampler_state {
   Address = Clamp;
};
sampler2D buf1 = sampler_state {
   Address = Clamp;
};
sampler2D buf2 = sampler_state {
   Address = Clamp;
};
sampler2D buf3 = sampler_state {
   Address = Clamp;
};
sampler2D noiseMap = sampler_state
{
	Texture = "noise.tga";
};

context NULL {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_NULL; 
}
context BLOOM {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_BLOOM; 
}
context BLOOM_MIX {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_BLOOM_MIX; 
}
context COMPOSE {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_COMPOSE; 
}
context DOF {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_DOF; 
}
context SSS_MAKE {
	VertexShader = compile GLSL VS_FSQUAD; 
	PixelShader = compile GLSL FS_SSS_MAKE; 
}

[[VS_FSQUAD]]
// =================================================================================================
uniform mat4 projMat;
attribute vec3 vertPos;
varying vec2 texCoords;  
void main(void) {
   texCoords = vertPos.xy;
   gl_Position = projMat * vec4(vertPos, 1);
}

[[FS_NULL]]
// =================================================================================================
uniform sampler2D buf0;
varying vec2 texCoords;
void main(void) {
	gl_FragColor = texture2D(buf0, texCoords);
}

[[FS_BLOOM]]
// =================================================================================================
uniform sampler2D buf0;
varying vec2 texCoords;
void main(void) {
	vec3 blur = texture2D(buf0, texCoords);
	float sat = (blur.r + blur.g + blur.b) / 3;

	sat = pow(sat, 16);
	
	blur *= sat;
	gl_FragColor = vec4(blur, 1);
}

[[FS_BLOOM_MIX]]
// =================================================================================================
uniform sampler2D buf0;
uniform sampler2D buf1;
varying vec2 texCoords;
void main(void) {
	gl_FragColor = texture2D(buf0, texCoords) + texture2D(buf1, texCoords);
}

[[FS_COMPOSE]]
// =================================================================================================
vec3 desaturate(vec3 color, float amount) {
    vec3 gray = vec3(dot(vec3(.5, .5, .5), color));
    return vec3(mix(color, gray, amount));
}
uniform sampler2D buf0;
uniform sampler2D buf1;
uniform sampler2D buf2;
uniform sampler2D buf3;
uniform mat4 viewProjMat;
uniform	mat3 worldNormalMat;
varying vec2 texCoords;
uniform vec3 viewerPos;

void main(void) {
	vec3 pos = texture2D(buf0, texCoords).rgb;
	float depthf = texture2D(buf0, texCoords).a;
	vec3 depth = vec3(depthf);
	vec3 normal = texture2D(buf1, texCoords).rgb;
	vec3 fresnel = texture2D(buf1, texCoords).a;
	vec3 color = texture2D(buf2, texCoords).rgb;
	vec3 mask = texture2D(buf2, texCoords).a;
	vec3 sss = texture2D(buf3, texCoords).rgb;
	float f = fresnel.r;
	vec3 light = normal * vec3(.25, 1, .25);
	light = desaturate(light, 1);
	light *= light * light;
	light *= 2;
	
	float sss_edge = 1 - sss.r;
	float sss_dark = sss.r * 0.75;
	sss_edge = pow(sss_edge, 32) * depthf * .75;
	sss_dark *= 8;
	vec3 prefrag = color * (1 - sss_dark) * mask + sss_edge + light + (fresnel * .125) + (fresnel * .5 * (1 - depthf));
	//vec3 prefrag = sss_edge;
	gl_FragColor = vec4(prefrag, 1);
}

[[FS_DOF]]
// =================================================================================================
uniform sampler2D buf0;
uniform sampler2D buf1;
uniform sampler2D buf2;
varying vec2 texCoords;
void main(void) {
	vec4 render = texture2D(buf0, texCoords);
	vec4 blur = texture2D(buf1, texCoords);
	float f = texture2D(buf2, texCoords).a;
	f *= 2;
	//gl_FragColor = vec4(f, f, f, 1);
	gl_FragColor = mix(blur, render, max(min(f, 1), 0));
}

[[FS_SSS_MAKE]]
// =================================================================================================
uniform sampler2D buf0;
uniform sampler2D buf1;

varying vec2 texCoords;
void main(void) {
	gl_FragColor = vec4(0, 0, 0, 0);
	float back = max(min(1, texture2D(buf0, texCoords).r), 0);
	float front = texture2D(buf1, texCoords).r;
	float c = back - front;
	
	gl_FragColor = vec4(c, c, c, 0);
}














//