﻿//AUTHOR: Utermiko

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;

namespace ImportTest
{
    class Program
    {
        static void Main(string[] args)
        {
            int dll = LoadDll(ToNativeString(Environment.CurrentDirectory + "\\ManagedDllTest.dll"));
            ClearArguments();
            AddDoubleArgument(5);
            AddStringArgument(ToNativeString("hehęążóóą"));
            //int obj = CreateObject(dll, "ManagedDllTest.TestClass");
            int obj = Convert.ToInt32(CreateObjectAsCharPtr(Convert.ToString(dll), "ManagedDllTest.TestClass"));
            ClearArguments();
            InvokeDoubleMethod(obj, ToNativeString("MessageBoxNoParametr"));
            AddDoubleArgument(7);
            AddStringArgument(ToNativeString("heheszka"));
            string lol = InvokeStringMethod(obj, ToNativeString("Combine"));
            Console.WriteLine(lol);
            ClearArguments();
            int xd = 15;
            AddLPVOIDArgument(new IntPtr(xd));
            xd = InvokeLPVOIDMethod(obj, ToNativeString("AddToPtr")).ToInt32();
            Console.WriteLine(xd);
            ClearArguments();
            AddIntArgument(10);
            AddIntArgument(54);
            Console.WriteLine(InvokeIntMethod(obj, ToNativeString("Add")));
            ClearArguments();
            AddIntArgument(10);
            AddIntArgument(5);
            Console.WriteLine(InvokeIntMethodAsCharPtr(Convert.ToString(obj), "Add"));

            Console.ReadLine();
        }

        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int LoadDll(IntPtr path);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int CreateObject(int dllId, string path);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern string CreateObjectAsCharPtr(string aId, string path);

        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int AddStringArgument(IntPtr value);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int AddDoubleArgument(double value);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int AddIntArgument(int value);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int AddLPVOIDArgument(IntPtr value);

        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int ClearArguments();

        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern string InvokeStringMethod(int objId, IntPtr name);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern double InvokeDoubleMethod(int objId, IntPtr name);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int InvokeIntMethod(int objId, IntPtr name);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern string InvokeIntMethodAsCharPtr(string objId, string name);
        [DllImport("DotNetSlapCrossover.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern IntPtr InvokeLPVOIDMethod(int objId, IntPtr name);

        private static IntPtr ToNativeString(string value)
        {
            return Marshal.StringToHGlobalAnsi(value);
        }
        private static String ToManagedString(IntPtr pointer)
        {
            return Marshal.PtrToStringAnsi(pointer);
        }
    }
}
