//AUTHOR: Utermiko

#using <mscorlib.dll>
#include "stdafx.h"
#include <msclr\marshal.h>
#include "CrossoverManager.h"
#include <Windows.h>

#define EXPORT extern "C" __declspec(dllexport)
#define CALLING_CONVENTION __stdcall

using namespace System;
using namespace DotNetSlapCrossover;
using namespace System::Runtime::InteropServices;

EXPORT int CALLING_CONVENTION LoadDll(char* path)
{
	return CrossoverManager::LoadDll(gcnew String(path));
}
EXPORT int CALLING_CONVENTION CreateObject(int assemblyId, char* namespaceAndClass)
{
	return CrossoverManager::CreateObject(assemblyId,gcnew String(namespaceAndClass));
}
EXPORT int CALLING_CONVENTION RemoveObject(int objectId)
{
	return CrossoverManager::RemoveObject(objectId);
}

EXPORT int CALLING_CONVENTION ClearArguments()
{
	return CrossoverManager::ClearArguments();
}
EXPORT int CALLING_CONVENTION AddCharArgument(char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUCharArgument(unsigned char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddStringArgument(char* value)
{
	return CrossoverManager::AddArgument(gcnew String(value));
}
EXPORT int CALLING_CONVENTION AddDoubleArgument(double value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddFloatArgument(float value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddIntArgument(int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUIntArgument(unsigned int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddShortArgument(short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUShortArgument(unsigned short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddLongArgument(long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddULongArgument(unsigned long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddLPVOIDArgument(LPVOID value)
{
	return CrossoverManager::AddArgument(gcnew IntPtr(value));
}

EXPORT char* CALLING_CONVENTION InvokeStringMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi((String^)ret);else return "ERROR";
}
EXPORT char CALLING_CONVENTION InvokeCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (char)ret; else return -1;
}
EXPORT unsigned char CALLING_CONVENTION InvokeUCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned char)ret; else return 0;
}
EXPORT double CALLING_CONVENTION InvokeDoubleMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (double)ret; else return -1;
}
EXPORT float CALLING_CONVENTION InvokeFloatMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (float)ret; else return -1;
}
EXPORT int CALLING_CONVENTION InvokeIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (int)ret; else return -1;
}
EXPORT unsigned int CALLING_CONVENTION InvokeUIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned int)ret; else return 0;
}
EXPORT short CALLING_CONVENTION InvokeShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (short)ret; else return -1;
}
EXPORT unsigned short CALLING_CONVENTION InvokeUShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned short)ret; else return 0;
}
EXPORT long CALLING_CONVENTION InvokeLongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (long)ret; else return -1;
}
EXPORT unsigned long CALLING_CONVENTION InvokeULongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned long)ret; else return 0;
}
EXPORT LPVOID CALLING_CONVENTION InvokeLPVOIDMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return ((IntPtr^)ret)->ToPointer(); else return ((IntPtr^)IntPtr::Zero)->ToPointer();
}