//AUTHOR: Utermiko

#using <mscorlib.dll>
#include "stdafx.h"
#include <msclr\marshal.h>
#include "CrossoverManager.h"
#include <Windows.h>

#define EXPORT extern "C" __declspec(dllexport)

using namespace System;
using namespace DotNetSlapCrossover;
using namespace System::Runtime::InteropServices;

EXPORT int LoadDll(char* path)
{
	return CrossoverManager::LoadDll(gcnew String(path));
}
EXPORT int CreateObject(int assemblyId, char* namespaceAndClass)
{
	return CrossoverManager::CreateObject(assemblyId,gcnew String(namespaceAndClass));
}
EXPORT int RemoveObject(int objectId)
{
	return CrossoverManager::RemoveObject(objectId);
}

EXPORT int ClearArguments()
{
	return CrossoverManager::ClearArguments();
}
EXPORT int AddCharArgument(char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddUCharArgument(unsigned char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddStringArgument(char* value)
{
	return CrossoverManager::AddArgument(gcnew String(value));
}
EXPORT int AddDoubleArgument(double value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddFloatArgument(float value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddIntArgument(int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddUIntArgument(unsigned int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddShortArgument(short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddUShortArgument(unsigned short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddLongArgument(long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddULongArgument(unsigned long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int AddLPVOIDArgument(LPVOID value)
{
	return CrossoverManager::AddArgument(gcnew IntPtr(value));
}

EXPORT char* InvokeStringMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi((String^)ret);else return "ERROR";
}
EXPORT char InvokeCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (char)ret; else return -1;
}
EXPORT unsigned char InvokeUCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned char)ret; else return 0;
}
EXPORT double InvokeDoubleMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (double)ret; else return -1;
}
EXPORT float InvokeFloatMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (float)ret; else return -1;
}
EXPORT int InvokeIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (int)ret; else return -1;
}
EXPORT unsigned int InvokeUIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned int)ret; else return 0;
}
EXPORT short InvokeShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (short)ret; else return -1;
}
EXPORT unsigned short InvokeUShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned short)ret; else return 0;
}
EXPORT long InvokeLongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (long)ret; else return -1;
}
EXPORT unsigned long InvokeULongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned long)ret; else return 0;
}
EXPORT LPVOID InvokeLPVOIDMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return ((IntPtr^)ret)->ToPointer(); else return ((IntPtr^)IntPtr::Zero)->ToPointer();
}