//AUTHOR: Utermiko


#include "stdafx.h"
#include "CrossoverManager.h"

using namespace System;
using namespace System::Collections::Generic;
using namespace System::Reflection;

namespace DotNetSlapCrossover
{
	int CrossoverManager::LoadDll(String^ path)
	{
		++_assembliesCurrentId;
		try
		{
			_assemblies->Add(_assembliesCurrentId, Assembly::LoadFile(path));
		}
		catch (...) { return -1; }
		return _assembliesCurrentId;
	}
	int CrossoverManager::CreateObject(int assemblyId, String^ namespaceAndClass)
	{
		++_objectsCurrentId;
		try
		{
			_objectsCreated->Add(_objectsCurrentId, _assemblies[assemblyId]->CreateInstance(namespaceAndClass, false, BindingFlags::CreateInstance, nullptr, _arguments->ToArray(), nullptr, gcnew array<Object^>(0)));
		}
		catch (...) { return -1; }
		return _objectsCurrentId;
	}
	int CrossoverManager::RemoveObject(int objectId)
	{
		try
		{
			_objectsCreated->Remove(objectId);
		}
		catch(...){return -1;}
		return 1;
	}

	int CrossoverManager::AddArgument(Object^ value)
	{
		try
		{
			_arguments->Add(value);
		}
		catch (...) { return -1; }
		return 1;
	}

	int CrossoverManager::ClearArguments()
	{
		try
		{
			_arguments->Clear();
		}
		catch (...) { return -1; }
		return 1;
	}

	Object^ CrossoverManager::InvokeMethod(int objectId, String^ method)
	{
		try
		{
			return _objectsCreated[objectId]->GetType()->GetMethod(method)->Invoke(_objectsCreated[objectId], _arguments->ToArray());
		}
		catch (...) {return nullptr;}
	}
}