// NoiseHelper.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "Perlin.h"
#include <vector>

#include <cstring>
#include <sstream>

#define GM_EXPORT extern "C" __declspec ( dllexport )

#ifdef _MANAGED
#pragma managed(push, off)
#endif

// DEFINE
std::vector < Perlin * > * perlinVector;
std::vector < unsigned int * > * indexVector;
unsigned int * iCurrentIndex;

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

char * doubletostring( double input )
{
	std::ostringstream strs;
	strs << input;
	std::string str = strs.str();
	char * temp_string;
	temp_string = new char [str.size()+1];
	strcpy( temp_string, str.c_str() );

	return temp_string;
}

GM_EXPORT double Init( void )
{
	// CREATE
	perlinVector = new std::vector < Perlin * > ;		// LIST OF PERLINS
	indexVector = new std::vector < unsigned int * > ;	// LIST OF PERLIN INDEXES
	iCurrentIndex = new unsigned int;					// LAZY MAN's INDEX

	return TRUE;
}

GM_EXPORT double CleanUp( void )
{
	// Loop through the vectors and shiz
	for ( unsigned int i = 0; i < perlinVector->size(); i++ )
	{
		delete perlinVector->at(i);
		delete indexVector->at(i);
	}

	delete perlinVector;
	delete indexVector;
	return 1.00;
}

GM_EXPORT double CreatePerlin( double dOctaves, double dFreq, double dAmp, double dSeed )
{
	( *iCurrentIndex )++; // I'll fix the index searching code later. I just don't feel like it ATM.

	int octaves = ( int ) dOctaves;
	float freq = ( float ) dFreq;
	float amp = ( float ) dAmp;
	int seed = ( int ) dSeed;

	Perlin * nPerlin = new Perlin( octaves, freq, amp, seed );
	unsigned int * newIndex = new unsigned int;
	( *newIndex ) = ( *iCurrentIndex );

	perlinVector->push_back( nPerlin );
	indexVector->push_back( newIndex );

	return ( double ) ( *iCurrentIndex );
}

GM_EXPORT double GetPerlin( double dIndex, double dX, double dY )
{
	unsigned int index = ( unsigned int ) dIndex;
	float x = ( float ) dX;
	float y = ( float ) dY;

	// Loop through the vectors and shiz
	unsigned int i;
	bool found = false;
	for ( i = 0; i < perlinVector->size(); i++ )
	{
		// Look for the index
		if ( *( indexVector->at( i ) ) == index )
		{
			found = true;
			break;
		}
	}

	// If not found, then too bad
	if ( perlinVector->size() == 0 )
	{
		MessageBox( NULL, LPCSTR("No Perlin objects exist. You must create the object first!"), NULL, NULL );
		return -1337;
	}
	if ( ( found == false ) )
	{
		MessageBox( NULL, LPCSTR("Index not found. You fail at life."), NULL, NULL );
		return -1337;
	}

	// If found, return the value
	float returnValue;
	returnValue = perlinVector->at( i )->Get( x,y );

	//MessageBox( NULL, LPCSTR(doubletostring(( double )returnValue)), NULL, NULL );

	return ( double ) returnValue;
}

GM_EXPORT double DeletePerlin( double dIndex )
{
	unsigned int index = ( unsigned int ) dIndex;

	// Loop through the vectors and shiz
	unsigned int i;
	bool found = false;
	for ( i = 0; i < perlinVector->size(); i++ )
	{
		// Loof for the index
		if ( *( indexVector->at( i ) ) == index )
		{
			found = true;
			break;
		}
	}

	// If not found, then too bad
	if ( found == false )
	{
		return -1337;
	}

	// If found delete em.
	delete perlinVector->at( i );
	delete indexVector->at( i );

	perlinVector->erase( perlinVector->begin() + i );
	indexVector->erase( indexVector->begin() + i );

	return 1337;
}

GM_EXPORT double GetPerlin3D( double dIndex, double dX, double dY, double dZ )
{
	unsigned int index = ( unsigned int ) dIndex;
	float x = ( float ) dX;
	float y = ( float ) dY;
	float z = ( float ) dZ;

	// Loop through the vectors and shiz
	unsigned int i;
	bool found = false;
	for ( i = 0; i < perlinVector->size(); i++ )
	{
		// Look for the index
		if ( *( indexVector->at( i ) ) == index )
		{
			found = true;
			break;
		}
	}

	// If not found, then too bad
	if ( ( perlinVector->size() == 0 )||( found == false ) )
	{
		return -1337;
	}

	// If found, return the value
	float returnValue;
	returnValue = perlinVector->at( i )->Get3D( x,y,z );

	return ( double ) returnValue;
}


#ifdef _MANAGED
#pragma managed(pop)
#endif

