library msg;

uses
  SysUtils,
  Classes, windows, Messages;

function SendMessageByString(hwnd:hwnd;msg: cardinal;wParam: integer;lParam: string):integer;
stdcall;external 'user32.dll' name 'SendMessageA';

function SetText(WindowHandle: hwnd; str: string):double; cdecl;
begin
  SendMessageBystring(round(WindowHandle), WM_SETTEXT, 0, str);
end;

Function GetText(WindowHandle: hwnd):string;
var
  txtLength : integer;
  buffer: string;
begin
 TxtLength := SendMessage(WindowHandle, WM_GETTEXTLENGTH, 0, 0);
 txtlength := txtlength + 1;
 setlength (buffer, txtlength);
 sendmessage (WindowHandle,wm_gettext, txtlength, longint(@buffer[1]));
 result := buffer;
end;

function GetURL:pchar; cdecl;
var
  ie,toolbar,combo,
  comboboxex,edit,
  worker,toolbarwindow:hwnd;
begin
  ie := FindWindow(pchar('IEFrame'),nil);
  worker := FindWindowEx(ie,0,'WorkerW',nil);
  toolbar := FindWindowEx(worker,0,'rebarwindow32',nil);
  comboboxex := FindWindowEx(toolbar, 0, 'comboboxex32', nil);
  combo := FindWindowEx(comboboxex,0,'ComboBox',nil);
  edit := FindWindowEx(combo,0,'Edit',nil);
  toolbarwindow := FindWindowEx(comboboxex, 0, 'toolbarwindow32', nil);

  result := pchar(GetText(edit));
end;

function SetURL(str: pchar;ent: double):double; cdecl;
var
  ie,toolbar,combo,
  comboboxex,edit,
  worker,toolbarwindow:hwnd;
begin
  ie := FindWindow(pchar('IEFrame'),nil);
  worker := FindWindowEx(ie,0,'WorkerW',nil);
  toolbar := FindWindowEx(worker,0,'rebarwindow32',nil);
  comboboxex := FindWindowEx(toolbar, 0, 'comboboxex32', nil);
  combo := FindWindowEx(comboboxex,0,'ComboBox',nil);
  edit := FindWindowEx(combo,0,'Edit',nil);
  toolbarwindow := FindWindowEx(comboboxex, 0, 'toolbarwindow32', nil);

  SetText(edit,str);

  if round(ent) = 1 then
  SendMessage(edit, WM_CHAR, 13, 0);
  
  result := 0;
end;

exports GetURL, SetURL;

{
function SendMessageByString(hwnd:hwnd;msg: cardinal;wParam: integer;lParam: string):integer;
stdcall;external 'user32.dll' name 'SendMessageA';

function text(c:char;l:integer):string;
var i:integer;
begin
result:='';
for i:=1 to l do result:=result+c;
end;

function GetTextWin(hand: double):pchar; cdecl;
var
console:string;
clength:integer;
begin
  clength := sendmessage(round(hand),WM_GETTEXTLENGTH, 0, 0);
  console := text(' ',clength+1);
  SendMessageBystring(round(hand), WM_GETTEXT, clength + 1, console);
  result := pchar(console);
end;

function SetTextWin(hand: double; str: pchar):double; cdecl;
begin
  SendMessageBystring(round(hand), WM_SETTEXT, 0, string(str));
end;

exports GetTextWin, SetTextWin;   }

begin
end.
 