/* by Pieter (knobiks@gmail.com) */

#include "main.h"

void testujemy(std::string arg[MAX_ARGUMENTS],int count)
{
    if (count > 0)
        printf("count: %d - last arg: %s\n", count, arg[count-1].c_str());
}

/***************** funkcje aplikacji *****************/
void CloseApplication(std::string arg[MAX_ARGUMENTS],int count)
{
    working = 0; // kończy główny thread (main) i kończy działanie aplikacji.
}

/* funkcja do KONSOLi zwracajaca pomoc */
void ShowHelp(std::string arg[MAX_ARGUMENTS], int count)
{
    int index, i;
    std::string desc;

    if (count > 0)
    {
        index = Konsola.FindCommand(arg[0]);
        if (index > -1)
        {
            desc = Konsola.Commands[index].desc + "\n";
            printf("-    %s%s-%s", arg[0].c_str(), Konsola.FillSpace(arg[0].length(), 15).c_str(), desc.c_str());
        }
        else
            printf("Help about \"%s\" not found.\n", arg[0].c_str());
    }
    else
    {
        for ( i = 0 ; i < Konsola.Count ; i++ )
        {
            desc = Konsola.Commands[i].desc + "\n";
            printf("-    %s%s-%s", Konsola.Commands[i].cmd.c_str(), Konsola.FillSpace(Konsola.Commands[i].cmd.length(), 15).c_str(), desc.c_str());
        }
    }

}

int main()
{
    std::string cmd, tmpcmd;
    ClientClass *Clients = new ClientClass;

    TCPThread *ParserTCP = new TCPThread;
    ParserTCP->Clients = Clients;

    signal(SIGPIPE, SIG_IGN);

    Konsola.AddCommand(&ShowHelp, "help", "Tu znajdziesz wszystkie informacje jakie potrzebujesz.");
    Konsola.AddCommand(&CloseApplication, "quit", "kończy działanie aplikacji.");
    Konsola.AddCommand(&testujemy, "test", "Testowa funkcja konsoli, wpisz a sie dowiesz jak dziala.");

    ParserTCP->StartServer();

    while (working)
    {
        std::getline( std::cin, cmd, '\n' ); // pobieranie komendy z std::cin do cmd do nowej linijki (\n)

        tmpcmd = Konsola.TrimArg(cmd); // sprawdz czy string nie jest pusty lub zawiera same spacje
        if (tmpcmd != "")
        {
            Konsola.ProcessAndExecute(cmd);
        }
    }

    delete Clients;
    delete ParserTCP;

    return 0;
}
