
#include "stdafx.h"
#include <stdio.h>
#include <imagehlp.h>
#include <Winsock2.h>
#include <malloc.h>
#include <stdlib.h>



#ifdef _MANAGED
#pragma managed(push, off)
#endif

//structure to save the data necessary for the hooking and unhooking
typedef struct _hookinfo
{
	PCSTR pszDll;				//DLL containing the hooked function
	PCSTR pszFuncName;			//name of the hooked function
	PROC  pfnHookFunc;			//pointer to the function that should be called instead of the original function
	PROC  pfnOriginalFunc;		//pointer to the original function
	PROC* ppfnIATAddress;		//address of the function in the IAT
	BOOL  bHooked;				//hooked? (yes/no)
} HookInfo;

VOID Hook( HookInfo *pHookInfo );					//function to set a hook
VOID UnHook( HookInfo *pHookInfo );					//function to remove a hook
void __declspec(noreturn) UninjectSelf(HMODULE);	//function to unload this DLL
LRESULT APIENTRY HookProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam); //Window-Hook function

HMODULE hHookDllHandle;				//handle to THIS dll

HWND hWnd;							//the Tibia client
WNDPROC wndProc;					//the original window function

//Prototypes of the hooked functions
//to study how the "proxy" works, just look into the implementation of
//Myrecv and Mysend.
int WSAAPI Myrecv( IN SOCKET s, OUT char FAR * buf, IN int len, IN int flags );
int WSAAPI Mysend( IN SOCKET s, IN const char FAR * buf, IN int len, IN int flags);
typedef int (WSAAPI *fpnOriginalTypeRecv)( IN SOCKET s, OUT char FAR * buf, IN int len, IN int flags );
typedef int (WSAAPI *fpnOriginalTypeSend)( IN SOCKET s, IN const char FAR * buf, IN int len, IN int flags);
HookInfo g_HookSend;
HookInfo g_HookRecv;
BOOL b;

//now the Tibia-specific stuff starts. Actually, we need only the XTEA-routines.
//the following 3 functions work like the CrackD.DLL from blackdtools.
//I dont know if these are the exact implementations, but if you out these
//3 functions into a DLL and export them, you can replace the original CrackD.DLL
//and the proxy still works
void tean(long *v, long *k, long N);
long EncipherTibia(void* p1, void* p2 );
long DecipherTibia(void* p1, void* p2 );



BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		{
			FILE *f = fopen("llLog.txt", "a+");fprintf(f, "DLL attached.\n");fclose(f);
			hHookDllHandle = hModule;
			b=FALSE;			
			hWnd = FindWindow(L"TibiaClient", 0);						
			wndProc = (WNDPROC)SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG)HookProc);
			
			g_HookSend.bHooked=FALSE;
			g_HookSend.pfnHookFunc=(PROC)Mysend;
			g_HookSend.pfnOriginalFunc=NULL;
			g_HookSend.ppfnIATAddress=NULL;
			g_HookSend.pszDll="WS2_32.DLL";
			g_HookSend.pszFuncName="send";
			Hook(&g_HookSend);
			if( !g_HookSend.bHooked )
			{
				FILE *f = fopen("llLog.txt", "a+");fprintf(f, "Hooking SEND failed\n");fclose(f);
			}

			g_HookRecv.bHooked=FALSE;
			g_HookRecv.pfnHookFunc=(PROC)Myrecv;
			g_HookRecv.pfnOriginalFunc=NULL;
			g_HookRecv.ppfnIATAddress=NULL;
			g_HookRecv.pszDll="WS2_32.DLL";
			g_HookRecv.pszFuncName="recv";
			Hook(&g_HookRecv);
			if( !g_HookRecv.bHooked )
			{
				FILE *f = fopen("llLog.txt", "a+");fprintf(f, "Hooking RECV failed\n");fclose(f);			
			}
			break;
		}
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH:
		{
			FILE *f = fopen("llLog.txt", "a+");fprintf(f, "DLL detached.\n");fclose(f);
		}
		break;
	}
    return TRUE;

}

////////////////////////THE INTERESSTING STUFF: THE SEND AND/////////////////
////////////////////////THE RECEIVE FUNCTION/////////////////////////////////

//decrypts the incoming and outgoing packages
unsigned char* getDecryptedCopy(const char * buf, int len)
{
	BYTE xGameKey[16];
	memcpy(xGameKey, (void*)0x75A8AC, 16);
	unsigned char *data = (unsigned char*)malloc(sizeof(char)*(len+1));
	memcpy(data, buf, len);
	data[len]=0;
	int iPos = 0;
	while( iPos < len-1 )
	{		
		DecipherTibia(data+iPos, xGameKey);
		int iLength = data[iPos] + data[iPos]*256;
		iPos += iLength+2;
	}	
	return data;
}


int WSAAPI Myrecv( IN SOCKET s, OUT char FAR * buf, IN int len, IN int flags )
{
	//Step 1: get the data packets from the real server
	int iRet = ((fpnOriginalTypeRecv)g_HookRecv.pfnOriginalFunc)(s, buf, len,flags );
	
	FILE *f = fopen("llLog.txt", "a+");
	fprintf(f, "Myrecv: %d bytes\n", iRet);
	fclose(f);

	//Step 2: do something with the received data
	//here, we only decrypt the packages and write them into the file "recv.bin"
	if( iRet > 0 )
	{
		f=fopen("recv.bin", "a+b");
		unsigned char* xData = getDecryptedCopy(buf, iRet );
		fprintf(f, "%s", "RECV:");
		for( int i=0; i < iRet; i++ ) fprintf(f, "%c", xData[i] );
		fclose(f);
		free( xData );
	}
	
	//Step 3: route the (probably changed) data to the real Tibia client
	//If you changed the length of the data in step 2, you also have
	//to alter the value of iRet (the number of actual received bytes)
	//accordingly
	return iRet;
}

int WSAAPI Mysend( IN SOCKET s, IN const char FAR * buf, IN int len, IN int flags)
{
	//Step 1: the buffer buf contains the data that the client wants to send
	//to the server. 
	if( len > 0 )
	{
		FILE *f = fopen("llLog.txt", "a+");
		fprintf(f, "Mysend: %d bytes\n", len);
		fclose(f);
		f=fopen("send.bin", "a+b");
		unsigned char* xData = getDecryptedCopy(buf, len );
		fprintf(f, "%s", "SEND:");
		for( int i=0; i < len; i++ ) fprintf(f, "%c", xData[i] );
		fclose(f);
		free( xData );
	}

	//Step 2: send the (probably changed) data to the server
	int iRet = ((fpnOriginalTypeSend)g_HookSend.pfnOriginalFunc)(s, buf, len,flags );
	return iRet;

}



////////////////////////////IMPLEMENTATION OF REST////////////////////////////////
////////////////////////////these functions are necessary to run,/////////////////
////////////////////////////but not part of the actual proxy functionality////////

void tean(long *v, long *k, long N)      /* replaces TEA's code and decode */
{
	unsigned long y = v[0],
                  z = v[1],
                  DELTA = 0x9e3779b9,
                  limit,
                  sum;

    if (N > 0)				/* coding */
    {   limit = DELTA * N;
        sum = 0;

        while (sum != limit)
        {   y   += (z << 4 ^ z >> 5) + z ^ sum + k[sum & 3];
            sum += DELTA;
            z   += (y << 4 ^ y >> 5) + y ^ sum + k[sum >> 11 & 3];
        }
	}
    else				/* decoding */
    {    sum = DELTA * (-N);

         while (sum)
         {   z   -= (y << 4 ^ y >> 5) + y ^ sum + k[sum >> 11 & 3];
             sum -= DELTA;
             y   -= (z << 4 ^ z >> 5) + z ^ sum + k[sum & 3];
         }
    }

    v[0] = y;
    v[1] = z;
    return;
}
long EncipherTibia(void* p1, void* p2 )
{
	char* data = (char*)p1;
	char* key = (char*)p2;
	unsigned char i1 = *(char*)p1;
	unsigned char i2 = *(((char*)p1)+1);
	unsigned int iCount = i1+i2*256;
	data += 2;
	for( unsigned int i=0; i < iCount/8; i++ )
	{
		tean( (long*)data, (long*)key, 32 );
		data += 8;
	}
	return iCount;
}

long DecipherTibia(void* p1, void* p2 )
{
	char* data = (char*)p1;
	char* key = (char*)p2;
	unsigned char i1 = *(char*)p1;
	unsigned char i2 = *(((char*)p1)+1);
	unsigned int iCount = i1+i2*256;
	data += 2;
	for( unsigned int i=0; i < iCount/8; i++ )
	{
		tean( (long*)data, (long*)key, -32 );
		data +=8;
	}
	return iCount;
}

void __declspec(noreturn) UninjectSelf(HMODULE Module)
{
	FILE *f = fopen("llLog.txt", "a+");fprintf(f, "UninjectSelf\n");fclose(f);
	Sleep(1000);
   __asm
   {
      push -2
      push 0
      push Module
      mov eax, TerminateThread
      push eax
      mov eax, FreeLibrary
      jmp eax
   }
}

VOID ChangeSystemMenuAdd()
{
	HMENU sys = GetSystemMenu(hWnd, FALSE);
	AppendMenu(sys, MF_STRING, 0x203, L"Unhook");
}

VOID ChangeSystemMenuRemove()
{	
	HMENU sys = GetSystemMenu(hWnd, FALSE);
	RemoveMenu(sys, 0x203, MF_BYCOMMAND);
}


LRESULT APIENTRY HookProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if( !b ) 
	{
		ChangeSystemMenuAdd(); 
		b = TRUE;
	}
	if( uMsg == WM_SYSCOMMAND && wParam == 0x203)
	{
		ChangeSystemMenuRemove();
		UnHook(&g_HookSend);
		UnHook(&g_HookRecv);
		SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG)wndProc);
		::CreateThread(NULL,NULL,(LPTHREAD_START_ROUTINE)UninjectSelf,hHookDllHandle,NULL,NULL);
	}

   return CallWindowProc(wndProc, hWnd, uMsg, wParam, lParam ); 
} 


//The code of the following two functions is mainly taken from the article
//"API Hooking Revealed" by Ivo Ivanov,
//http://www.codeguru.com/cpp/w-p/system/misc/article.php/c5667__1
VOID UnHook( HookInfo *pHookInfo )
{
	if( pHookInfo->bHooked == FALSE ) return;
	MEMORY_BASIC_INFORMATION mbi;
	::VirtualQuery(pHookInfo->ppfnIATAddress, &mbi, sizeof(MEMORY_BASIC_INFORMATION));
	if (FALSE == ::VirtualProtect(
		mbi.BaseAddress,
		mbi.RegionSize,
		PAGE_READWRITE,
		&mbi.Protect)
		)
		return;
	*(pHookInfo->ppfnIATAddress) = *(pHookInfo->pfnOriginalFunc);
	DWORD dwOldProtect;
	::VirtualProtect(
		mbi.BaseAddress,
		mbi.RegionSize,
		mbi.Protect,
		&dwOldProtect
		);
	pHookInfo->bHooked = FALSE;
	FILE *f = fopen("llLog.txt", "a+");fprintf(f, "%s,%s unhooked.\n",pHookInfo->pszDll,pHookInfo->pszFuncName);fclose(f);
}


VOID Hook( HookInfo *pHookInfo )
{
	if( pHookInfo->bHooked == TRUE ) return;
	pHookInfo->bHooked = FALSE;
	PROC pfnOrig = NULL;	
	HMODULE hmod = NULL;
	hmod = ::LoadLibraryA(pHookInfo->pszDll);
	pfnOrig = GetProcAddress(::GetModuleHandleA(pHookInfo->pszDll),pHookInfo->pszFuncName);
	pHookInfo->pfnOriginalFunc = pfnOrig;
	if( NULL == pfnOrig) return;

	HMODULE hmodCaller = GetModuleHandleA(NULL);
	

	ULONG ulSize;
	// Get the address of the module's import section
	PIMAGE_IMPORT_DESCRIPTOR pImportDesc = 
		(PIMAGE_IMPORT_DESCRIPTOR)ImageDirectoryEntryToData(
		hmodCaller, //das hier muss nicht stimmen!!!
		TRUE, 
		IMAGE_DIRECTORY_ENTRY_IMPORT, 
		&ulSize
		);
	// Does this module has import section ?
	if (pImportDesc == NULL) return;

	// Loop through all descriptors and
	// find the import descriptor containing references to callee's functions
	while (pImportDesc->Name)
	{
		PSTR pszModName = (PSTR)((PBYTE) hmodCaller + pImportDesc->Name);
		if (stricmp(pszModName, pHookInfo->pszDll) == 0) 
			break;   // Found
		pImportDesc++;
	} // while
	if (pImportDesc->Name == 0) return;

	// Get caller's IAT 
	PIMAGE_THUNK_DATA pThunk = 
		(PIMAGE_THUNK_DATA)( (PBYTE) hmodCaller + pImportDesc->FirstThunk );

	PROC pfnCurrent = pfnOrig;	
	// Replace current function address with new one
	while (pThunk->u1.Function)
	{
		// Get the address of the function address
		PROC* ppfn = (PROC*) &pThunk->u1.Function;
		// Is this the function we're looking for?
		BOOL bFound = (*ppfn == pfnCurrent);
		if (bFound) 
		{
			pHookInfo->ppfnIATAddress = ppfn;
			MEMORY_BASIC_INFORMATION mbi;
			::VirtualQuery(ppfn, &mbi, sizeof(MEMORY_BASIC_INFORMATION));
			// In order to provide writable access to this part of the 
			// memory we need to change the memory protection
			if (FALSE == ::VirtualProtect(
				mbi.BaseAddress,
				mbi.RegionSize,
				PAGE_READWRITE,
				&mbi.Protect)
				)
				return;
			// Hook the function.
			*ppfn = *(pHookInfo->pfnHookFunc);
			// Restore the protection back
            DWORD dwOldProtect;
			::VirtualProtect(
				mbi.BaseAddress,
				mbi.RegionSize,
				mbi.Protect,
				&dwOldProtect
				);
			FILE *f = fopen("llLog.txt", "a+");fprintf(f, "HOOK %s,%s ok.\n",pHookInfo->pszDll,pHookInfo->pszFuncName);fclose(f);
			break;
		} // if
		pThunk++;
	} // while
	pHookInfo->bHooked = TRUE;
	return;
}




#ifdef _MANAGED
#pragma managed(pop)
#endif

