#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "CCalc.h"

float node_getValue_value(math_node* nodeptr)
{
	return nodeptr->value;
}

float node_getValue_add(math_node* nodeptr)
{
	return nodeptr->leftNode->getValue(nodeptr->leftNode) + nodeptr->rightNode->getValue(nodeptr->rightNode);
}

float node_getValue_sub(math_node* nodeptr)
{
	return nodeptr->leftNode->getValue(nodeptr->leftNode) - nodeptr->rightNode->getValue(nodeptr->rightNode);
}

float node_getValue_mul(math_node* nodeptr)
{
	return nodeptr->leftNode->getValue(nodeptr->leftNode) * nodeptr->rightNode->getValue(nodeptr->rightNode);
}

float node_getValue_div(math_node* nodeptr)
{
	return nodeptr->leftNode->getValue(nodeptr->leftNode) / nodeptr->rightNode->getValue(nodeptr->rightNode);
}

operator_desc* get_number_op(void)
{
	size_t i;
	for(i = 0; i < sizeof(operatorsTable) / sizeof(operator_desc); i++)
	{
		if(!operatorsTable[i].pattern)
		{
			return operatorsTable + i;
		}
	}
	
	return 0;
}

operator_desc* get_op_with_prior(size_t prior, size_t* /* out */ count)
{
	operator_desc* result = malloc(sizeof(operatorsTable));
	*count = 0;

	size_t i;
	for(i = 0; i < sizeof(operatorsTable) / sizeof(operator_desc); i++)
	{
		if(operatorsTable[i].priority == prior)
		{
			result[*count] = operatorsTable[i];
			(*count)++;
		}
	}

	if(*count == 0)
	{
		free(result);
		return 0;
	}
	return result;
}

size_t get_highest_prior(void)
{
	size_t prior = 0;
	
	size_t i;
	for(i = 0; i < sizeof(operatorsTable) / sizeof(operator_desc); i++)
	{
		if(operatorsTable[i].priority > prior)
		{
			prior = operatorsTable[i].priority;
		}
	}

	return prior;
}

size_t get_next_op_pos(char* string, operator_desc** op_type)
{
	*op_type = 0;
	
	size_t lenght = strlen(string);
	
	size_t prior;
	for(prior = get_highest_prior(); prior > 0; prior--)
	{
		size_t count;
		operator_desc* operators = get_op_with_prior(prior, &count);
		if(!operators)
			continue;
			
		operator_desc* firstOp = 0;
		size_t first = 0xFFFFFFFF;
		
		size_t i;
		for(i = 0; i < count; i++)
		{
			size_t opLenght = strlen(operators[i].pattern);
			
			size_t current;
			for(current = 0; current + opLenght < lenght; current++)
			{
				/* jeeli operatory pokrywaj si wybieramy ten duszy */
				if(current == first && firstOp && opLenght > strlen(firstOp->pattern)) 
				{
					firstOp = operators + i;
					first = current;
					break;
				}
				
				if(strncmp(string + current, operators[i].pattern, opLenght) == 0) /* znalelimy operator */
				{
					firstOp = operators + i;
					first = current;
					break;
				}
			}
		}
		
		if(firstOp)
		{
			*op_type = firstOp;
			return first;
		}
	}
	
	*op_type = get_number_op();
	return 0;
}

parser_node* parse(char* string)
{
	parser_node* result = malloc(sizeof(parser_node));
	memset(result, 0, sizeof(parser_node));
	
	size_t lenght = strlen(string);
	operator_desc* op;
	size_t position = get_next_op_pos(string, &op);
	
	if(op == get_number_op())
	{
		result->middle = string;
	}
	else
	{
		result->middle = op->pattern;
		
		char* left = malloc(position + 1);
		memcpy(left, string, position);
		left[position] = 0;
		
		char* right = malloc(lenght - position + 1);
		memcpy(right, string + position + strlen(op->pattern), lenght - position + 1);
		
		result->left = parse(left);
		result->right = parse(right);
	}
	
	return result;
}

math_node* create_math_node(parser_node* parserResult)
{
	if(!parserResult)
		return 0;
	math_node* result = malloc(sizeof(math_node));
	memset(result, 0, sizeof(math_node));

	size_t i;
	for(i = 0; i < sizeof(operatorsTable) / sizeof(operator_desc); i++)
	{
		if(operatorsTable[i].pattern == 0) /* omijamy jeeli to 0 */
			continue;
		/* czy znalelimy nasz znak? */
		if(strcmp(operatorsTable[i].pattern, parserResult->middle) == 0)
		{
			result->getValue = operatorsTable[i].nodeFunc;
			/* tworzymy rekurencyjnie lew i praw stron :) */
			result->leftNode = create_math_node(parserResult->left);   
			result->rightNode = create_math_node(parserResult->right);
			
			return result;
		}
	}	

	/* nie jest znakiem to musi by liczb */
	result->value = atof(parserResult->middle);
	result->getValue = &node_getValue_value;

	return result;
}

int main(int argc, char* argv[])
{
	/* czymy argumenty w cao */
	size_t size = 1;
	int i;
	for(i = 1; i < argc; i++)
	{
		size += strlen(argv[i]);
	}
	char* cmdLine = malloc(size);

	char* offset = cmdLine;
	for(i = 1; i < argc; i++)
	{
		strcpy(offset, argv[i]);
		offset += strlen(argv[i]);
	}

	parser_node* parserResult = parse(cmdLine);
	math_node* mathResult = create_math_node(parserResult);

	if(!mathResult) /* bd */
	{
		printf("%s\n", "Error!");
	}
	else
	{
		printf("%s = %f\n", cmdLine, mathResult->getValue(mathResult));
	}

	return 0;
}
