#ifndef _CCALC_H_
#define _CCALC_H_

typedef struct math_node math_node;

typedef float(*node_getValue)(math_node*);

struct math_node
{
	math_node* leftNode;
	math_node* rightNode;
	node_getValue getValue; /* taka niby "wirtualna" funkcja :) */
	
	float value;
};

float node_getValue_value(math_node*);
float node_getValue_add(math_node*);
float node_getValue_sub(math_node*);
float node_getValue_mul(math_node*);
float node_getValue_div(math_node*);

typedef struct operator_desc operator_desc;

struct operator_desc
{
	node_getValue nodeFunc;
	size_t priority;
	char* pattern;
};

operator_desc operatorsTable[] = 
{
	{&node_getValue_value, 0, 0}, /* 0 oznacza e nie jest znakiem, a liczb */
	{&node_getValue_div, 1, "/"},
	{&node_getValue_mul, 1, "*"},
	{&node_getValue_sub, 2, "-"},
	{&node_getValue_add, 2, "+"},
};

typedef struct parser_node parser_node;

struct parser_node
{
	parser_node* left;
	parser_node* right;
	
	char* middle;
};

parser_node* parse(char*);

math_node* create_math_node(parser_node*);

#endif
