package pl.shockah.ts.gameplay;

import pl.shockah.glib.geom.vector.Vector2i;

public class TestLevel {
	public static final TestLevel
		level1 = new TestLevel(
				new Vector2i(40,30),
				ETheme.Jungle,
				
				"########################################"+
				"#       #                              #"+
				"#       #                              #"+
				"#   #   #   #?#FFFFFFFFFFFFFFFFFFFFFFF##"+
				"#   #   #                              #"+
				"#   #   #                              #"+
				"#   #   #   #?#GGGGGGGGGGGGGGGGGGGGGGGG#"+
				"#   #   #                              #"+
				"#   #   #                              #"+
				"#   #   #      XXXXXXXXXXXXXXXXXXXXXXX #"+
				"#   #   #   #?######################## #"+
				"#   #   #                              #"+
				"#   #                                  #"+
				"#   #                P  P  P  P  P  P  #"+
				"#   ##?###############################X#"+
				"#   #                                #X#"+
				"#   #                                #X#"+
				"#              ###                   #X#"+
				"#              ###                   #X#"+
				"#              ###     ###           #X#"+
				"#  G           ###     ###           #X#"+
				"#     ##       ###     ###           ###"+
				"#     ##       ###     ###     ###     #"+
				"#     ##       ###     ###     ###     #"+
				"#  P  ##       ###     ###     ###    @#"+
				"###?######   #######?#######?#######?###"+
				"#   #              #   #                "+
				"# 1 #              # 2 #                "+
				"#   #              #   #                "+
				"###########?############                ",
				
				"########################################"+
				"#       #                              #"+
				"#       #                              #"+
				"#   #   #   ###------------------------#"+
				"#   #   #                              #"+
				"#   #   #                              #"+
				"#   #   #   ###------------------------#"+
				"#   #   #                              #"+
				"#   #   #                              #"+
				"#   #   #      ----------------------- #"+
				"#   #   #   ########################## #"+
				"#   #   #                              #"+
				"#   #                                  #"+
				"#   #                -  -  -  -  -  -  #"+
				"#   ##################################-#"+
				"#   #                                #-#"+
				"#   #                                #-#"+
				"#              ###                   #-#"+
				"#              ###                   #-#"+
				"#              ###     ###           #-#"+
				"#              ###     ###           #-#"+
				"#WWWWW##       ###     ###           ###"+
				"#WWWWW##       ###     ###     ###     #"+
				"#WWWWW##       ###     ###     ###     #"+
				"#WWWWW##       ###     ###     ###     #"+
				"##########   ###########################"+
				"#   #              #   #                "+
				"# - #              # - #                "+
				"#   #WWWWWWWWWWWWWW#   #                "+
				"########################                ",
				
				new String[]{
						"Fading blocks test",
						"Falling blocks test",
						"Spikes test",
						"Pushable blocks test",
						"Wall-jump test",
						"Skid jump test",
						"Double jump test",
						"Jump test",
						"Diamonds. Supposed to be in places that are hard to get to."
				}
		),
		
		level2 = new TestLevel(
				new Vector2i(14,60),
				ETheme.Jungle,
				
				"##############"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#   ##########"+
				"#   ##########"+
				"#   ##########"+
				"#   ##########"+
				"#   ##########"+
				"#   ##########"+
				"#   ##########"+
				"#   #        #"+
				"#   #        #"+
				"#            #"+
				"#            #"+
				"#######   ####"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#      #######"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#   ###      #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"#            #"+
				"####         #"+
				"#            #"+
				"#            #"+
				"#   ###      #"+
				"#            #"+
				"#            #"+
				"#      ###   #"+
				"#            #"+
				"#            #"+
				"#         ####"+
				"#            #"+
				"#            #"+
				"#    ####    #"+
				"#            #"+
				"#            #"+
				"####      ####"+
				"#            #"+
				"#            #"+
				"#   ######   #"+
				"#            #"+
				"#            #"+
				"##########   #"+
				"#            #"+
				"#            #"+
				"#   ##########"+
				"#            #"+
				"#@           #"+
				"##############"
		),
		
		level3 = new TestLevel(
				new Vector2i(100,30),
				ETheme.Jungle,
				
				"####################################################################################################"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#  @       P       P                                                                               #"+
				"######   #####GGG#####                                                                             #"+
				"######   #####   #####                                                                             #"+
				"######                                                                                             #"+
				"######                   #######                                                                   #"+
				"######                   #     #                                                                   #"+
				"######                   # 1 2 #                                                                   #"+
				"######                   #     #                                                                   #"+
				"######                   # 2 1 #                                                                   #"+
				"####################################################################################################",
				
				"####################################################################################################"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#                                                                                                  #"+
				"#  @       P       P                                                                               #"+
				"######   #####GGG#####                                                                             #"+
				"######   #####   #####                                                                             #"+
				"######WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"######WWWWWWWWWWWWWWWWWWW       WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"######WWWWWWWWWWWWWWWWWWW WWWWW WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"######WWWWWWWWWWWWWWWWWWW WWWWW WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"######WWWWWWWWWWWWWWWWWWW WWWWW WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"######WWWWWWWWWWWWWWWWWWW WWWWW WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW#"+
				"####################################################################################################"
		),
		
		level4 = new TestLevel(
				new Vector2i(40,20),
				ETheme.Plane,
				
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				"                                        "+
				" @                                      "+
				"########################################"+
				"########################################"+
				"########################################"+
				"                                        "+
				"                                        "
		);
	
	public final Vector2i tileSize;
	public final ETheme theme;
	public final String level, water;
	public final String[] hints;
	
	public TestLevel(Vector2i tileSize, ETheme theme, String level) {
		this(tileSize,theme,level,(String)null);
	}
	public TestLevel(Vector2i tileSize, ETheme theme, String level, String[] hints) {
		this(tileSize,theme,level,null,hints);
	}
	public TestLevel(Vector2i tileSize, ETheme theme, String level, String water) {
		this(tileSize,theme,level,water,null);
	}
	public TestLevel(Vector2i tileSize, ETheme theme, String level, String water, String[] hints) {
		this.tileSize = tileSize;
		this.theme = theme;
		this.level = level;
		this.water = water;
		this.hints = hints == null ? new String[0] : hints;
	}
}