package pl.shockah.ts.states;

import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.color.Colorb;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.View;
import pl.shockah.glib.state.transitions.TransitionThroughColor;
import pl.shockah.ts.Assets;
import pl.shockah.ts.menu.MenuElButton;
import pl.shockah.ts.menu.MenuElChoose;
import pl.shockah.ts.menu.MenuSet;

public class StateMenuOptions extends State {
	public StateMenuOptions() {
		views.add(new View(new Vector2i(960,720)));
	}
	
	protected void onCreate() {
		new EntityRenderable(){
			protected void onRender(Graphics g) {
				Vector2i size = getDisplaySize();
				
				Color c1 = new Colorb(0,138,255), c2 = new Colorb(255,167,68);
				new Rectangle(size).drawMulticolor(g,true,c1,c1,c2,c2);
				g.setColor(Color.White);
				g.draw(Assets.sLogo,size.x/2,size.y/6);
			}
		}.create();
		
		Vector2i size = State.get().getDisplaySize();
		new MenuSet().addElements(
				new MenuElChoose<>(new MenuElChoose.ToString<Boolean>(){
					public String toString(Boolean b) {
						return b ? "Fullscreen" : "Windowed";
					}
				}).setText("Mode").addOptions(false,true),
				
				fillResolutions(new MenuElChoose<>(new MenuElChoose.ToString<DisplayMode>(){
					public String toString(DisplayMode dm) {
						return ""+dm.getWidth()+"x"+dm.getHeight()+", "+dm.getFrequency()+" Hz";
					}
				}).setText("Resolution")),
				
				new MenuElButton().setText("Back").setAction(new Runnable(){
					public void run() {
						State.change(new StateMenuMain(),new TransitionThroughColor(.025f,true),new TransitionThroughColor(.025f,true));
					}
				})
		).setSize(360,40).setSeparator(16).setFont(Assets.font24).create(new Vector2d(size.x/2,size.y/2));
	}
	
	protected MenuElChoose<DisplayMode> fillResolutions(MenuElChoose<DisplayMode> melc) {
		try {
			for (DisplayMode avdm : Display.getAvailableDisplayModes()) {
				if (avdm.getWidth() >= 800 && avdm.getHeight() >= 600 && avdm.getBitsPerPixel() == 32 && avdm.getFrequency() >= 60) melc.addOptions(avdm);
			}
		} catch (Exception e) {e.printStackTrace();}
		return melc;
	}
}