package pl.shockah.ts.entities.effects;

import pl.shockah.glib.geom.Ellipse;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.EntityRenderable;

public class EffectJumpRipple extends EntityRenderable {
	protected final EOrientation orientation;
	protected Vector2d scale;
	protected float alpha = 1f;
	
	public EffectJumpRipple(EOrientation orientation) {
		baseDepth = -5;
		this.orientation = orientation;
	}
	
	protected void onCreate() {
		scale = orientation.getScale();
	}
	
	protected void onUpdate() {
		scale.add(orientation.getScale().scale(1d/12d));
		alpha -= .1f;
		if (alpha <= 0) destroy();
	}
	
	protected void onRender(Graphics g) {
		g.setColor(Color.White.alpha(alpha));
		g.draw(new Ellipse(pos,scale));
	}
	
	public static enum EOrientation {
		Horizontal(new Vector2d(6,3)), Vertical(new Vector2d(3,6));
		
		private final Vector2d scale;
		
		private EOrientation(Vector2d scale) {
			this.scale = scale;
		}
		
		public Vector2d getScale() {
			return new Vector2d(scale);
		}
	}
}