package pl.shockah.ts;

import pl.shockah.glib.AssetLoader;
import pl.shockah.glib.gl.Shader;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.gl.font.TrueTypeFont;
import pl.shockah.glib.gl.tex.Atlas;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.gl.tex.SVGTextureLoader;
import pl.shockah.glib.gl.tex.SpriteSheet;

public class Assets {
	@SpriteSheet.Loadable(path="png/loadingBar.png",framesY=2) public static SpriteSheet ssLoadingBar;
	@Image.Loadable(path="png/logo.png")@SVGTextureLoader.Options(height=72) public static Image sLogo;
	
	@TrueTypeFont.Loadable(name="Calibri",size=16) public static Font font16;
	@TrueTypeFont.Loadable(name="Calibri",size=24) public static Font font24;
	
	@Atlas.Loadable(path="png/frameText.png") public static Atlas aFrameText;
	
	@Image.Loadable(path="png/playerBase.png") public static Image sPlayerBase;
	@Image.Loadable(path="png/playerEye.png") public static Image sPlayerEye;
	@SpriteSheet.Loadable(path="png/spikes.png",framesX=4,framesY=4) public static SpriteSheet ssSpikes;
	
	@SpriteSheet.Loadable(path="png/boxes.png",framesX=3) public static SpriteSheet ssBoxes;
	@SpriteSheet.Loadable(path="png/diamond.png",framesX=2) public static SpriteSheet ssDiamond;
	
	@SpriteSheet.Loadable(path="png/tileBorder.png",framesX=4,framesY=5) public static SpriteSheet ssTileBorder;
	@SpriteSheet.Loadable(path="png/tileBorderThin.png",framesX=4,framesY=5) public static SpriteSheet ssTileBorderThin;
	@SpriteSheet.Loadable(path="png/tileBorderMetal.png",framesX=4,framesY=5) public static SpriteSheet ssTileBorderMetal;
	
	@Image.Loadable(path="png/tileDirt.png") public static Image sTileDirt;
	@SpriteSheet.Loadable(path="png/tileGrass.png",framesX=4) public static SpriteSheet ssTileGrass;
	@Image.Loadable(path="png/tileMetal.png") public static Image sTileMetal;
	
	@Image.Loadable(path="png/ptFuzzy.png") public static Image ptFuzzy;
	@Image.Loadable(path="png/ptFuzzyRing.png") public static Image ptFuzzyRing;
	
	@Image.Loadable(path="png/overlayTime.png") public static Image sOverlayTime;
	
	@Shader.Loadable(path="shaders/timeeffect",mixTexturing=true) public static Shader sdrTimeEffect;
	
	public static AssetLoader createAssetLoader() {
		return new AssetLoader();
	}
	public static void setupAssets() {
		sLogo.center();
		ptFuzzy.center();
		
		for (int i = 0; i < ssSpikes.getCount(); i++) ssSpikes.getImage(i).rotation.center();
	}
}