package pl.shockah.ts.gameplay;

public enum ETime {
	Normal(1d), Slow(1d/3d), Stop(0d);
	
	private final double speed;
	
	private ETime(double speed) {
		this.speed = speed;
	}
	
	public double getSpeed(ITimeAffected timeAffected) {
		switch (this) {
			case Slow: if (timeAffected.affectedSlow()) return getSpeed(); break;
			case Stop: if (timeAffected.affectedStop()) return getSpeed(); break;
			default: break;
		}
		return Normal.getSpeed();
	}
	public double getSpeed() {
		return speed;
	}
}